/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.implement.IncludeRelativePath;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.checkerframework.checker.nullness.qual.NonNull;

public class VelocityEngineUtils {
    private static @NonNull VelocityEngine createVelocityEngine() {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loaders", (Object)"classpath");
        engine.setProperty("resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
        engine.setProperty("event_handler.include.class", (Object)NormalizedIncludeRelativePath.class.getName());
        engine.init();
        return engine;
    }

    public static @NonNull String renderTemplate(String templateName, Map<String, Object> parameters) {
        VelocityEngine engine = VelocityEngineUtils.createVelocityEngine();
        StringWriter writer = new StringWriter();
        VelocityContext context = new VelocityContext(new HashMap<String, Object>(parameters));
        engine.mergeTemplate(templateName, StandardCharsets.UTF_8.name(), (Context)context, (Writer)writer);
        return writer.toString();
    }

    public static class NormalizedIncludeRelativePath
    extends IncludeRelativePath {
        public String includeEvent(Context context, String includeResourcePath, String currentResourcePath, String directiveName) {
            String path = super.includeEvent(context, includeResourcePath, currentResourcePath, directiveName);
            return Path.of(path, new String[0]).normalize().toString();
        }
    }
}

