/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.service;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.function.Function;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;

public class ServiceUtils {
    public static boolean isValidServerAddress(String address) {
        if (new File(address).exists()) {
            return true;
        }
        if (!address.contains("://")) {
            return false;
        }
        try {
            UrlUtils.parseUri((String)address);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    public static Optional<String> getErrorMessageForInvalidIdentifiers(String identifierText, String identifierDescription) {
        Function<String, String> truncate = identifier -> "\"" + StringUtils.removeAll((String)StringUtils.truncateWithThreeDots((String)identifier, (int)9), (String[])new String[]{"\n"}) + "\"";
        if (identifierText.contains("\n")) {
            return Optional.of(identifierDescription + " " + truncate.apply(identifierText) + " contains linebreaks");
        }
        if (identifierText.matches(".*\\p{C}.*")) {
            return Optional.of(identifierDescription + " " + truncate.apply(identifierText) + " contains invisible Unicode control characters");
        }
        if (identifierText.equals("")) {
            return Optional.of(identifierDescription + " is empty");
        }
        return Optional.empty();
    }
}

