/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.service.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.teamscale.commons.service.EMimeType;
import com.teamscale.commons.service.client.ServerDetails;
import com.teamscale.commons.service.client.ServiceCallException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.net.TrustAllCertificatesManager;
import org.conqat.lib.commons.string.StringUtils;

public class ServiceClientUtils {
    public static CloseableHttpClient getHttpClient(ServerDetails serverDetails, boolean disableRedirects) {
        try {
            SSLContext sslContext = SSLContexts.createDefault();
            sslContext.init(null, new TrustManager[]{new TrustAllCertificatesManager()}, new SecureRandom());
            return ServiceClientUtils.getHttpClient(serverDetails, sslContext, null, disableRedirects);
        }
        catch (KeyManagementException e) {
            throw new IllegalStateException("Error creating HTTP client: " + e.getMessage(), e);
        }
    }

    public static CloseableHttpClient getHttpClient(ServerDetails serverDetails) {
        return ServiceClientUtils.getHttpClient(serverDetails, false);
    }

    public static CloseableHttpClient getHttpClient(ServerDetails serverDetails, SSLContext sslContext, String userAgent, boolean disableRedirects) {
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(serverDetails.getUsername(), serverDetails.getPassword()));
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        int timeoutMilliseconds = (int)TimeUnit.SECONDS.toMillis(serverDetails.getTimeoutSeconds());
        requestBuilder = requestBuilder.setConnectTimeout(timeoutMilliseconds);
        requestBuilder = requestBuilder.setSocketTimeout(timeoutMilliseconds);
        requestBuilder = requestBuilder.setConnectionRequestTimeout(timeoutMilliseconds);
        RequestConfig requestConfig = requestBuilder.build();
        HttpClientBuilder clientBuilder = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthenticationInterceptor()).setDefaultRequestConfig(requestConfig);
        if (disableRedirects) {
            clientBuilder.disableRedirectHandling();
        } else {
            clientBuilder.setRedirectStrategy(ServiceClientUtils.getRedirectStrategy());
        }
        if (!StringUtils.isEmpty((String)userAgent)) {
            clientBuilder.setUserAgent(userAgent);
        }
        return clientBuilder.build();
    }

    private static RedirectStrategy getRedirectStrategy() {
        return new LaxRedirectStrategy(){

            public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                URI uri = this.getLocationURI(request, response, context);
                String method = request.getRequestLine().getMethod();
                if (method.equalsIgnoreCase("HEAD")) {
                    return new HttpHead(uri);
                }
                if (method.equalsIgnoreCase("GET")) {
                    return new HttpGet(uri);
                }
                return this.checkStatusRedirect(request, response, uri);
            }

            private HttpUriRequest checkStatusRedirect(HttpRequest request, HttpResponse response, URI uri) {
                int status = response.getStatusLine().getStatusCode();
                if (status == 301 || status == 302 || status == 303 || status == 307 || status == 308) {
                    return RequestBuilder.copy((HttpRequest)request).setUri(uri).build();
                }
                return new HttpGet(uri);
            }
        };
    }

    public static HttpEntity createMultiPartEntityForFiles(String parameterName, List<File> files) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        for (File file : files) {
            FormBodyPart bodyPart = FormBodyPartBuilder.create((String)parameterName, (ContentBody)new FileBody(file, ContentType.APPLICATION_OCTET_STREAM)).build();
            multipartEntityBuilder.addPart(bodyPart);
        }
        return multipartEntityBuilder.build();
    }

    public static <T> T executeRequest(HttpClient client, HttpRequestBase request, EMimeType contentType, FunctionWithException<Reader, T, IOException> deserializeFunction) throws ServiceCallException {
        if (contentType != null) {
            request.setHeader("Accept", contentType.getType());
        }
        try {
            HttpResponse response = client.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: 
                case 202: {
                    return ServiceClientUtils.deserializeEntity(response.getEntity(), deserializeFunction);
                }
                case 204: 
                case 404: {
                    return null;
                }
            }
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new ServiceCallException(request.getURI(), response.getStatusLine().getReasonPhrase(), statusCode, responseBody);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new ServiceCallException("Service call " + String.valueOf(request.getURI()) + " failed:" + e.getMessage(), e);
        }
    }

    private static <T> T deserializeEntity(HttpEntity entity, FunctionWithException<Reader, T, IOException> deserializeFunction) throws IOException {
        if (entity == null) {
            return null;
        }
        InputStream content = entity.getContent();
        if (content == null) {
            return null;
        }
        try (InputStreamReader reader = new InputStreamReader(content, ServiceClientUtils.getCharset(entity));){
            Object result = deserializeFunction.apply((Object)reader);
            CCSMAssert.isFalse((result == reader ? 1 : 0) != 0, (String)"result must not be the same as input reader");
            Object object = result;
            return (T)object;
        }
    }

    public static <T> List<T> arrayToList(T[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf((Object[])array);
    }

    public static <T> Set<T> arrayToSet(T[] array) {
        if (array == null) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf((Object[])array);
    }

    private static Charset getCharset(HttpEntity entity) {
        ContentType defaultContentType;
        ContentType contentType = ContentType.get((HttpEntity)entity);
        Charset charset = null;
        if (contentType != null && (charset = contentType.getCharset()) == null && (defaultContentType = ContentType.getByMimeType((String)contentType.getMimeType())) != null) {
            charset = defaultContentType.getCharset();
        }
        if (charset == null) {
            charset = HTTP.DEF_CONTENT_CHARSET;
        }
        return charset;
    }

    private static class PreemptiveAuthenticationInterceptor
    implements HttpRequestInterceptor {
        private PreemptiveAuthenticationInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) {
            HttpHost targetHost;
            AuthScope authScope;
            CredentialsProvider credentialsProvider;
            Credentials credentials;
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getState() == AuthProtocolState.UNCHALLENGED && (credentials = (credentialsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider")).getCredentials(authScope = new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()))) != null) {
                authState.update((AuthScheme)new BasicScheme(), credentials);
            }
        }
    }
}

