/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ShallowEntityTraversalUtils {
    public static List<ShallowEntity> listAllEntities(Collection<ShallowEntity> entities) {
        return ShallowEntityTraversalUtils.listEntitiesOfTypes(entities, EnumSet.allOf(EShallowEntityType.class));
    }

    public static List<ShallowEntity> listEntitiesOfType(Collection<ShallowEntity> entities, EShallowEntityType type) {
        return ShallowEntityTraversalUtils.listEntitiesOfTypes(entities, EnumSet.of(type));
    }

    public static List<ShallowEntity> listEntitiesOfTypes(Collection<ShallowEntity> entities, final Set<EShallowEntityType> types) {
        return new CollectingVisitorBase(){

            @Override
            protected boolean collect(ShallowEntity entity) {
                return types.contains((Object)entity.getType());
            }
        }.apply(entities);
    }

    public static List<ShallowEntity> listEntitiesOfTypesWithSubtypes(Collection<ShallowEntity> entities, final Set<EShallowEntityType> types, final Set<String> shallowEntitySubtypes) {
        return new CollectingVisitorBase(){

            @Override
            protected boolean collect(ShallowEntity entity) {
                return types.contains((Object)entity.getType()) && shallowEntitySubtypes.contains(entity.getSubtype());
            }
        }.apply(entities);
    }

    public static List<ShallowEntity> selectEntities(Collection<ShallowEntity> entities, final Predicate<ShallowEntity> predicate) {
        return new CollectingVisitorBase(){

            @Override
            protected boolean collect(ShallowEntity entity) {
                return predicate.test(entity);
            }
        }.apply(entities);
    }

    private static ShallowEntity findIncompleteEntity(ShallowEntity entity) {
        if (!entity.isCompleted()) {
            return entity;
        }
        return ShallowEntityTraversalUtils.findIncompleteEntity(entity.getChildren());
    }

    public static ShallowEntity findIncompleteEntity(List<ShallowEntity> entities) {
        for (ShallowEntity entity : entities) {
            ShallowEntity incomplete = ShallowEntityTraversalUtils.findIncompleteEntity(entity);
            if (incomplete == null) continue;
            return incomplete;
        }
        return null;
    }

    public static List<ShallowEntity> getAllEntities(Collection<ShallowEntity> entities) {
        return new CollectingVisitorBase(){

            @Override
            protected boolean collect(ShallowEntity entity) {
                return true;
            }
        }.apply(entities);
    }

    public static List<ShallowEntity> listEntitiesOfTypeNonRecursive(Collection<ShallowEntity> entities, final EShallowEntityType type) {
        final ArrayList<ShallowEntity> methods = new ArrayList<ShallowEntity>();
        ShallowEntity.traverse(entities, new ShallowEntityVisitorBase(){

            @Override
            public boolean visit(ShallowEntity entity) {
                if (entity.getType() == type) {
                    methods.add(entity);
                    return false;
                }
                return true;
            }
        });
        return methods;
    }

    public static List<ShallowEntity> listMethodsNonRecursive(List<ShallowEntity> entities) {
        return ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive(entities, EShallowEntityType.METHOD);
    }

    public static List<ShallowEntity> listMatchingEntitiesRecursive(List<ShallowEntity> entities, final Predicate<ShallowEntity> matchPredicate) {
        return new CollectingVisitorBase(){

            @Override
            protected boolean collect(ShallowEntity entity) {
                return matchPredicate.test(entity);
            }
        }.apply(entities);
    }

    public static List<ShallowEntity> findNestedEntities(List<ShallowEntity> rootEntities, EShallowEntityType ancestorEntityType, Predicate<ShallowEntity> ancestorEntitySelector, EShallowEntityType targetEntityType) {
        return ShallowEntityTraversalUtils.findNestedEntities(rootEntities, EnumSet.of(ancestorEntityType), ancestorEntitySelector, EnumSet.of(targetEntityType));
    }

    public static List<ShallowEntity> findNestedEntities(List<ShallowEntity> rootEntities, Set<EShallowEntityType> ancestorEntityTypes, Predicate<ShallowEntity> ancestorEntitySelector, Set<EShallowEntityType> targetEntityTypes) {
        HashSet<ShallowEntity> selectedTargetEntities = new HashSet<ShallowEntity>();
        List<ShallowEntity> selectedAncestorEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes(rootEntities, ancestorEntityTypes);
        for (ShallowEntity ancestorEntity : selectedAncestorEntities) {
            if (!ancestorEntitySelector.test(ancestorEntity)) continue;
            selectedTargetEntities.addAll(ShallowEntityTraversalUtils.listEntitiesOfTypes(ancestorEntity.getChildren(), targetEntityTypes));
        }
        return selectedTargetEntities.stream().sorted(Comparator.comparing(ShallowEntity::getStartOffset)).collect(Collectors.toList());
    }

    public static void traverseWithKey(List<ShallowEntity> entities, IShallowEntityKeyVisitor visitor) {
        ShallowEntityTraversalUtils.traverseWithKey(entities, visitor, new int[0]);
    }

    private static void traverseWithKey(List<ShallowEntity> entities, IShallowEntityKeyVisitor visitor, int[] parentKey) {
        int length = parentKey.length;
        for (int i = 0; i < entities.size(); ++i) {
            ShallowEntity entity = entities.get(i);
            int[] key = Arrays.copyOf(parentKey, length + 1);
            key[length] = i;
            if (!visitor.visit(key, entity)) continue;
            ShallowEntityTraversalUtils.traverseWithKey(entity.getChildren(), visitor, key);
        }
    }

    public static ShallowEntity getEntityFromListWithKey(List<ShallowEntity> entities, int[] key) {
        if (key.length == 0 || key[0] >= entities.size()) {
            return null;
        }
        ShallowEntity entity = entities.get(key[0]);
        if (key.length == 1) {
            return entity;
        }
        return ShallowEntityTraversalUtils.getEntityFromListWithKey(entity.getChildren(), Arrays.copyOfRange(key, 1, key.length));
    }

    public static ShallowEntity getSubsequentEntity(ShallowEntity entity) {
        boolean found = false;
        while (entity != null && entity.getParent() != null) {
            UnmodifiableList<ShallowEntity> neighboringEntities = entity.getParent().getChildren();
            for (ShallowEntity neighboringEntity : neighboringEntities) {
                if (found) {
                    return neighboringEntity;
                }
                if (!neighboringEntity.equals(entity)) continue;
                found = true;
            }
            entity = entity.getParent();
            found = false;
        }
        return null;
    }

    public static ShallowEntity getSubsequentSiblingEntity(ShallowEntity entity) {
        if (entity.getParent() == null) {
            return null;
        }
        boolean found = false;
        UnmodifiableList<ShallowEntity> siblingEntities = entity.getParent().getChildren();
        for (ShallowEntity siblingEntity : siblingEntities) {
            if (found) {
                return siblingEntity;
            }
            if (!siblingEntity.equals(entity)) continue;
            found = true;
        }
        return null;
    }

    public static ShallowEntity getPreviousEntity(@NonNull ShallowEntity entity) {
        ShallowEntity previousEntity = entity.getParent();
        while (entity != null && entity.getParent() != null) {
            UnmodifiableList<ShallowEntity> neighboringEntities = entity.getParent().getChildren();
            for (ShallowEntity neighboringEntity : neighboringEntities) {
                if (neighboringEntity.equals(entity)) {
                    return previousEntity;
                }
                previousEntity = neighboringEntity;
            }
            entity = entity.getParent();
        }
        return null;
    }

    public static Optional<ShallowEntity> findEntityForLineNonRec(int line, List<ShallowEntity> entities) {
        return ShallowEntityTraversalUtils.findEntityForLine(line, false, entities, false);
    }

    public static Optional<ShallowEntity> findEntityForLine(int line, List<ShallowEntity> entities) {
        return ShallowEntityTraversalUtils.findEntityForLine(line, true, entities, false);
    }

    public static Optional<ShallowEntity> findEntityForLine(int line, List<ShallowEntity> entities, boolean returnSuccessor) {
        return ShallowEntityTraversalUtils.findEntityForLine(line, true, entities, returnSuccessor);
    }

    private static Optional<ShallowEntity> findEntityForLine(final int line, boolean recursive, List<ShallowEntity> entities, boolean returnSuccessor) {
        ShallowEntity comparisonEntity = new ShallowEntity(null, null, null, null, 0){

            @Override
            public int getStartLine() {
                return line;
            }
        };
        int index = Collections.binarySearch(entities, comparisonEntity, Comparator.comparingInt(ShallowEntity::getStartLine));
        if (index < 0) {
            index = -index - 2;
        }
        if (index >= 0 && index < entities.size() && entities.get(index).getStartLine() <= line && line <= entities.get(index).getEndLine()) {
            Optional<ShallowEntity> betterMatch;
            ShallowEntity match = entities.get(index);
            if (recursive && match.hasChildren() && (betterMatch = ShallowEntityTraversalUtils.findEntityForLine(line, match.getChildren(), returnSuccessor)).isPresent()) {
                return betterMatch;
            }
            return Optional.of(match);
        }
        if (returnSuccessor && index + 1 < entities.size()) {
            ShallowEntity match = entities.get(index + 1);
            return Optional.of(match);
        }
        return Optional.empty();
    }

    public static Optional<ShallowEntity> findParentEntity(ShallowEntity startEntity, Predicate<ShallowEntity> shallowEntityPredicate) {
        return ShallowEntityTraversalUtils.findParentEntityAndCountDepth(startEntity, shallowEntityPredicate).map(ImmutablePair::getFirst);
    }

    public static Optional<Pair<ShallowEntity, Integer>> findParentEntityAndCountDepth(ShallowEntity startEntity, Predicate<ShallowEntity> shallowEntityPredicate) {
        ShallowEntity current = startEntity;
        int depth = 0;
        while (current.getParent() != null) {
            ++depth;
            if (!shallowEntityPredicate.test(current = current.getParent())) continue;
            return Optional.of(Pair.createPair((Object)current, (Object)depth));
        }
        return Optional.empty();
    }

    public static Optional<ShallowEntity> findEntityOrParentEntity(ShallowEntity startEntity, Predicate<ShallowEntity> shallowEntityPredicate) {
        ShallowEntity current;
        for (current = startEntity; current != null && !shallowEntityPredicate.test(current); current = current.getParent()) {
        }
        return Optional.ofNullable(current);
    }

    public static List<ShallowEntity> findMatchingParentEntities(ShallowEntity startEntity, Predicate<ShallowEntity> shallowEntityPredicate) {
        ArrayList<ShallowEntity> parentEntities = new ArrayList<ShallowEntity>();
        ShallowEntity current = startEntity;
        while (current.getParent() != null) {
            if (!shallowEntityPredicate.test(current = current.getParent())) continue;
            parentEntities.add(current);
        }
        return parentEntities;
    }

    public static Optional<ShallowEntity> findParentEntityWithSubType(ShallowEntity startEntity, String subtype) {
        return ShallowEntityTraversalUtils.findParentEntity(startEntity, entity -> entity.getSubtype().equals(subtype));
    }

    public static Optional<ShallowEntity> getPreviousEntityWithSubtype(ShallowEntity entity, String ... subtypes) {
        ShallowEntity parent = entity.getParent();
        Optional<ShallowEntity> previousEntity = Optional.empty();
        if (parent != null) {
            UnmodifiableList<ShallowEntity> neighboringEntities = parent.getChildren();
            for (ShallowEntity neighboringEntity : neighboringEntities) {
                if (neighboringEntity == entity) {
                    return previousEntity;
                }
                if (!ArrayUtils.contains((Object[])subtypes, (Object)neighboringEntity.getSubtype())) continue;
                previousEntity = Optional.of(neighboringEntity);
            }
        }
        return Optional.empty();
    }

    public static Optional<ShallowEntity> findContainingEntityDepthFirst(IToken token, List<ShallowEntity> shallowEntities) {
        for (int i = 0; i < shallowEntities.size(); ++i) {
            ShallowEntity entity = shallowEntities.get(i);
            if (!entity.includedTokens().contains((Object)token)) continue;
            if (entity.getType() == EShallowEntityType.META) {
                while (shallowEntities.get(i).getType() == EShallowEntityType.META && i < shallowEntities.size() - 1) {
                    ++i;
                }
                if (shallowEntities.get(i).getType() != EShallowEntityType.META) {
                    return Optional.of(shallowEntities.get(i));
                }
                return Optional.empty();
            }
            Optional<ShallowEntity> childContainingToken = ShallowEntityTraversalUtils.findContainingEntityDepthFirst(token, entity.getChildren());
            if (childContainingToken.isPresent()) {
                return childContainingToken;
            }
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    public static interface IShallowEntityKeyVisitor {
        public boolean visit(int[] var1, ShallowEntity var2);
    }

    public static abstract class CollectingVisitorBase
    extends ShallowEntityVisitorBase {
        private final List<ShallowEntity> entities = new ArrayList<ShallowEntity>();

        @Override
        public boolean visit(ShallowEntity entity) {
            if (this.collect(entity)) {
                this.entities.add(entity);
            }
            return true;
        }

        protected abstract boolean collect(ShallowEntity var1);

        public List<ShallowEntity> apply(Collection<ShallowEntity> entities) {
            ShallowEntity.traverse(entities, this);
            return this.entities;
        }
    }

    public static abstract class ShallowEntityVisitorBase
    implements IShallowEntityVisitor {
        @Override
        public boolean visit(ShallowEntity entity) {
            return true;
        }

        @Override
        public void endVisit(ShallowEntity entity) {
        }
    }
}

