/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.util;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;

public class SourceCodeMessageUtils {
    public static String createMessage(String message, ShallowEntity entity) {
        return SourceCodeMessageUtils.createMessage(message, (List<IToken>)entity.ownStartTokens(), entity);
    }

    public static String createMessage(String message, List<IToken> tokens, @Nullable ShallowEntity entity) {
        String origin = TokenStreamUtils.determineMostSpecificOrigin(tokens);
        if (entity != null) {
            origin = TokenStreamUtils.determineMostSpecificOrigin((Collection)entity.getAllTokensOfFile());
        }
        if (tokens.isEmpty()) {
            return message + "\nOccurred at an unknown location";
        }
        return SourceCodeMessageUtils.createMessage(message + "\nTokens: " + TokenStreamTextUtils.concatTokenTexts(tokens, (String)" "), tokens.get(0), (IToken)CollectionUtils.getLast(tokens), origin);
    }

    private static String createMessage(String message, IToken startToken, IToken endToken, String origin) {
        return message + "\nOccurred in " + origin + ":" + startToken.getLineNumber() + "-" + endToken.getLineNumber();
    }
}

