/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils.type;

import java.util.function.Predicate;
import org.sonar.php.checks.utils.type.TreeKindPredicate;
import org.sonar.php.checks.utils.type.TreeValues;
import org.sonar.php.checks.utils.type.TypePredicateList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;

public class ObjectMemberFunctionCall
extends TreeKindPredicate<FunctionCallTree> {
    private final String name;
    private final TypePredicateList nestedPredicates;

    public ObjectMemberFunctionCall(String name, Predicate<TreeValues> ... nestedPredicates) {
        super(Tree.Kind.FUNCTION_CALL);
        this.name = name;
        this.nestedPredicates = new TypePredicateList(nestedPredicates);
    }

    @Override
    protected boolean matches(TreeValues possibleValues, FunctionCallTree functionCall) {
        ExpressionTree callee = functionCall.callee();
        if (callee.is(Tree.Kind.OBJECT_MEMBER_ACCESS)) {
            MemberAccessTree memberAccess = (MemberAccessTree)callee;
            return memberAccess.member().is(Tree.Kind.NAME_IDENTIFIER) && this.name.equalsIgnoreCase(((NameIdentifierTree)memberAccess.member()).text()) && this.nestedPredicates.test(possibleValues.lookupPossibleValues(memberAccess.object()));
        }
        return false;
    }
}

