/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.symbols;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.utils.Preconditions;
import org.sonar.php.api.PHPKeyword;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.VariableIdentifierTreeImpl;
import org.sonar.php.tree.symbols.NamespaceNameResolvingVisitor;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.php.tree.symbols.SymbolImpl;
import org.sonar.php.tree.symbols.SymbolTableImpl;
import org.sonar.php.tree.symbols.TypeSymbolImpl;
import org.sonar.php.utils.SourceBuilder;
import org.sonar.plugins.php.api.symbols.MemberSymbol;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.ConstantDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.DeclaredTypeTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.declaration.PropertyHookListTree;
import org.sonar.plugins.php.api.tree.declaration.ReturnTypeClauseTree;
import org.sonar.plugins.php.api.tree.declaration.TypeTree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ArrowFunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.CompoundVariableTree;
import org.sonar.plugins.php.api.tree.expression.ComputedVariableTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.tree.expression.LexicalVariablesTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.GlobalStatementTree;
import org.sonar.plugins.php.api.tree.statement.NamespaceStatementTree;
import org.sonar.plugins.php.api.tree.statement.StaticStatementTree;
import org.sonar.plugins.php.api.tree.statement.UseTraitDeclarationTree;

public class SymbolVisitor
extends NamespaceNameResolvingVisitor {
    private static final Set<String> BUILT_IN_VARIABLES = Set.of("$this", "$GLOBALS", "$_SERVER", "$_GET", "$_POST", "$_FILES", "$_SESSION", "$_ENV", "$php_errormsg", "$HTTP_RAW_POST_DATA", "$http_response_header", "$_COOKIE", "$_REQUEST");
    private static final Set<String> SELF_OBJECTS = Set.of("$this", "self", "static");
    private final Deque<Scope> classScopes = new ArrayDeque<Scope>();
    private final Map<Symbol, Scope> scopeBySymbol = new HashMap<Symbol, Scope>();
    private Scope currentScope = null;
    private Scope globalScope = null;
    private ClassMemberUsageState classMemberUsageState = null;

    public SymbolVisitor(SymbolTableImpl symbolTable) {
        super(symbolTable);
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.currentScope = this.globalScope = this.symbolTable.addScope(new Scope(tree));
        super.visitCompilationUnit(tree);
    }

    @Override
    public void visitNamespaceStatement(NamespaceStatementTree tree) {
        this.enterScope(tree);
        super.visitNamespaceStatement(tree);
        if (this.isBracketedNamespace(tree)) {
            this.leaveScope();
        }
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.enterScope(tree);
        this.resolveDeclaredTypeNamespaceName(tree.returnTypeClause());
        super.visitFunctionDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.enterScope(tree);
        super.visitFunctionExpression(tree);
        this.leaveScope();
    }

    @Override
    public void visitArrowFunctionExpression(ArrowFunctionExpressionTree tree) {
        this.enterArrowFunctionScope(tree);
        super.visitArrowFunctionExpression(tree);
        this.leaveScope();
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.enterScope(tree);
        this.resolveDeclaredTypeNamespaceName(tree.returnTypeClause());
        super.visitMethodDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitClassPropertyDeclaration(ClassPropertyDeclarationTree tree) {
        this.scan(tree.attributeGroups());
        this.resolveDeclaredTypeNamespaceName(tree.declaredType());
        PropertyHookListTree propertyHookListTree = tree.propertyHookList();
        if (propertyHookListTree != null) {
            this.scan(propertyHookListTree);
        }
    }

    @Override
    public void visitParameterList(ParameterListTree tree) {
        tree.parameters().forEach(t -> this.resolveDeclaredTypeNamespaceName(t.declaredType()));
        super.visitParameterList(tree);
    }

    private void resolveDeclaredTypeNamespaceName(@Nullable ReturnTypeClauseTree returnType) {
        if (returnType != null) {
            this.resolveDeclaredTypeNamespaceName(returnType.declaredType());
        }
    }

    private void resolveDeclaredTypeNamespaceName(@Nullable DeclaredTypeTree type) {
        if (type != null && type.isSimple() && ((TypeTree)type).typeName().is(Tree.Kind.NAMESPACE_NAME)) {
            this.lookupOrCreateUndeclaredSymbol((NamespaceNameTree)((TypeTree)type).typeName());
        }
    }

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        TypeSymbolImpl classSymbol = (TypeSymbolImpl)this.symbolTable.getSymbol(tree.name());
        Objects.requireNonNull(classSymbol, () -> String.format("Symbol for %s not found", tree));
        this.scan(tree.attributeGroups());
        this.enterScope(tree);
        this.classScopes.push(this.currentScope);
        this.scan(tree.name());
        NamespaceNameTree superClass = tree.superClass();
        if (superClass != null) {
            Symbol superClassSymbol = this.lookupOrCreateUndeclaredSymbol(superClass);
            this.currentClassScope().superClassScope = this.scopeBySymbol.get(superClassSymbol);
            classSymbol.setSuperClass(superClassSymbol);
        }
        this.scopeBySymbol.put(classSymbol, this.currentClassScope());
        tree.superInterfaces().forEach(ifaceTree -> {
            Symbol ifaceSymbol = this.lookupOrCreateUndeclaredSymbol((NamespaceNameTree)ifaceTree);
            classSymbol.addInterface(ifaceSymbol);
        });
        this.createMemberSymbols(tree, classSymbol);
        this.scan(tree.members());
        this.classScopes.pop();
        this.leaveScope();
    }

    @Override
    public void visitUseTraitDeclaration(UseTraitDeclarationTree tree) {
        tree.traits().forEach(trait -> this.usageForNamespaceName((NamespaceNameTree)trait, Symbol.Kind.CLASS));
    }

    private Symbol lookupOrCreateUndeclaredSymbol(NamespaceNameTree superClass) {
        QualifiedName qualifiedName = this.getFullyQualifiedName(superClass, Symbol.Kind.CLASS);
        SymbolImpl superClassSymbol = (SymbolImpl)this.symbolTable.getSymbol(qualifiedName);
        if (superClassSymbol == null) {
            superClassSymbol = this.symbolTable.createUndeclaredSymbol(qualifiedName, Symbol.Kind.CLASS);
        }
        this.associateSymbol(superClass.name(), superClassSymbol);
        return superClassSymbol;
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.scan(tree.arguments());
        this.scan(tree.attributeGroups());
        this.enterScope(tree);
        this.classScopes.push(this.currentScope);
        this.createMemberSymbols(tree, null);
        NamespaceNameTree superClass = tree.superClass();
        if (superClass != null) {
            this.lookupOrCreateUndeclaredSymbol(superClass);
        }
        tree.superInterfaces().forEach(this::lookupOrCreateUndeclaredSymbol);
        this.scan(tree.members());
        this.classScopes.pop();
        this.leaveScope();
    }

    private void createMemberSymbols(ClassTree tree, @Nullable TypeSymbolImpl classSymbol) {
        for (ClassMemberTree member : tree.members()) {
            if (member.is(Tree.Kind.METHOD_DECLARATION)) {
                SymbolImpl symbol = this.createMemberSymbol(classSymbol, ((MethodDeclarationTree)member).name(), Symbol.Kind.FUNCTION);
                symbol.addModifiers(((MethodDeclarationTree)member).modifiers());
                continue;
            }
            if (!member.is(Tree.Kind.CLASS_CONSTANT_PROPERTY_DECLARATION, Tree.Kind.CLASS_PROPERTY_DECLARATION)) continue;
            ClassPropertyDeclarationTree classPropertyDeclaration = (ClassPropertyDeclarationTree)member;
            for (VariableDeclarationTree field : classPropertyDeclaration.declarations()) {
                SymbolImpl symbol = this.createMemberSymbol(classSymbol, field.identifier(), Symbol.Kind.FIELD);
                symbol.addModifiers(classPropertyDeclaration.modifierTokens());
                ExpressionTree initValue = field.initValue();
                if (initValue == null) continue;
                initValue.accept(this);
            }
        }
    }

    private SymbolImpl createMemberSymbol(@Nullable TypeSymbolImpl classSymbol, IdentifierTree identifier, Symbol.Kind kind) {
        SymbolImpl symbol;
        if (classSymbol != null) {
            symbol = this.symbolTable.declareMemberSymbol(identifier, kind, this.currentClassScope(), classSymbol);
            classSymbol.addMember((MemberSymbol)((Object)symbol));
        } else {
            symbol = this.symbolTable.declareSymbol(identifier, kind, this.currentScope, this.currentNamespace());
        }
        return symbol;
    }

    @Override
    public void visitConstDeclaration(ConstantDeclarationTree tree) {
        for (VariableDeclarationTree constant : tree.declarations()) {
            this.createSymbol(constant.identifier(), Symbol.Kind.VARIABLE).addModifiers(Collections.singletonList(tree.constToken()));
        }
        super.visitConstDeclaration(tree);
    }

    @Override
    public void visitVariableIdentifier(VariableIdentifierTree tree) {
        if (!SymbolVisitor.isBuiltInVariable(tree)) {
            if (this.classMemberUsageState == null) {
                this.createOrUseVariableIdentifierSymbol(tree);
            } else {
                SymbolImpl symbol;
                if (this.classMemberUsageState.isSelfMember && this.isInClassScope() && this.classMemberUsageState.isStatic && (symbol = (SymbolImpl)this.currentClassScope().getSymbol(tree.text(), Symbol.Kind.FIELD)) != null) {
                    this.associateSymbol(tree, symbol);
                }
                if ((symbol = (SymbolImpl)this.currentScope.getSymbol(tree.text(), Symbol.Kind.VARIABLE, Symbol.Kind.PARAMETER)) != null) {
                    this.associateSymbol(tree, symbol);
                }
                this.classMemberUsageState = null;
            }
        }
    }

    private void createOrUseVariableIdentifierSymbol(VariableIdentifierTree identifier) {
        SymbolImpl symbol = (SymbolImpl)this.currentScope.getSymbol(identifier.text(), Symbol.Kind.PARAMETER);
        if (symbol == null) {
            this.createSymbol(identifier, Symbol.Kind.VARIABLE);
            return;
        }
        this.associateSymbol(identifier, symbol);
    }

    @Override
    public void visitToken(SyntaxToken token) {
        if (this.classMemberUsageState != null && this.classMemberUsageState.isStatic && token.text().equals(PHPKeyword.CLASS.getValue())) {
            this.classMemberUsageState = null;
        }
        super.visitToken(token);
    }

    @Override
    public void visitNameIdentifier(NameIdentifierTree tree) {
        if (this.classMemberUsageState != null && this.isInClassScope()) {
            this.resolveProperty(tree);
        } else {
            this.resolveSymbol(tree);
        }
        this.classMemberUsageState = null;
    }

    private Symbol resolveSymbol(IdentifierTree tree) {
        SymbolImpl symbol = null;
        for (Scope outer = this.currentScope; outer != null; outer = outer.outer()) {
            symbol = (SymbolImpl)outer.getSymbol(tree.text(), Symbol.Kind.CLASS);
            if (symbol == null) continue;
            this.associateSymbol(tree, symbol);
            break;
        }
        return symbol;
    }

    private void resolveProperty(NameIdentifierTree tree) {
        SymbolImpl symbol;
        Object name = tree.text();
        Symbol.Kind kind = Symbol.Kind.FUNCTION;
        if (this.classMemberUsageState.isField) {
            name = (this.classMemberUsageState.isConst ? "" : "$") + (String)name;
            kind = Symbol.Kind.FIELD;
        }
        if ((symbol = (SymbolImpl)this.currentClassScope().getSymbol((String)name, kind)) != null) {
            this.associateSymbol(tree, symbol);
        }
    }

    private static boolean isBuiltInVariable(VariableIdentifierTree tree) {
        return BUILT_IN_VARIABLES.contains(tree.text());
    }

    @Override
    public void visitCompoundVariable(CompoundVariableTree tree) {
        SymbolImpl symbol;
        SyntaxToken firstExpressionToken = ((PHPTree)((Object)tree.variableExpression())).getFirstToken();
        if (firstExpressionToken.text().charAt(0) != '$' && (symbol = (SymbolImpl)this.currentScope.getSymbol("$" + firstExpressionToken.text(), new Symbol.Kind[0])) != null) {
            this.associateSymbol(firstExpressionToken, symbol);
        }
        super.visitCompoundVariable(tree);
    }

    @Override
    public void visitParameter(ParameterTree tree) {
        PropertyHookListTree propertyHookListTree;
        this.scan(tree.attributeGroups());
        this.createSymbol(tree.variableIdentifier(), Symbol.Kind.PARAMETER);
        ExpressionTree initValue = tree.initValue();
        if (initValue != null) {
            initValue.accept(this);
        }
        if ((propertyHookListTree = tree.propertyHookList()) != null) {
            this.scan(propertyHookListTree);
        }
    }

    @Override
    public void visitGlobalStatement(GlobalStatementTree tree) {
        for (VariableTree variable : tree.variables()) {
            if (variable.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                IdentifierTree identifier = (IdentifierTree)variable.variableExpression();
                SymbolImpl symbol = (SymbolImpl)this.globalScope.getSymbol(identifier.text(), Symbol.Kind.VARIABLE);
                if (symbol != null) {
                    this.associateSymbol(identifier, symbol);
                    this.currentScope.addSymbol(symbol);
                } else {
                    symbol = this.createSymbol(identifier, Symbol.Kind.VARIABLE);
                }
                symbol.addModifiers(Collections.singletonList(tree.globalToken()));
                continue;
            }
            if (!variable.is(Tree.Kind.COMPOUND_VARIABLE_NAME)) continue;
            this.visitCompoundVariable((CompoundVariableTree)variable);
        }
    }

    @Override
    public void visitStaticStatement(StaticStatementTree tree) {
        super.visitStaticStatement(tree);
        for (VariableDeclarationTree variable : tree.variables()) {
            SymbolImpl symbol = (SymbolImpl)this.currentScope.getSymbol(variable.identifier().text(), Symbol.Kind.VARIABLE);
            if (symbol == null) continue;
            symbol.addModifiers(Collections.singletonList(tree.staticToken()));
        }
    }

    @Override
    public void visitLexicalVariables(LexicalVariablesTree tree) {
        for (VariableTree variable : tree.variables()) {
            IdentifierTree identifier = null;
            if (variable.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                identifier = (IdentifierTree)variable.variableExpression();
            } else if (variable.is(Tree.Kind.REFERENCE_VARIABLE) && variable.variableExpression().is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                identifier = ((VariableIdentifierTree)variable.variableExpression()).variableExpression();
            }
            if (identifier == null) continue;
            SymbolImpl symbol = (SymbolImpl)this.currentScope.outer().getSymbol(identifier.text(), new Symbol.Kind[0]);
            if (symbol != null) {
                this.associateSymbol(identifier, symbol);
            } else if (variable.is(Tree.Kind.REFERENCE_VARIABLE)) {
                this.symbolTable.declareSymbol(identifier, Symbol.Kind.VARIABLE, this.currentScope.outer(), this.currentNamespace());
            }
            this.createSymbol(identifier, Symbol.Kind.VARIABLE);
        }
    }

    @Override
    public void visitNewExpression(NewExpressionTree tree) {
        if (tree.expression().is(Tree.Kind.NAMESPACE_NAME)) {
            this.usageForNamespaceName((NamespaceNameTree)tree.expression(), Symbol.Kind.CLASS);
            return;
        }
        if (tree.expression().is(Tree.Kind.FUNCTION_CALL)) {
            ExpressionTree callee = ((FunctionCallTree)tree.expression()).callee();
            if (callee.is(Tree.Kind.NAMESPACE_NAME)) {
                this.usageForNamespaceName((NamespaceNameTree)callee, Symbol.Kind.CLASS);
                FunctionCallTree functionCall = (FunctionCallTree)tree.expression();
                this.scan(functionCall.callArguments().stream().map(CallArgumentTree::value).toList());
                return;
            }
        }
        super.visitNewExpression(tree);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        this.visitFunctionCall(tree, true);
    }

    public void visitFunctionCall(FunctionCallTree tree, boolean recursive) {
        if (tree.callee().is(Tree.Kind.NAMESPACE_NAME)) {
            this.usageForNamespaceName((NamespaceNameTree)tree.callee(), Symbol.Kind.FUNCTION);
        } else if (recursive) {
            tree.callee().accept(this);
        }
        String callee = SourceBuilder.build(tree.callee()).trim();
        if ("compact".equals(callee) || "\\compact".equals(callee)) {
            this.visitCompactFunctionCall(tree.callArguments());
        }
        this.scan(tree.callArguments().stream().map(CallArgumentTree::value).toList());
    }

    private void visitCompactFunctionCall(SeparatedList<CallArgumentTree> arguments) {
        for (CallArgumentTree argument : arguments) {
            ExpressionTree argumentExpression = argument.value();
            if (argumentExpression.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
                String value = ((LiteralTree)argumentExpression).value();
                String variableName = "$" + value.substring(1, value.length() - 1);
                SymbolImpl symbol = (SymbolImpl)this.currentScope.getSymbol(variableName, Symbol.Kind.VARIABLE, Symbol.Kind.PARAMETER);
                if (symbol == null) continue;
                this.associateSymbol(((LiteralTree)argumentExpression).token(), symbol);
                continue;
            }
            this.currentScope.setUnresolvedCompact(true);
        }
    }

    private void usageForNamespaceName(NamespaceNameTree namespaceName, Symbol.Kind kind) {
        if (namespaceName.name().is(Tree.Kind.NAME_IDENTIFIER)) {
            NameIdentifierTree usageIdentifier = (NameIdentifierTree)namespaceName.name();
            QualifiedName qualifiedName = this.getFullyQualifiedName(namespaceName, kind);
            SymbolImpl symbol = (SymbolImpl)this.symbolTable.getSymbol(qualifiedName);
            if (symbol == null && namespaceName.namespaces().isEmpty()) {
                symbol = (SymbolImpl)this.currentScope.getSymbol(usageIdentifier.text(), kind);
            }
            if (symbol == null) {
                symbol = this.symbolTable.createUndeclaredSymbol(this.getFullyQualifiedName(namespaceName, kind), kind);
            }
            if (symbol != null) {
                this.associateSymbol(usageIdentifier, symbol);
            }
        }
    }

    @Override
    public void visitMemberAccess(MemberAccessTree tree) {
        boolean isCallChain = tree.object().is(Tree.Kind.FUNCTION_CALL);
        if (isCallChain) {
            ExpressionTree current = tree;
            while (current != null) {
                if (current instanceof MemberAccessTree) {
                    MemberAccessTree memberAccessTree = current;
                    this.visitMemberAccess(memberAccessTree, false);
                    current = memberAccessTree.object();
                    continue;
                }
                if (current instanceof FunctionCallTree) {
                    FunctionCallTree functionCallTree = (FunctionCallTree)current;
                    this.visitFunctionCall(functionCallTree, false);
                    current = functionCallTree.callee();
                    continue;
                }
                if (!current.is(Tree.Kind.NAMESPACE_NAME)) {
                    current.accept(this);
                }
                current = null;
            }
        } else {
            this.visitMemberAccess(tree, true);
        }
    }

    public void visitMemberAccess(MemberAccessTree tree, boolean recursive) {
        if (tree.object().is(Tree.Kind.NAMESPACE_NAME)) {
            this.usageForNamespaceName((NamespaceNameTree)tree.object(), Symbol.Kind.CLASS);
        } else if (recursive) {
            tree.object().accept(this);
        }
        boolean isFunctionCall = tree.getParent().is(Tree.Kind.FUNCTION_CALL) && ((FunctionCallTree)tree.getParent()).callee() == tree;
        this.classMemberUsageState = new ClassMemberUsageState();
        this.classMemberUsageState.isStatic = tree.isStatic();
        this.classMemberUsageState.isSelfMember = SymbolVisitor.isSelfMember(tree);
        this.classMemberUsageState.isField = !isFunctionCall;
        this.classMemberUsageState.isConst = this.classMemberUsageState.isField && tree.isStatic();
        tree.member().accept(this);
    }

    private static boolean isSelfMember(MemberAccessTree tree) {
        String strObject = SourceBuilder.build(tree.object()).trim();
        return SELF_OBJECTS.contains(strObject.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void visitComputedVariable(ComputedVariableTree tree) {
        this.classMemberUsageState = null;
        super.visitComputedVariable(tree);
    }

    private void leaveScope() {
        Preconditions.checkState(this.currentScope != null, "Current scope should never be null when calling method \"leaveScope\"");
        this.currentScope = this.currentScope.outer();
    }

    private void enterScope(Tree tree) {
        this.currentScope = this.symbolTable.addScope(new Scope(this.currentScope, tree, false));
    }

    private void enterArrowFunctionScope(Tree tree) {
        this.currentScope = this.symbolTable.addScope(new Scope(this.currentScope, tree, true));
    }

    private SymbolImpl createSymbol(IdentifierTree identifier, Symbol.Kind kind) {
        SymbolImpl symbol = (SymbolImpl)this.currentScope.getSymbol(identifier.text(), kind);
        if (symbol == null) {
            symbol = this.symbolTable.declareSymbol(identifier, kind, this.currentScope, this.currentNamespace());
            SymbolVisitor.assignSymbolToIdentifier(identifier, symbol);
        } else {
            this.associateSymbol(identifier, symbol);
        }
        return symbol;
    }

    private void associateSymbol(IdentifierTree tree, SymbolImpl symbol) {
        symbol.addUsage(tree);
        this.symbolTable.associateSymbol(tree, symbol);
        SymbolVisitor.assignSymbolToIdentifier(tree, symbol);
    }

    private static void assignSymbolToIdentifier(IdentifierTree tree, SymbolImpl symbol) {
        if (tree instanceof VariableIdentifierTree) {
            ((VariableIdentifierTreeImpl)tree).setSymbol(symbol);
        }
    }

    private void associateSymbol(SyntaxToken token, SymbolImpl symbol) {
        symbol.addUsage(token);
        this.symbolTable.associateSymbol(token, symbol);
    }

    private Scope currentClassScope() {
        return this.classScopes.peek();
    }

    private boolean isInClassScope() {
        return !this.classScopes.isEmpty();
    }

    static class ClassMemberUsageState {
        boolean isStatic = false;
        boolean isField = false;
        boolean isSelfMember = false;
        boolean isConst = false;

        ClassMemberUsageState() {
        }
    }
}

