/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.ArrayList;
import java.util.List;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassUnionTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.helpers.GraphemeHelper;

public class GraphemeInClassFinder
extends RegexBaseVisitor {
    private static final String MESSAGE = "Extract %d Grapheme Cluster(s) from this character class.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;
    private final List<RegexIssueLocation> graphemeClusters = new ArrayList<RegexIssueLocation>();

    public GraphemeInClassFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitCharacterClass(CharacterClassTree tree) {
        super.visitCharacterClass(tree);
        if (!this.graphemeClusters.isEmpty()) {
            this.regexElementIssueReporter.report(tree, String.format(MESSAGE, this.graphemeClusters.size()), null, this.graphemeClusters);
        }
        this.graphemeClusters.clear();
    }

    @Override
    public void visitCharacterClassUnion(CharacterClassUnionTree tree) {
        this.graphemeClusters.addAll(GraphemeHelper.getGraphemeInList(tree.getCharacterClasses()));
        super.visitCharacterClassUnion(tree);
    }
}

