/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.registry;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.registry.CheckMapping;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.resources.Resource;

public class CheckMappingUtils {
    private static final String META_INF_MAPPINGS_LOCATION = "META-INF/check-mappings.tsv";
    private static final Map<String, Map<String, CheckMapping>> CHECK_ENABLEMENT_CACHE = new HashMap<String, Map<String, CheckMapping>>();

    public static CheckMapping loadRuleEnablementForClass(Class<?> checkClass, Check checkAnnotation) throws CheckException {
        if (CheckMappingUtils.checkShouldHaveEntryInCheckMappings(checkClass)) {
            CCSMAssert.isFalse((boolean)checkAnnotation.id().isEmpty(), (String)"Internal custom checks must have an ID.");
            CCSMAssert.isTrue((boolean)checkAnnotation.name().isEmpty(), (String)"Internal custom checks must not have a name set in the annotation. The name should be specified in the check-mappings.tsv only!");
            Optional<CheckMapping> item = CheckMappingUtils.fromCheckMappingTsv(checkClass, checkAnnotation.id());
            return item.orElseThrow(() -> new CheckException(checkClass.getSimpleName() + " does not have an entry in check-mappings.tsv!"));
        }
        CCSMAssert.isTrue((boolean)checkAnnotation.id().isEmpty(), (String)"Custom checks must not have an ID.");
        CCSMAssert.isFalse((boolean)checkAnnotation.name().isEmpty(), (String)"A custom check must have a name set.");
        Optional<CheckMapping> item = CheckMappingUtils.fromCheckAnnotation(checkAnnotation);
        return item.orElseThrow(() -> new CheckException("No check mapping found for " + checkAnnotation.name() + "!"));
    }

    private static Optional<CheckMapping> fromCheckMappingTsv(Class<?> checkClass, String checkId) throws CheckException {
        try {
            ArrayList<URL> urls = Collections.list(checkClass.getClassLoader().getResources(META_INF_MAPPINGS_LOCATION));
            return CheckMappingUtils.findCheckMappingItem(urls, checkClass, checkId);
        }
        catch (IOException e) {
            throw new CheckException("Failed to read check-mappings.tsv", e);
        }
    }

    private static Optional<CheckMapping> fromCheckAnnotation(Check checkAnnotation) {
        String groupName = checkAnnotation.groupName();
        String categoryName = checkAnnotation.categoryName();
        EFindingEnablement defaultEnablement = checkAnnotation.defaultEnablement();
        if (groupName.isEmpty() || categoryName.isEmpty()) {
            return Optional.empty();
        }
        String checkId = checkAnnotation.id();
        if (checkId.isEmpty()) {
            checkId = checkAnnotation.name();
        }
        return Optional.of(new CheckMapping(checkId, checkAnnotation.name(), categoryName, groupName, defaultEnablement));
    }

    public static boolean checkShouldHaveEntryInCheckMappings(Class<?> checkClass) {
        String packageName = checkClass.getPackage().getName();
        return packageName.startsWith("eu.cqse.") && !packageName.startsWith("eu.cqse.check.sample") || packageName.startsWith("com.teamscale.check.") && !packageName.equals("com.teamscale.check.mockframeworktest") || packageName.startsWith("org.conqat.engine.abap.");
    }

    private static Optional<CheckMapping> findCheckMappingItem(List<URL> urls, Class<?> checkClass, String checkId) {
        return urls.stream().map(url -> CheckMappingUtils.findCheckMappingItem(url, checkClass, checkId)).filter(Objects::nonNull).findFirst();
    }

    private static CheckMapping findCheckMappingItem(URL url, Class<?> checkClass, String checkId) {
        return (CheckMapping)CHECK_ENABLEMENT_CACHE.computeIfAbsent(url.toExternalForm(), newUrl -> {
            Resource mappings = Resource.of((Class)checkClass, (String)"/META-INF/check-mappings.tsv", (URL)url);
            return CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv(mappings);
        }).get(checkId);
    }
}

