/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import eu.cqse.check.framework.core.ShallowEntityUtils;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class CPreprocessingUtils {
    static final TextRegionLocation LOCATION_FOR_INTERNAL_DEFAULT_DEFINES = new TextRegionLocation("INTERNAL_DEFAULT_DEFINES", 0, 0, 0, 0);
    public static final EnumSet<ELanguage> C_PREPROCESSOR_LANGUAGES = LanguageGroups.C_AND_DERIVATIVES;

    public static List<IToken> scanMacroContent(String content, ELanguage language) {
        return CollectionUtils.asUnmodifiable(ScannerUtils.getTokens(content, language, "##macro##"));
    }

    public static @NonNull String getFillerSpaces(String logMessage, int maxAssumedMessageLength) {
        int numFillerSpaces = maxAssumedMessageLength + 1 - logMessage.length();
        if (numFillerSpaces <= 0) {
            return "";
        }
        return StringUtils.repeat((String)" ", (int)(maxAssumedMessageLength + 1 - logMessage.length()));
    }

    public static List<IToken> applyReplacements(List<PreprocessorTokenReplacement> replacements, List<IToken> tokens) {
        if (replacements.isEmpty()) {
            return tokens;
        }
        Iterator<PreprocessorTokenReplacement> replacementsIterator = replacements.iterator();
        PreprocessorTokenReplacement currentReplacement = replacementsIterator.next();
        ArrayList<IToken> result = new ArrayList<IToken>();
        for (int i = 0; i < tokens.size(); ++i) {
            while (currentReplacement.countReplacedTokens() == 0 && replacementsIterator.hasNext()) {
                currentReplacement = replacementsIterator.next();
            }
            if (i >= currentReplacement.originalTokensEndIndex && replacementsIterator.hasNext()) {
                currentReplacement = replacementsIterator.next();
            }
            if (i < currentReplacement.originalTokensStartIndex || i >= currentReplacement.originalTokensEndIndex) {
                result.add(tokens.get(i));
                continue;
            }
            if (i != currentReplacement.originalTokensStartIndex) continue;
            result.addAll(currentReplacement.replacementTokens);
            i = currentReplacement.originalTokensEndIndex - 1;
        }
        return result;
    }

    static TextRegionLocation locationFromToken(IToken token) {
        return new TextRegionLocation(token.getOriginId(), token.getOffset(), token.getEndOffset(), token.getLineNumber(), token.getLineNumber() + StringUtils.countLines((String)token.getText()));
    }

    static List<IToken> concat(List<IToken> list1, List<IToken> list2) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        result.addAll(list1);
        result.addAll(list2);
        return result;
    }

    public static void removePreprocessorTokens(List<ShallowEntity> entities) {
        ShallowEntity.filterTokens(entities, PreprocessedTokenStreamUtils::isTokenMacroExpanded);
        ShallowEntity.collapseEmptyEntities(entities);
    }

    public static void revertPreprocessedTokens(List<ShallowEntity> entities, List<IToken> rawTokens) {
        if (entities.isEmpty()) {
            return;
        }
        List tokens = ((ShallowEntity)CollectionUtils.getAny(entities)).getAllTokensOfFile();
        ArrayList<Integer> indexLookup = new ArrayList<Integer>();
        List<IToken> newTokens = CPreprocessingUtils.getRevertedPreprocessedTokens(tokens, rawTokens, indexLookup);
        tokens.clear();
        tokens.addAll(newTokens);
        ShallowEntity.traverse(entities, entity -> {
            entity.setStartTokenIndex(((Integer)indexLookup.get(entity.getStartTokenIndex())).intValue());
            if (entity.getEndTokenIndex() >= 0) {
                entity.setEndTokenIndex(((Integer)indexLookup.get(entity.getEndTokenIndex())).intValue());
            }
            return true;
        });
        ShallowEntity.collapseEmptyEntities(entities);
    }

    private static List<IToken> getRevertedPreprocessedTokens(List<IToken> tokens, List<IToken> rawTokens, List<Integer> indexLookup) {
        ArrayList<IToken> newTokens = new ArrayList<IToken>();
        HashSet<Integer> doneMacros = new HashSet<Integer>();
        for (IToken token : tokens) {
            indexLookup.add(newTokens.size());
            if (PreprocessedTokenStreamUtils.isTokenMacroExpanded(token) && !doneMacros.contains(token.getOffset())) {
                newTokens.addAll(CPreprocessingUtils.getRevertedPreprocessedTokensForToken(tokens, rawTokens, token));
                doneMacros.add(token.getOffset());
                continue;
            }
            if (PreprocessedTokenStreamUtils.isTokenMacroExpanded(token)) continue;
            newTokens.add(token);
        }
        indexLookup.add(newTokens.size());
        return newTokens;
    }

    private static List<IToken> getRevertedPreprocessedTokensForToken(List<IToken> tokens, List<IToken> rawTokens, IToken token) {
        int startIndex;
        IToken rawToken;
        ArrayList<IToken> newTokens = new ArrayList<IToken>();
        for (int i = startIndex = TokenStreamUtils.indexOfByOffset(rawTokens, token.getOffset()); i < rawTokens.size() && ((rawToken = rawTokens.get(i)).getOffset() == token.getOffset() || TokenStreamUtils.indexOfByOffset(tokens, rawToken.getOffset()) == -1); ++i) {
            newTokens.add(rawToken);
        }
        return newTokens;
    }

    public static String replaceLineContinuationChars(String text) {
        for (int i = 0; i < text.length() - 1; ++i) {
            if (text.charAt(i) != '\\' || text.charAt(i + 1) != '\n') continue;
            return text.replace("\\\n", " ");
        }
        return text;
    }

    public static List<ShallowEntity> revertCPreprocessorTokensToUnpreprocessed(List<ShallowEntity> entities, List<IToken> rawTokens) {
        if (entities.isEmpty()) {
            return entities;
        }
        List<ShallowEntity> clonedEntities = ShallowEntityUtils.cloneShallowEntities(entities);
        CPreprocessingUtils.revertPreprocessedTokens(clonedEntities, rawTokens);
        return clonedEntities;
    }
}

