/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class IncludeStatementMatcher {
    private static final List<String> INCLUDE_TYPES = new ArrayList<String>();
    private @Nullable String includedFileExpression = null;
    private @Nullable String includeDirectiveType = null;
    private final String tokenText;

    @VisibleForTesting
    IncludeStatementMatcher(String tokenText) {
        this.tokenText = CPreprocessingUtils.replaceLineContinuationChars(tokenText);
    }

    public IncludeStatementMatcher(IToken token) {
        this(token.getText());
    }

    public boolean match() {
        if (this.includedFileExpression != null) {
            return true;
        }
        int offset = 0;
        if (this.tokenText.length() < 9 || this.tokenText.charAt(offset) != '#') {
            return false;
        }
        ++offset;
        while (offset < this.tokenText.length() && Character.isSpaceChar(this.tokenText.charAt(offset))) {
            ++offset;
        }
        if (offset >= this.tokenText.length()) {
            return false;
        }
        if (this.tokenText.charAt(offset) != 'i') {
            return false;
        }
        for (String option : INCLUDE_TYPES) {
            if (offset + option.length() > this.tokenText.length() || !this.tokenText.startsWith(option, offset)) continue;
            offset += option.length();
            this.includeDirectiveType = option;
            break;
        }
        if (this.includeDirectiveType == null) {
            return false;
        }
        if (offset < this.tokenText.length() && !Character.isSpaceChar(this.tokenText.charAt(offset))) {
            this.includeDirectiveType = null;
            return false;
        }
        ++offset;
        while (offset < this.tokenText.length() && Character.isSpaceChar(this.tokenText.charAt(offset))) {
            ++offset;
        }
        if (offset >= this.tokenText.length()) {
            this.includeDirectiveType = null;
            return false;
        }
        this.includedFileExpression = this.tokenText.substring(offset);
        return true;
    }

    public String getIncludedFileExpression() {
        if (this.includedFileExpression == null) {
            throw new IllegalStateException("getIncludedFileExpression() may only be called if match() returned true.");
        }
        return this.includedFileExpression;
    }

    public String getIncludeDirectiveType() {
        if (this.includeDirectiveType == null) {
            throw new IllegalStateException("getIncludeDirectiveType() may only be called if match() returned true.");
        }
        return this.includeDirectiveType;
    }

    static {
        INCLUDE_TYPES.add("include_next");
        INCLUDE_TYPES.add("include");
        INCLUDE_TYPES.add("import");
    }
}

