/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import eu.cqse.check.framework.preprocessor.c.IMacroProvider;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class OverlayMacroProvider
implements IMacroProvider {
    private final IMacroProvider innerProvider;
    private final Map<String, IMacroProvider.RawMacroDefinition> macros = new HashMap<String, IMacroProvider.RawMacroDefinition>();
    private final Set<String> undefinedMacros = new HashSet<String>();

    public OverlayMacroProvider(IMacroProvider innerProvider) {
        CCSMAssert.isNotNull((Object)innerProvider);
        this.innerProvider = innerProvider;
    }

    @Override
    public boolean isDefined(String name) {
        if (this.undefinedMacros.contains(name)) {
            return false;
        }
        if (this.macros.containsKey(name)) {
            return true;
        }
        return this.innerProvider.isDefined(name);
    }

    @Override
    public boolean isExplicitylUndefined(String name) {
        return this.undefinedMacros.contains(name);
    }

    @Override
    public IMacroProvider.RawMacroDefinition getDefinition(String name) {
        IMacroProvider.RawMacroDefinition definition = this.macros.get(name);
        if (definition != null) {
            return definition;
        }
        return this.innerProvider.getDefinition(name);
    }

    public void define(String name, String definition, TextRegionLocation defintionLocation, ELanguage language) {
        this.macros.put(name, new IMacroProvider.RawMacroDefinition(definition, defintionLocation, language));
        this.undefinedMacros.remove(name);
    }

    public void undefine(String name) {
        this.undefinedMacros.add(name);
        this.macros.remove(name);
    }
}

