/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.cobol;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.EnumSet;
import java.util.List;

public class ScopeUtils {
    private static final ITokenMatcher SCOPE_VERBS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ADD, ETokenType.CALL, ETokenType.COMPUTE, ETokenType.DELETE, ETokenType.DISPLAY, ETokenType.DIVIDE, ETokenType.DOLLAR_IF, ETokenType.EVALUATE, ETokenType.IF, ETokenType.ELSE, ETokenType.INVOKE, ETokenType.JSON, ETokenType.MULTIPLY, ETokenType.PERFORM, ETokenType.READ, ETokenType.RETURN, ETokenType.REWRITE, ETokenType.SEARCH, ETokenType.START, ETokenType.STRING, ETokenType.SUBTRACT, ETokenType.TRY, ETokenType.UNSTRING, ETokenType.WAIT, ETokenType.WRITE, ETokenType.XML});
    private static final ITokenMatcher SCOPE_CLOSE_VERBS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOLLAR_END, ETokenType.END_ADD, ETokenType.END_CALL, ETokenType.END_COMPUTE, ETokenType.END_DELETE, ETokenType.END_DIVIDE, ETokenType.END_DISPLAY, ETokenType.END_EVALUATE, ETokenType.END_IF, ETokenType.END_INVOKE, ETokenType.END_JSON, ETokenType.END_MULTIPLY, ETokenType.END_PERFORM, ETokenType.END_READ, ETokenType.END_RETURN, ETokenType.END_REWRITE, ETokenType.END_SEARCH, ETokenType.END_START, ETokenType.END_STRING, ETokenType.END_SUBTRACT, ETokenType.END_TRY, ETokenType.END_UNSTRING, ETokenType.END_WAIT, ETokenType.END_WRITE, ETokenType.END_XML});

    public static boolean currentlyInScope(List<IToken> tokens, int startOffset) {
        int openTokenBeforeOffsetIndex = TokenStreamUtils.lastTokenMatching(tokens, 0, startOffset, SCOPE_VERBS);
        if (openTokenBeforeOffsetIndex != -1) {
            IToken openToken = tokens.get(openTokenBeforeOffsetIndex);
            ETokenType closeTokenType = ScopeUtils.getCloseTokenType(openToken);
            int closeTokenBeforeOffsetIndex = TokenStreamUtils.lastTokenMatching(tokens, openTokenBeforeOffsetIndex, startOffset, (ITokenMatcher)closeTokenType);
            return closeTokenBeforeOffsetIndex == -1 && (ScopeUtils.periodEndsScope(tokens, startOffset) || ScopeUtils.countOfOpenVerbsAtLeastCloseVerbs(tokens, closeTokenType, startOffset));
        }
        return false;
    }

    private static ETokenType getCloseTokenType(IToken openToken) {
        ETokenType openTokenType = openToken.getType();
        ETokenType closeTokenType = EnumSet.of(ETokenType.IF, ETokenType.ELSE).contains(openTokenType) ? ETokenType.END_IF : (ETokenType.DOLLAR_IF == openTokenType ? ETokenType.DOLLAR_END : ETokenType.valueOf((String)("END_" + openToken.getText().toUpperCase())));
        return closeTokenType;
    }

    private static boolean periodEndsScope(List<IToken> tokens, int startOffset) {
        int nextIndex = startOffset + 1;
        if (nextIndex < tokens.size() - 1) {
            return tokens.get(nextIndex).getType() == ETokenType.DOT;
        }
        return false;
    }

    private static boolean countOfOpenVerbsAtLeastCloseVerbs(List<IToken> tokens, ETokenType closeTokenType, int startOffset) {
        int indexCloseToken = TokenStreamUtils.firstTokenMatching(tokens, startOffset, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{closeTokenType, ETokenType.DOT}));
        if (indexCloseToken != -1) {
            int countCloseVerbs;
            int countOpenVerbs = TokenStreamUtils.findAll(tokens, startOffset, indexCloseToken, SCOPE_VERBS).size();
            return countOpenVerbs >= (countCloseVerbs = TokenStreamUtils.findAll(tokens, startOffset, indexCloseToken, SCOPE_CLOSE_VERBS).size());
        }
        return false;
    }
}

