/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.php;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import eu.cqse.check.framework.shallowparser.languages.php.PhpSubExpressionRecognizer;

public class PhpShallowParser
extends ShallowParserBase<EGenericParserStates> {
    private static final ITokenMatcher STATEMENT_START_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BACKSLASH, ETokenType.BREAK, ETokenType.CLONE, ETokenType.ECHO, ETokenType.GOTO, ETokenType.IDENTIFIER, ETokenType.MINUSMINUS, ETokenType.NAMESPACE, ETokenType.NEW, ETokenType.PLUSPLUS, ETokenType.PRINT, ETokenType.RETURN, ETokenType.STATIC, ETokenType.THIS, ETokenType.THROW, ETokenType.YIELD, ETokenType.AT});
    private static final ITokenMatcher ACCESS_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PRIVATE, ETokenType.PUBLIC, ETokenType.PROTECTED, ETokenType.STATIC, ETokenType.GLOBAL, ETokenType.CONST, ETokenType.ABSTRACT, ETokenType.FINAL, ETokenType.VAR, ETokenType.READONLY});
    private static final ITokenMatcher VALID_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.CLONE});

    public PhpShallowParser() {
        super(EGenericParserStates.class, EGenericParserStates.TOP_LEVEL);
        this.createInExpressionRules();
        this.createConstructorRule();
        this.createMethodRule();
        this.createTypeRule();
        this.createIfElseRule();
        this.createTryCatchRule();
        this.createSwitchCaseRule();
        this.createLoopRules();
        this.createNamespaceRule();
        this.createMetaRules();
        this.createVariableRule();
        this.createAnonymousBlockRule();
        this.createSingleStatementRule();
        this.createEmptyStatementRule();
    }

    private void createInExpressionRules() {
        RecognizerBase<EGenericParserStates> innerClassBase = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.NEW, ETokenType.CLASS}).createNode(EShallowEntityType.TYPE, "anonymous class", INameResolver.secondMatchedTokenText()).skipBefore(new ITokenMatcher[]{ETokenType.LBRACE});
        PhpShallowParser.endTypeRule(innerClassBase);
        RecognizerBase<EGenericParserStates> closureBase = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).createNode(EShallowEntityType.STATEMENT, "anonymous function").skipNested(ETokenType.LPAREN, ETokenType.RPAREN, PhpShallowParser.createSubexpressionRecognizer());
        RecognizerBase<EGenericParserStates> closureBaseWithUse = closureBase.sequence(new ITokenMatcher[]{ETokenType.USE}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, PhpShallowParser.createSubexpressionRecognizer()).skipBefore(new ITokenMatcher[]{ETokenType.LBRACE});
        closureBase = closureBase.skipBefore(new ITokenMatcher[]{ETokenType.LBRACE});
        PhpShallowParser.endMethodRule(closureBaseWithUse);
        PhpShallowParser.endMethodRule(closureBase);
    }

    private void createTryCatchRule() {
        RecognizerBase<EGenericParserStates> tryBase = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.TRY}).createNode(EShallowEntityType.STATEMENT, "try");
        RecognizerBase<EGenericParserStates> catchBase = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.CATCH}).createNode(EShallowEntityType.STATEMENT, "catch").skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        RecognizerBase<EGenericParserStates> finallyBase = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.FINALLY}).createNode(EShallowEntityType.STATEMENT, "finally");
        PhpShallowParser.continueTryCatchRule(tryBase);
        PhpShallowParser.continueTryCatchRule(catchBase);
        PhpShallowParser.continueTryCatchRule(finallyBase);
    }

    private static void continueTryCatchRule(RecognizerBase<EGenericParserStates> base) {
        RecognizerBase<EGenericParserStates> multiLineBase = base.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE});
        RecognizerBase<EGenericParserStates> singleLineBase = base.parseOnce(EGenericParserStates.IN_METHOD);
        PhpShallowParser.endTryCatchRule(multiLineBase);
        PhpShallowParser.endTryCatchRule(singleLineBase);
    }

    private static void endTryCatchRule(RecognizerBase<EGenericParserStates> base) {
        base.sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY})).endNodeWithContinuation();
        base.endNode();
    }

    private void createConstructorRule() {
        this.createConstructorRule(ETokenType.CONSTRUCTOR, "constructor");
        this.createConstructorRule(ETokenType.DESTRUCTOR, "destructor");
    }

    private void createConstructorRule(ETokenType tokenType, String subtypeName) {
        RecognizerBase base = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).repeated(ACCESS_MODIFIERS).sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).sequence(new ITokenMatcher[]{tokenType}).createNode(EShallowEntityType.METHOD, subtypeName).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        base.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        base.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END})).endNode();
    }

    private void createNamespaceRule() {
        RecognizerBase base = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.NAMESPACE}).sequenceBefore(ETokenType.BACKSLASH.negated()).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END, ETokenType.LBRACE})).createNode(EShallowEntityType.MODULE, "namespace", INameResolver.ofRange(1, -1));
        base.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END})).endNode();
        base.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.TOP_LEVEL).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createEmptyStatementRule() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
    }

    private void createAnonymousBlockRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "anonymous block").parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createMetaRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.HASH}).sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACK}).skipNested(ETokenType.LBRACK, ETokenType.RBRACK).createNode(EShallowEntityType.META, "attribute", INameResolver.ofRange(0, -1)).endNode();
        RecognizerBase<EGenericParserStates> baseDeclare = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.DECLARE}).createNode(EShallowEntityType.STATEMENT, "declaration").skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        baseDeclare.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END})).endNode();
        PhpShallowParser.endControlFlowStatement(baseDeclare, ETokenType.ENDDECLARE);
        RecognizerBase baseUse = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.USE}).createNode(EShallowEntityType.META, "use", INameResolver.ofRange(1, -1)).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TEMPLATE_CODE_END, ETokenType.SEMICOLON, ETokenType.LBRACE}));
        baseUse.skipNested(ETokenType.LBRACE, ETokenType.RBRACE).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END})).endNode();
        baseUse.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.createRequireRule(ETokenType.REQUIRE, "require");
        this.createRequireRule(ETokenType.REQUIRE_ONCE, "require_once");
        this.createRequireRule(ETokenType.INCLUDE, "include");
        this.createRequireRule(ETokenType.INCLUDE_ONCE, "include_once");
        this.inAnyState().sequence(new ITokenMatcher[]{VALID_IDENTIFIERS, ETokenType.COLON}).createNode(EShallowEntityType.META, "label", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createRequireRule(ETokenType requireToken, String subtype) {
        this.inAnyState().sequence(new ITokenMatcher[]{requireToken}).createNode(EShallowEntityType.META, subtype, INameResolver.ofRange(1, -1)).skipAfter(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TEMPLATE_CODE_END, ETokenType.SEMICOLON})).endNode();
    }

    private void createSwitchCaseRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CASE, ETokenType.DEFAULT})).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).optional(VALID_IDENTIFIERS).repeated(new ITokenMatcher[]{ETokenType.COLON, ETokenType.COLON, VALID_IDENTIFIERS}).skipAfter(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COLON, ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END})).endNode();
        RecognizerBase<EGenericParserStates> base = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.SWITCH}).createNode(EShallowEntityType.STATEMENT, "switch").skipNested(ETokenType.LPAREN, ETokenType.RPAREN, PhpShallowParser.createSubexpressionRecognizer());
        PhpShallowParser.endControlFlowStatement(base, ETokenType.ENDSWITCH);
    }

    private void createTypeRule() {
        this.createTypeRule(ETokenType.CLASS, "class");
        this.createTypeRule(ETokenType.TRAIT, "trait");
        this.createInterfaceRule();
    }

    private void createInterfaceRule() {
        RecognizerBase<EGenericParserStates> interfaceRule = this.beginTypeRule(ETokenType.INTERFACE, "interface");
        PhpShallowParser.endInterfaceRule(interfaceRule.sequence(new ITokenMatcher[]{ETokenType.EXTENDS}).skipBefore(new ITokenMatcher[]{ETokenType.LBRACE}));
        PhpShallowParser.endInterfaceRule(interfaceRule.sequence(new ITokenMatcher[]{ETokenType.EXTENDS, VALID_IDENTIFIERS}).repeated(new ITokenMatcher[]{ETokenType.COMMA, VALID_IDENTIFIERS}));
        PhpShallowParser.endInterfaceRule(interfaceRule);
    }

    private static void endInterfaceRule(RecognizerBase<EGenericParserStates> interfaceRule) {
        PhpShallowParser.endTypeRule(interfaceRule.sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE}));
        interfaceRule.endNode();
    }

    private void createTypeRule(ETokenType type, String subtypeName) {
        PhpShallowParser.endTypeRule(this.beginTypeRule(type, subtypeName).skipBefore(new ITokenMatcher[]{ETokenType.LBRACE}));
    }

    private RecognizerBase<EGenericParserStates> beginTypeRule(ETokenType type, String subtypeName) {
        return this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).repeated(ACCESS_MODIFIERS).sequence(new ITokenMatcher[]{type}).markStart().sequence(VALID_IDENTIFIERS).createNode(EShallowEntityType.TYPE, subtypeName, INameResolver.firstMatchedTokenText());
    }

    private static void endTypeRule(RecognizerBase<EGenericParserStates> base) {
        base.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createVariableRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).repeated(ACCESS_MODIFIERS).markStart().sequence(VALID_IDENTIFIERS).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END})).createNode(EShallowEntityType.STATEMENT, "local variable", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(ACCESS_MODIFIERS).repeated(ACCESS_MODIFIERS).markStart().sequence(VALID_IDENTIFIERS).createNode(EShallowEntityType.STATEMENT, "local variable", INameResolver.firstMatchedTokenText()).skipAfterWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END}), ETokenType.LPAREN, ETokenType.RPAREN, PhpShallowParser.createSubexpressionRecognizer()).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).repeated(ACCESS_MODIFIERS).markStart().sequence(VALID_IDENTIFIERS).sequenceBefore(new ITokenMatcher[]{ETokenType.EQ}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.firstMatchedTokenText()).skipAfterWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END}), ETokenType.LPAREN, ETokenType.RPAREN, PhpShallowParser.createSubexpressionRecognizer()).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).repeated(ACCESS_MODIFIERS).markStart().sequence(VALID_IDENTIFIERS, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END})).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createLoopRules() {
        this.createLoopRule(ETokenType.FOREACH, ETokenType.ENDFOREACH);
        this.createLoopRule(ETokenType.FOR, ETokenType.ENDFOR);
        this.createLoopRule(ETokenType.WHILE, ETokenType.ENDWHILE);
        RecognizerBase<EGenericParserStates> base = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD, EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.DO}).createNode(EShallowEntityType.STATEMENT, "do");
        base.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE, ETokenType.WHILE}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, PhpShallowParser.createSubexpressionRecognizer()).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        base.parseOnce(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.WHILE}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, PhpShallowParser.createSubexpressionRecognizer()).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createLoopRule(ETokenType startToken, ETokenType endToken) {
        RecognizerBase<EGenericParserStates> base = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD, EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{startToken}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, PhpShallowParser.createSubexpressionRecognizer()).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        PhpShallowParser.endControlFlowStatement(base, endToken);
    }

    private void createIfElseRule() {
        RecognizerBase<EGenericParserStates> base = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD, EGenericParserStates.TOP_LEVEL}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.ELSEIF})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, PhpShallowParser.createSubexpressionRecognizer());
        PhpShallowParser.continueIfElseRule(base, true);
        RecognizerBase<EGenericParserStates> elseIfbase = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD, EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.ELSE, ETokenType.IF}).createNode(EShallowEntityType.STATEMENT, "else if").skipNested(ETokenType.LPAREN, ETokenType.RPAREN, PhpShallowParser.createSubexpressionRecognizer());
        PhpShallowParser.continueIfElseRule(elseIfbase, true);
        RecognizerBase<EGenericParserStates> elseBase = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD, EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.ELSE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        PhpShallowParser.continueIfElseRule(elseBase, false);
    }

    private static void continueIfElseRule(RecognizerBase<EGenericParserStates> base, boolean allowContinuation) {
        RecognizerBase<EGenericParserStates> multiLineBase = base.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE});
        RecognizerBase<EGenericParserStates> multiLineBaseAlternative = base.sequence(new ITokenMatcher[]{ETokenType.COLON}).parseUntil(EGenericParserStates.IN_METHOD).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.ELSEIF, ETokenType.ENDIF}));
        RecognizerBase<EGenericParserStates> singleLineBase = base.parseOnce(EGenericParserStates.IN_METHOD);
        PhpShallowParser.endIfElseRule(singleLineBase, false, allowContinuation);
        PhpShallowParser.endIfElseRule(multiLineBase, false, allowContinuation);
        PhpShallowParser.endIfElseRule(multiLineBaseAlternative, true, allowContinuation);
    }

    private static void endIfElseRule(RecognizerBase<EGenericParserStates> base, boolean expectsEndif, boolean allowContinuation) {
        if (allowContinuation) {
            base.sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.ELSEIF})).endNodeWithContinuation();
        }
        if (expectsEndif) {
            base.optional(new ITokenMatcher[]{ETokenType.ENDIF, ETokenType.SEMICOLON}).endNode();
            base.optional(new ITokenMatcher[]{ETokenType.ENDIF}).endNode();
        } else {
            base.endNode();
        }
    }

    private void createMethodRule() {
        RecognizerBase<EGenericParserStates> base = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_TYPE, EGenericParserStates.IN_METHOD}).repeated(ACCESS_MODIFIERS).sequence(new ITokenMatcher[]{ETokenType.FUNCTION}).optional(new ITokenMatcher[]{ETokenType.AND}).sequence(VALID_IDENTIFIERS).createNode(EShallowEntityType.METHOD, "method", INameResolver.previousTokenText()).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END}), ETokenType.LPAREN, ETokenType.RPAREN);
        PhpShallowParser.endMethodRule(base);
        base.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END})).endNode();
    }

    private static void endMethodRule(RecognizerBase<EGenericParserStates> base) {
        base.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createSingleStatementRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequenceBefore(STATEMENT_START_TOKENS).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.firstMatchedTokenText()).skipAfterWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END}), ETokenType.LPAREN, ETokenType.RPAREN, PhpShallowParser.createSubexpressionRecognizer()).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequenceBefore(new ITokenMatcher[]{ETokenType.LPAREN}).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.firstMatchedTokenText()).skipAfterWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.TEMPLATE_CODE_END}), ETokenType.LPAREN, ETokenType.RPAREN, PhpShallowParser.createSubexpressionRecognizer()).endNode();
        RecognizerBase continueBase = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.CONTINUE}).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.firstMatchedTokenText());
        continueBase.sequence(new ITokenMatcher[]{VALID_IDENTIFIERS.or(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL}), ETokenType.SEMICOLON}).endNode();
        continueBase.optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private static void endControlFlowStatement(RecognizerBase<EGenericParserStates> base, ETokenType alternativeEndToken) {
        base.sequence(new ITokenMatcher[]{ETokenType.COLON}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{alternativeEndToken}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        base.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        base.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        base.parseOnce(EGenericParserStates.IN_METHOD).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private static RecognizerBase<EGenericParserStates> createSubexpressionRecognizer() {
        return new PhpSubExpressionRecognizer();
    }
}

