/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.util;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ShallowParsedNameUtils {
    private static final String CPP_SCOPE = "::";

    public static String getFullyQualifiedName(ShallowEntity entity) {
        return ShallowParsedNameUtils.getFullyQualifiedName(entity, ShallowParsedNameUtils.determineLanguage(entity));
    }

    private static String getFullyQualifiedName(ShallowEntity entity, ELanguage language) {
        EShallowEntityType type = entity.getType();
        CCSMAssert.isTrue((type == EShallowEntityType.MODULE || type == EShallowEntityType.TYPE || type == EShallowEntityType.METHOD || type == EShallowEntityType.ATTRIBUTE ? 1 : 0) != 0, (String)"May only pass MODULE, TYPE, METHOD, or ATTRIBUTE!");
        String name = entity.getName();
        if (LanguageGroups.C_CPP_AND_MS_CLI.contains(language) && (type == EShallowEntityType.METHOD || type == EShallowEntityType.ATTRIBUTE)) {
            name = ShallowParsedNameUtils.extractCppMethodOrAttributeName(entity);
        }
        return ShallowParsedNameUtils.expandParentNames(name, entity, language);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String expandParentNames(String name, ShallowEntity entity, ELanguage language) {
        String separator = switch (language) {
            case ELanguage.C, ELanguage.CPP, ELanguage.CPP_MS_CLI -> CPP_SCOPE;
            case ELanguage.JAVA, ELanguage.CS -> ".";
            default -> "/";
        };
        ShallowEntity parent = entity.getParent();
        while (parent != null) {
            if (parent.getType() == EShallowEntityType.TYPE || parent.getType() == EShallowEntityType.MODULE) {
                name = parent.getName() + separator + (String)name;
            }
            parent = parent.getParent();
        }
        return name;
    }

    private static ELanguage determineLanguage(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        CCSMAssert.isFalse((boolean)tokens.isEmpty(), (String)"Shallow entities must have underlying tokens!");
        return ((IToken)CollectionUtils.getAny((Iterable)tokens)).getLanguage();
    }

    private static String extractCppMethodOrAttributeName(ShallowEntity methodOrAttribute) {
        int index;
        CCSMAssert.isTrue((methodOrAttribute.getType() == EShallowEntityType.METHOD || methodOrAttribute.getType() == EShallowEntityType.ATTRIBUTE ? 1 : 0) != 0, (String)"May only be used for method or attribute!");
        UnmodifiableList tokens = methodOrAttribute.includedTokens();
        Object name = methodOrAttribute.getName();
        for (index = 0; index < tokens.size() && !((IToken)tokens.get(index)).getText().equals(name) || index + 1 < tokens.size() && ((IToken)tokens.get(index + 1)).getType() == ETokenType.SCOPE; ++index) {
        }
        if (index >= tokens.size()) {
            return name;
        }
        if (index >= 1 && ((IToken)tokens.get(index - 1)).getType() == ETokenType.COMP) {
            --index;
            name = "~" + (String)name;
        }
        while (index >= 2 && ((IToken)tokens.get(index - 1)).getType() == ETokenType.SCOPE) {
            name = ((IToken)tokens.get(index -= 2)).getText() + CPP_SCOPE + (String)name;
        }
        return name;
    }
}

