/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.util;

import com.google.common.collect.ImmutableSet;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.VariableNameFragmentParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.region.OffsetBasedRegion;

public class ShallowParsingUtils {
    public static final Marker PARSE_LOG_ENTRY_MARKER = MarkerManager.getMarker((String)"parse-log");
    private static final Set<String> SUBPART_BRANCHING_STATEMENTS = ImmutableSet.of((Object)"else if", (Object)"else", (Object)"catch", (Object)"finally", (Object)"case", (Object)"default", (Object[])new String[]{"using", "do"});
    private static final Set<String> LOOP_SUBTYPES = ImmutableSet.of((Object)"for", (Object)"foreach", (Object)"while");

    public static List<ShallowEntity> listPrimitiveStatements(Collection<ShallowEntity> entities) {
        return new ShallowEntityTraversalUtils.CollectingVisitorBase(){

            protected boolean collect(ShallowEntity entity) {
                return entity.getType() == EShallowEntityType.STATEMENT && entity.getChildren().isEmpty();
            }
        }.apply(entities);
    }

    public static List<ShallowEntity> listNestedStatements(Collection<ShallowEntity> entities) {
        return new ShallowEntityTraversalUtils.CollectingVisitorBase(){

            protected boolean collect(ShallowEntity entity) {
                UnmodifiableList children = entity.getChildren();
                return entity.getType() == EShallowEntityType.STATEMENT && !children.isEmpty() && ((ShallowEntity)children.get(0)).getType() == EShallowEntityType.STATEMENT;
            }
        }.apply(entities);
    }

    public static List<IToken> extractParameterNameTokens(ShallowEntity entity) {
        if (ShallowParsingUtils.getLanguage(entity) == ELanguage.CS) {
            return ShallowParsingUtils.extractParameterTokensForCs(entity);
        }
        return ShallowParsingUtils.extractVariableNameTokens(TokenStreamUtils.tokensBetween((List<IToken>)entity.ownStartTokens(), ETokenType.LPAREN, ETokenType.RPAREN), true);
    }

    private static List<IToken> extractParameterTokensForCs(ShallowEntity entity) {
        int rParenIndex;
        Object tokens = entity.ownStartTokens();
        if ("constructor".equals(entity.getSubtype())) {
            int constructorCall = TokenStreamUtils.firstTokenOfTypeSequence((List<IToken>)tokens, 0, ETokenType.COLON, ETokenType.THIS, ETokenType.LPAREN);
            if (constructorCall == -1) {
                constructorCall = TokenStreamUtils.firstTokenOfTypeSequence((List<IToken>)tokens, 0, ETokenType.COLON, ETokenType.BASE, ETokenType.LPAREN);
            }
            if (constructorCall != -1) {
                tokens = tokens.subList(0, constructorCall);
            }
        }
        if ((rParenIndex = TokenStreamUtils.lastTokenMatching((List<IToken>)tokens, (ITokenMatcher)ETokenType.RPAREN)) == -1) {
            return Collections.emptyList();
        }
        int lParenIndex = TokenStreamUtils.findMatchingOpeningToken((List<IToken>)tokens, rParenIndex - 1, ETokenType.LPAREN, ETokenType.RPAREN);
        if (lParenIndex == -1) {
            return Collections.emptyList();
        }
        if (lParenIndex + 1 >= rParenIndex) {
            return Collections.emptyList();
        }
        return ShallowParsingUtils.extractVariableNameTokens(tokens.subList(lParenIndex + 1, rParenIndex), true);
    }

    public static List<IToken> extractVariableNameTokens(List<IToken> tokens) {
        return ShallowParsingUtils.extractVariableNameTokens(tokens, false);
    }

    private static List<IToken> extractVariableNameTokens(List<IToken> tokens, boolean ignoreParameterTypes) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        for (List<IToken> declarationFragment : ShallowParsingUtils.splitOnNonNestedCommas(tokens)) {
            VariableNameFragmentParser.extract(declarationFragment, ignoreParameterTypes).ifPresent(result::add);
        }
        return result;
    }

    public static List<List<IToken>> splitOnNonNestedCommas(List<IToken> tokens) {
        List<Integer> commas = TokenStreamUtils.findAll(tokens, (ITokenMatcher)ETokenType.COMMA);
        TokenPattern nestedTypeExpression = new TokenPattern().alternative(new TokenPattern().skipNested(ETokenType.LT, ETokenType.GT, false), new TokenPattern().skipNested(ETokenType.LPAREN, ETokenType.RPAREN, false), new TokenPattern().skipNested(ETokenType.LBRACE, ETokenType.RBRACE, false), new TokenPattern().skipNested(ETokenType.LBRACK, ETokenType.RBRACK, false)).group(0);
        List<TokenPatternMatch> nestedParenthesis = nestedTypeExpression.findAll(tokens);
        List nestedParenthesisWithoutLtEqGt = nestedParenthesis.stream().filter(match -> !ShallowParsingUtils.isLtEqGt(match)).collect(Collectors.toList());
        for (TokenPatternMatch tokenPatternMatch : nestedParenthesisWithoutLtEqGt) {
            commas.removeAll(tokenPatternMatch.groupIndices(0));
        }
        return ShallowParsingUtils.splitAfterIndices(tokens, commas);
    }

    private static boolean isLtEqGt(TokenPatternMatch tokenPatternMatch) {
        List<IToken> tokens = tokenPatternMatch.groupTokens(0);
        return tokens.size() > 0 && tokens.get(0).getType() == ETokenType.LT && tokens.stream().anyMatch(token -> token.getType() == ETokenType.EQ) && ((IToken)CollectionUtils.getLast(tokens)).getType() == ETokenType.GT;
    }

    private static List<List<IToken>> splitAfterIndices(List<IToken> tokens, List<Integer> splitIndices) {
        ArrayList<List<IToken>> result = new ArrayList<List<IToken>>();
        int start = 0;
        for (Integer index : splitIndices) {
            result.add(tokens.subList(start, index + 1));
            start = index + 1;
        }
        result.add(tokens.subList(start, tokens.size()));
        return result;
    }

    public static List<IToken> extractVariablesDeclaredInFor(ShallowEntity entity) {
        List<IToken> forLoopInitTokens = TokenStreamUtils.tokensBetween((List<IToken>)entity.ownStartTokens(), ETokenType.LPAREN, ETokenType.SEMICOLON);
        List<IToken> variableNameTokens = ShallowParsingUtils.extractVariableNameTokens(forLoopInitTokens);
        if (!variableNameTokens.isEmpty() && variableNameTokens.get(0) == forLoopInitTokens.get(0)) {
            variableNameTokens.clear();
        }
        return variableNameTokens;
    }

    public static boolean isLocalVariable(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.STATEMENT && "local variable".equals(entity.getSubtype());
    }

    public static boolean isGlobalVariable(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.ATTRIBUTE && (entity.getParent() == null || entity.getParent().getType() == EShallowEntityType.MODULE);
    }

    public static boolean containsLoopReferenceWithoutLoop(List<ShallowEntity> block) {
        for (ShallowEntity statement : block) {
            if (statement.getSubtype().equals("for") || statement.getSubtype().equals("while")) continue;
            UnmodifiableList startTokens = statement.ownStartTokens();
            IToken firstToken = (IToken)startTokens.get(0);
            if (firstToken.getType() == ETokenType.CONTINUE || firstToken.getType() == ETokenType.BREAK) {
                return true;
            }
            if (firstToken.getType() != ETokenType.RETURN) continue;
            return true;
        }
        for (ShallowEntity statement : block) {
            if (ShallowParsingUtils.containsAnonymousClassOrLambda(statement) || !ShallowParsingUtils.containsLoopReferenceWithoutLoop((List<ShallowEntity>)statement.getChildren())) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAnonymousClassOrLambda(ShallowEntity statement) {
        return !statement.getChildren().isEmpty() && (((ShallowEntity)statement.getChildren().get(0)).getSubtype().equals("anonymous class") || ((ShallowEntity)statement.getChildren().get(0)).getSubtype().equals("lambda"));
    }

    public static List<ShallowEntity> getCompleteStatement(ShallowEntity shallowEntity) {
        String thirdKeyword;
        String secondKeyword;
        switch (shallowEntity.getSubtype()) {
            case "if": {
                secondKeyword = "else if";
                thirdKeyword = "else";
                break;
            }
            case "try": {
                secondKeyword = "catch";
                thirdKeyword = "finally";
                break;
            }
            case "switch": {
                secondKeyword = "case";
                thirdKeyword = "default";
                break;
            }
            default: {
                return CollectionUtils.emptyList();
            }
        }
        return ShallowParsingUtils.resembleCompleteStatement(shallowEntity, secondKeyword, thirdKeyword);
    }

    private static List<ShallowEntity> resembleCompleteStatement(ShallowEntity shallowEntity, String secondKeyword, String thirdKeyword) {
        ArrayList<ShallowEntity> completeStatement = new ArrayList<ShallowEntity>();
        completeStatement.add(shallowEntity);
        UnmodifiableList children = shallowEntity.getParent().getChildren();
        boolean firstKeywordFound = false;
        for (ShallowEntity child : children) {
            if (!firstKeywordFound) {
                if (!child.equals(shallowEntity)) continue;
                firstKeywordFound = true;
                continue;
            }
            if (child.getSubtype().equals(secondKeyword)) {
                completeStatement.add(child);
                continue;
            }
            if (!child.getSubtype().equals(thirdKeyword)) break;
            completeStatement.add(child);
            return completeStatement;
        }
        return completeStatement;
    }

    private static ShallowEntity getFirstEntityAfter(ShallowEntity candidate) {
        List childrenOfParent = candidate.getParent().getChildrenOfType(EShallowEntityType.STATEMENT);
        int indexOfNextCandidate = childrenOfParent.indexOf(candidate) + 1;
        if (indexOfNextCandidate < childrenOfParent.size()) {
            return (ShallowEntity)childrenOfParent.get(indexOfNextCandidate);
        }
        return null;
    }

    private static ShallowEntity getLastEntityBefore(ShallowEntity candidate) {
        List childrenOfParent = candidate.getParent().getChildrenOfType(EShallowEntityType.STATEMENT);
        int indexOfPreviousCandidate = childrenOfParent.indexOf(candidate) - 1;
        if (indexOfPreviousCandidate >= 0) {
            return (ShallowEntity)childrenOfParent.get(indexOfPreviousCandidate);
        }
        return null;
    }

    public static int getNestingArea(List<ShallowEntity> shallowEntities) {
        int currentDepth = 0;
        int nestingArea = 0;
        for (ShallowEntity shallowEntity : shallowEntities) {
            nestingArea += ShallowParsingUtils.getNestingArea(shallowEntity, currentDepth);
        }
        return nestingArea;
    }

    private static int getNestingArea(ShallowEntity shallowEntity, int currentDepth) {
        int nestingArea = currentDepth;
        for (ShallowEntity child : shallowEntity.getChildrenOfType(EShallowEntityType.STATEMENT)) {
            nestingArea += ShallowParsingUtils.getNestingArea(child, currentDepth + 1);
        }
        return nestingArea;
    }

    public static int getNestingDepth(List<ShallowEntity> block) {
        int maxNestingDepth = 0;
        for (ShallowEntity shallowEntity : block) {
            int entityNestingDepth = ShallowParsingUtils.getNestingDepth(shallowEntity);
            if (entityNestingDepth <= maxNestingDepth) continue;
            maxNestingDepth = entityNestingDepth;
        }
        return maxNestingDepth;
    }

    public static int getNestingDepth(ShallowEntity shallowEntity) {
        int maxNestingDepth = 0;
        for (ShallowEntity child : shallowEntity.getChildrenOfType(EShallowEntityType.STATEMENT)) {
            int childNestingDepth = ShallowParsingUtils.getNestingDepth(child);
            if (maxNestingDepth > childNestingDepth) continue;
            maxNestingDepth = childNestingDepth + 1;
        }
        return maxNestingDepth;
    }

    public static int getNumberOfBlankLinesOrCommentsAfter(ShallowEntity candidate) {
        int lineDifference = 1;
        ShallowEntity firstEntityAfter = ShallowParsingUtils.getFirstEntityAfter(candidate);
        if (firstEntityAfter == null) {
            if (candidate.getParent().getEndLine() - candidate.getEndLine() > 1) {
                lineDifference = candidate.getParent().getEndLine() - candidate.getEndLine();
            }
            return lineDifference - 1;
        }
        lineDifference = firstEntityAfter.getStartLine() - candidate.getEndLine();
        return lineDifference - 1;
    }

    public static int getNumberOfBlankLinesOrCommentsBefore(ShallowEntity candidate) {
        int lineDifference = 1;
        ShallowEntity lastEntityBefore = ShallowParsingUtils.getLastEntityBefore(candidate);
        if (lastEntityBefore == null) {
            if (candidate.getStartLine() - candidate.getParent().getStartLine() > 1) {
                lineDifference = candidate.getStartLine() - candidate.getParent().getStartLine();
            }
            return lineDifference - 1;
        }
        lineDifference = candidate.getStartLine() - lastEntityBefore.getEndLine();
        return lineDifference - 1;
    }

    public static List<String> getReturnParameters(List<ShallowEntity> block) {
        ArrayList<String> returnParameters = new ArrayList<String>();
        List allEntities = ShallowEntityTraversalUtils.listEntitiesOfType(block, (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : allEntities) {
            if (((IToken)statement.includedTokens().get(0)).getType() != ETokenType.RETURN || ShallowParsingUtils.locatedInAnonymousClassOrLambda(statement)) continue;
            returnParameters.add(statement.getName());
        }
        return returnParameters;
    }

    public static boolean locatedInAnonymousClassOrLambda(ShallowEntity statement) {
        ShallowEntity parent = statement.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.getSubtype().equals("anonymous class") || parent.getSubtype().equals("lambda") || parent.getSubtype().equals("block expression")) {
            return true;
        }
        return ShallowParsingUtils.locatedInAnonymousClassOrLambda(parent);
    }

    public static List<ShallowEntity> getStatements(ShallowEntity entity) {
        ArrayList<ShallowEntity> list = new ArrayList<ShallowEntity>();
        list.add(entity);
        return ShallowEntityTraversalUtils.listEntitiesOfType(list, (EShallowEntityType)EShallowEntityType.STATEMENT);
    }

    public static List<ShallowEntity> getClassEntities(List<ShallowEntity> shallowEntities, int startLine, int endLine) {
        List classEntities = ShallowEntityTraversalUtils.listEntitiesOfType(shallowEntities, (EShallowEntityType)EShallowEntityType.TYPE);
        ArrayList<ShallowEntity> classEntitiesCoveringCodeArea = new ArrayList<ShallowEntity>();
        for (ShallowEntity classEntity : classEntities) {
            if (classEntity.getStartLine() > startLine || classEntity.getEndLine() < endLine) continue;
            classEntitiesCoveringCodeArea.add(classEntity);
        }
        return classEntitiesCoveringCodeArea;
    }

    public static List<ShallowEntity> getMethods(List<ShallowEntity> shallowEntities) {
        return ShallowEntityTraversalUtils.listEntitiesOfType(shallowEntities, (EShallowEntityType)EShallowEntityType.METHOD);
    }

    public static Optional<ShallowEntity> getMethod(List<ShallowEntity> shallowEntities, OffsetBasedRegion region) {
        Predicate<ShallowEntity> filter = methodEntity -> methodEntity.getStartOffset() == region.getStart() && methodEntity.getEndOffset() == region.getEnd();
        return ShallowParsingUtils.getMethod(shallowEntities, filter);
    }

    public static Optional<ShallowEntity> getMethod(List<ShallowEntity> shallowEntities, LineBasedRegion region) {
        Predicate<ShallowEntity> filter = methodEntity -> methodEntity.getStartLine() == region.getStart() && methodEntity.getEndLine() == region.getEnd();
        return ShallowParsingUtils.getMethod(shallowEntities, filter);
    }

    public static Optional<ShallowEntity> getMethod(List<ShallowEntity> shallowEntities, Predicate<ShallowEntity> filter) {
        return ShallowParsingUtils.getMethods(shallowEntities).stream().filter(filter).findFirst();
    }

    public static List<String> getClassAttributes(List<ShallowEntity> classEntities) {
        ArrayList<String> globalVariables = new ArrayList<String>();
        for (ShallowEntity classEntity : classEntities) {
            List attributes = classEntity.getChildrenOfType(EShallowEntityType.ATTRIBUTE);
            for (ShallowEntity attribute : attributes) {
                globalVariables.add(attribute.getName());
            }
        }
        return globalVariables;
    }

    public static boolean isLoop(ShallowEntity entity) {
        return LOOP_SUBTYPES.contains(entity.getSubtype());
    }

    public static boolean isSubpartOfBranchingStatement(ShallowEntity entity) {
        return SUBPART_BRANCHING_STATEMENTS.contains(entity.getSubtype());
    }

    public static boolean isCppConstructor(ELanguage language, ShallowEntity entity) {
        return (language == ELanguage.CPP || language == ELanguage.CPP_MS_CLI) && entity.getType() == EShallowEntityType.METHOD && "constructor".equals(entity.getSubtype());
    }

    public static boolean isConstructorWithInitializerList(ELanguage language, ShallowEntity entity) {
        return ShallowParsingUtils.isCppConstructor(language, entity) && TokenStreamUtils.firstTokenMatching((List<IToken>)entity.ownStartTokens(), (ITokenMatcher)ETokenType.COLON) != -1;
    }

    public static boolean isLambdaMethod(ShallowEntity entity) {
        String subtype = entity.getSubtype();
        return entity.getType() == EShallowEntityType.METHOD && ("lambda".equals(entity.getSubtype()) || "lambda expression".equals(subtype) || "block expression".equals(subtype) || "assigned lambda".equals(subtype));
    }

    public static ELanguage getLanguage(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        if (tokens.isEmpty()) {
            return null;
        }
        return ((IToken)CollectionUtils.getAny((Iterable)tokens)).getLanguage();
    }
}

