/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker.java;

import com.google.common.collect.Iterables;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

public class JavaImportSensitiveTypeResolver {
    private final Map<String, String> typeImports;
    private final Set<String> wildcardImports = new HashSet<String>();
    private final Set<String> staticImports = new HashSet<String>();

    public JavaImportSensitiveTypeResolver(ShallowEntity root) {
        this.typeImports = new HashMap<String, String>();
        List importEntities = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes(List.of(root), EnumSet.of(EShallowEntityType.META), Set.of("import", "static import"));
        for (ShallowEntity entity : importEntities) {
            if (TokenStreamUtils.firstTokenMatching((List<IToken>)entity.ownStartTokens(), (ITokenMatcher)ETokenType.STATIC) != -1) {
                this.staticImports.add(entity.getName());
                continue;
            }
            String importIdentifier = entity.getName();
            Pair pPackageImported = StringUtils.splitAtLast((String)importIdentifier, (char)'.');
            if (((String)pPackageImported.getSecond()).equals("*")) {
                this.wildcardImports.add((String)pPackageImported.getFirst());
                continue;
            }
            this.typeImports.put((String)pPackageImported.getSecond(), importIdentifier);
        }
    }

    public Optional<String> getFullyQualifiedTypeOfIdentifier(String identifier, ScopedTypeLookup lookup) {
        return Optional.ofNullable(lookup.getTypeInfo(identifier)).map(typedVariable -> this.getFullyQualifiedTypeName(typedVariable.getTypeNameWithoutGenericTypeParameter()));
    }

    public String getFullyQualifiedTypeName(String simpleType) {
        return this.typeImports.getOrDefault(simpleType, simpleType);
    }

    public Optional<Boolean> isOfType(List<IToken> tokens, Set<String> fullyQualifiedTypeNames, ScopedTypeLookup lookup) {
        return this.isOfType(tokens, fullyQualifiedTypeNames, lookup, Collections.emptySet());
    }

    public Optional<Boolean> isOfType(List<IToken> tokens, Set<String> fullyQualifiedTypeNames, ScopedTypeLookup lookup, Set<String> methods) {
        if (tokens.isEmpty()) {
            return Optional.empty();
        }
        IToken last = (IToken)Iterables.getLast(tokens);
        switch (last.getType()) {
            case IDENTIFIER: {
                return Optional.ofNullable(lookup.getTypeInfo(last.getText())).map(typedVariable -> this.typeIsOf(typedVariable.getTypeNameWithoutGenericTypeParameter(), fullyQualifiedTypeNames));
            }
            case RPAREN: {
                return this.callReturnsType(tokens, fullyQualifiedTypeNames, methods);
            }
        }
        return Optional.empty();
    }

    private Optional<Boolean> callReturnsType(List<IToken> tokens, Set<String> fullyQualifiedTypeNames, Set<String> methods) {
        int indexMatchingLparen = TokenStreamUtils.findMatchingOpeningToken(tokens, tokens.size() - 2, ETokenType.LPAREN, ETokenType.RPAREN);
        CCSMAssert.isFalse((indexMatchingLparen == -1 ? 1 : 0) != 0, (String)"tokens must include the opening parenthesis");
        if (indexMatchingLparen == 0) {
            return Optional.empty();
        }
        Optional<Boolean> constructor = this.checkConstructor(tokens, fullyQualifiedTypeNames, indexMatchingLparen);
        if (constructor.isPresent()) {
            return constructor;
        }
        if (tokens.get(indexMatchingLparen - 1).getType() == ETokenType.IDENTIFIER && methods.contains(tokens.get(indexMatchingLparen - 1).getText())) {
            return Optional.of(true);
        }
        return Optional.empty();
    }

    private Optional<Boolean> checkConstructor(List<IToken> tokens, Set<String> fullyQualifiedTypeNames, int indexMatchingLparen) {
        int qSequenceStart;
        int qSequenceEndNonInclusive = indexMatchingLparen;
        if (indexMatchingLparen - 2 >= 0 && tokens.get(indexMatchingLparen - 1).getType() == ETokenType.GT) {
            qSequenceEndNonInclusive = TokenStreamUtils.findMatchingOpeningToken(tokens, indexMatchingLparen - 2, ETokenType.LT, ETokenType.GT);
            CCSMAssert.isFalse((qSequenceEndNonInclusive == -1 ? 1 : 0) != 0, (String)"tokens must include opening generics delimiter");
        }
        if ((qSequenceStart = TokenStreamUtils.firstTokenOfAlternatingTypes(tokens, qSequenceEndNonInclusive - 1, ETokenType.IDENTIFIER, ETokenType.DOT)) != -1) {
            String qSequence = TokenStreamTextUtils.concatTokenTexts(tokens.subList(qSequenceStart, qSequenceEndNonInclusive));
            if (qSequenceStart - 1 >= 0 && tokens.get(qSequenceStart - 1).getType() == ETokenType.NEW) {
                return Optional.of(this.typeIsOf(qSequence, fullyQualifiedTypeNames));
            }
        }
        return Optional.empty();
    }

    public boolean typeIsOf(String type, Set<String> fullyQualifiedTypeNames) {
        if (fullyQualifiedTypeNames.contains(type)) {
            return true;
        }
        if (type.contains(".")) {
            return false;
        }
        String fullTypeName = this.typeImports.get(type);
        if (fullTypeName != null) {
            return fullyQualifiedTypeNames.contains(fullTypeName);
        }
        return fullyQualifiedTypeNames.stream().filter(fqType -> fqType.endsWith(type)).anyMatch(this::isWildcardImported);
    }

    public boolean isImported(String fullyQualifiedName) {
        String simpleName = StringUtils.getLastPart((String)fullyQualifiedName, (char)'.');
        if (this.typeImports.containsKey(simpleName)) {
            return this.typeImports.get(simpleName).equals(fullyQualifiedName);
        }
        return this.isWildcardImported(fullyQualifiedName);
    }

    private boolean isWildcardImported(String fullyQualifiedName) {
        return this.wildcardImports.contains(StringUtils.removeLastPart((String)fullyQualifiedName, (char)'.'));
    }

    public UnmodifiableSet<String> getStaticImports() {
        return CollectionUtils.asUnmodifiable(this.staticImports);
    }
}

