/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.variable.CLikeVariableUseExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

public class JavaLanguageFeatureParser
extends CLikeLanguageFeatureParserBase {
    public static final ITokenMatcher ADDITIONAL_TYPE_TOKENS = ETokenType.IDENTIFIER;
    public static final UnmodifiableSet<ETokenType> PRIMITIVE_TYPE_TOKENS = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.BOOLEAN, new ETokenType[]{ETokenType.CHAR, ETokenType.BYTE, ETokenType.SHORT, ETokenType.INT, ETokenType.LONG, ETokenType.FLOAT, ETokenType.DOUBLE, ETokenType.VOID, ETokenType.VAR}));
    public static final ITokenMatcher PRIMITIVE_TYPE_MATCHER = ITokenMatcher.anyOfType(PRIMITIVE_TYPE_TOKENS);
    public static final ITokenMatcher VALID_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.PERMITS, ETokenType.YIELD});
    public static final Set<String> TEST_ANNOTATION_NAMES = CollectionUtils.asUnmodifiableHashSet((Object[])new String[]{"Test", "org.junit.Test", "org.junit.jupiter.api.Test", "ParameterizedTest", "org.junit.jupiter.params.ParameterizedTest", "RepeatedTest", "org.junit.jupiter.api.RepeatedTest", "TestFactory", "org.junit.jupiter.api.TestFactory", "TestTemplate", "org.junit.jupiter.api.TestTemplate"});
    private static final TokenPattern PARAM_ANNOTATIONS_PATTERN_WITH_DOCS = new TokenPattern().sequence(ETokenType.AT_OPERATOR, new TokenPattern().skipTo(ETokenType.RPAREN)).group(0);
    private static final TokenPattern PARAM_ANNOTATIONS_PATTERN_WITHOUT_DOCS = new TokenPattern().sequence(ETokenType.AT_OPERATOR, new TokenPattern().regex("(QueryParam|PathParam)"), new TokenPattern().skipTo(ETokenType.RPAREN)).group(0);
    private static final UnmodifiableSet<String> GENERIC_EXCEPTION_NAMES = CollectionUtils.asUnmodifiable(JavaLanguageFeatureParser.generateExceptionNamesSet(RuntimeException.class, Error.class, Throwable.class, Exception.class));
    public static final String JUNIT_5_IMPORT_START = "org.junit.jupiter.";
    private static final Set<String> ASSERTION_TYPES = Set.of("org.junit.Assert", "org.junit.jupiter.api.Assertions", "org.assertj.core.api.Assertions", "org.fest.assertions.Assertions", "junit.framework.Assert", "org.assertj.core.api.Fail", "org.fest.assertions.Fail");
    private static final TokenPattern ANNOTATION_PATTERN = new TokenPattern().sequence(ETokenType.AT_OPERATOR).repeated(ETokenType.IDENTIFIER, ETokenType.DOT).sequence(ETokenType.IDENTIFIER).group(0);

    JavaLanguageFeatureParser() {
        super(ELanguage.JAVA, VALID_IDENTIFIERS, PRIMITIVE_TYPE_MATCHER, ADDITIONAL_TYPE_TOKENS, ETokenType.DOT, ".", new CLikeVariableUseExtractor(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.DOUBLE_COLON}), VALID_IDENTIFIERS));
    }

    @SafeVarargs
    public static Set<String> generateExceptionNamesSet(Class<? extends Throwable> ... exceptionClasses) {
        HashSet<String> exceptionNames = new HashSet<String>();
        for (Class<? extends Throwable> clazz : exceptionClasses) {
            exceptionNames.add(clazz.getSimpleName());
            exceptionNames.add(clazz.getName());
        }
        return exceptionNames;
    }

    public static List<IToken> getFieldDeclarationTokens(ShallowEntity attributeEntity) {
        UnmodifiableList tokens = attributeEntity.ownStartTokens();
        int definitionIndex = TokenStreamUtils.firstTokenMatching((List<IToken>)tokens, (ITokenMatcher)ETokenType.EQ);
        if (definitionIndex == -1) {
            return Collections.emptyList();
        }
        int endOffset = tokens.size();
        if (((IToken)tokens.getLast()).getType() == ETokenType.SEMICOLON) {
            --endOffset;
        }
        return tokens.subList(definitionIndex + 1, endOffset);
    }

    @Override
    public String getImportName(ShallowEntity entity) {
        CCSMAssert.isTrue((boolean)this.isImport(entity), (String)"entity.getType() must be equal to EShallowEntityType.META and entity.getSubtype() must be equal to SubTypeNames.IMPORT or SubTypeNames.STATIC_IMPORT");
        UnmodifiableList tokens = entity.ownStartTokens();
        if (TokenStreamUtils.firstTokenMatching((List<IToken>)tokens, (ITokenMatcher)ETokenType.STATIC) != -1) {
            return null;
        }
        String importName = entity.getName();
        return StringUtils.removeLastPart((String)importName, (char)'.');
    }

    @Override
    public boolean isImport(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && (entity.getSubtype().equals("import") || entity.getSubtype().equals("static import"));
    }

    public List<ShallowEntity> getImportStatements(List<ShallowEntity> ast) {
        return ShallowEntityTraversalUtils.listEntitiesOfType(ast, (EShallowEntityType)EShallowEntityType.META).stream().filter(this::isImport).toList();
    }

    public boolean isConstant(ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.ATTRIBUTE) {
            return false;
        }
        if (TokenStreamUtils.containsAll((List<IToken>)entity.ownStartTokens(), ETokenType.FINAL, ETokenType.STATIC)) {
            return true;
        }
        ShallowEntity parent = entity.getParent();
        return parent != null && parent.getType() == EShallowEntityType.TYPE && (parent.getSubtype().equals("interface") || parent.getSubtype().equals("@interface"));
    }

    public boolean isForEachLoop(ShallowEntity entity) {
        if (entity.getType() == EShallowEntityType.STATEMENT && entity.getSubtype().equals("for")) {
            return TokenStreamUtils.findFirstTopLevel((List<IToken>)entity.ownStartTokens(), (ITokenMatcher)ETokenType.COLON, List.of(ETokenType.LBRACE), List.of(ETokenType.RBRACE)) != -1;
        }
        return false;
    }

    @Override
    protected TokenPattern getParameterAnnotationPattern(boolean includesDocAnnotations) {
        if (includesDocAnnotations) {
            return PARAM_ANNOTATIONS_PATTERN_WITH_DOCS;
        }
        return PARAM_ANNOTATIONS_PATTERN_WITHOUT_DOCS;
    }

    public List<List<IToken>> getThrownTypesTokens(ShallowEntity methodEntity) {
        CCSMAssert.isTrue((methodEntity.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0, (String)"Only methods can throw exceptions");
        UnmodifiableList tokens = methodEntity.ownStartTokens();
        List<IToken> thrownClauseTokens = TokenStreamUtils.tokensBetween((List<IToken>)tokens, EnumSet.of(ETokenType.THROWS), EnumSet.of(ETokenType.LBRACE, ETokenType.SEMICOLON));
        if (thrownClauseTokens.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        return TokenStreamUtils.split(thrownClauseTokens, ETokenType.COMMA);
    }

    public IToken getThrowsToken(ShallowEntity methodEntity) {
        CCSMAssert.isTrue((methodEntity.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0, (String)"Only methods can throw exceptions");
        UnmodifiableList tokens = methodEntity.ownStartTokens();
        int throwsTokenIndex = TokenStreamUtils.firstTokenMatching((List<IToken>)tokens, (ITokenMatcher)ETokenType.THROWS);
        if (throwsTokenIndex == -1) {
            return null;
        }
        return (IToken)tokens.get(throwsTokenIndex);
    }

    public boolean isAnnotated(ShallowEntity entity) {
        return !JavaLanguageFeatureParser.getAnnotations(entity).isEmpty();
    }

    public String getDetailedReturnType(ShallowEntity entity) {
        CCSMAssert.isTrue((entity.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0, (String)"May only be applied to methods!");
        CCSMAssert.isFalse((boolean)ShallowParsingUtils.isLambdaMethod(entity), (String)"May not be applied to lambda methods!");
        UnmodifiableList tokens = entity.ownStartTokens();
        int nameIndex = JavaLanguageFeatureParser.getMethodNameIndex(entity, (List<IToken>)tokens);
        List<IToken> typeTokens = JavaLanguageFeatureParser.getDetailedReturnTypeTokens((List<IToken>)tokens, nameIndex);
        return TokenStreamTextUtils.concatTokenTexts(typeTokens);
    }

    private static int getMethodNameIndex(ShallowEntity entity, List<IToken> tokens) {
        int nameIndex = 0;
        for (IToken token : tokens) {
            if (!token.getText().equals(entity.getName())) continue;
            nameIndex = tokens.indexOf(token);
        }
        return nameIndex;
    }

    private static List<IToken> getDetailedReturnTypeTokens(List<IToken> tokens, int nameIndex) {
        int startIndex = nameIndex - 1;
        while (startIndex >= 2) {
            ETokenType startType = tokens.get(startIndex).getType();
            if (startType == ETokenType.RBRACK || startType == ETokenType.IDENTIFIER && tokens.get(startIndex - 1).getType() == ETokenType.DOT) {
                startIndex -= 2;
                continue;
            }
            if (startType != ETokenType.GT) break;
            startIndex = TokenStreamUtils.findMatchingOpeningToken(tokens, startIndex - 1, ETokenType.LT, ETokenType.GT) - 1;
        }
        return tokens.subList(startIndex, nameIndex);
    }

    public boolean isGenericExceptionClass(String className) {
        return GENERIC_EXCEPTION_NAMES.contains((Object)className);
    }

    @Override
    protected List<IToken> filterGenericTokens(List<IToken> genericTokens) {
        if (genericTokens.isEmpty()) {
            return genericTokens;
        }
        return Collections.singletonList(genericTokens.getFirst());
    }

    public Optional<String> getPackageName(List<ShallowEntity> shallowEntities) {
        return shallowEntities.stream().filter(entity -> entity.getType() == EShallowEntityType.META && "package".equals(entity.getSubtype())).map(ShallowEntity::getName).filter(Objects::nonNull).findFirst();
    }

    public String getFullClassName(ShallowEntity shallowEntity) {
        Optional firstType = ShallowEntityTraversalUtils.findEntityOrParentEntity((ShallowEntity)shallowEntity, entity -> entity.getType() == EShallowEntityType.TYPE);
        if (firstType.isEmpty()) {
            return "";
        }
        ArrayList<String> classNames = new ArrayList<String>();
        ShallowEntity parent = (ShallowEntity)firstType.get();
        do {
            String testClassName = parent.getName();
            classNames.addFirst(testClassName);
        } while ((parent = parent.getParent()) != null && parent.getType() == EShallowEntityType.TYPE);
        return String.join((CharSequence)"$", classNames);
    }

    public TokenPattern interfaceExtendsPattern() {
        return new TokenPattern().sequence(ETokenType.INTERFACE, ETokenType.IDENTIFIER).skipNested(ETokenType.LT, ETokenType.GT, true).sequence(ETokenType.EXTENDS);
    }

    public TokenPattern classExtendsPattern() {
        return new TokenPattern().sequence(ETokenType.CLASS, ETokenType.IDENTIFIER).skipNested(ETokenType.LT, ETokenType.GT, true).sequence(ETokenType.EXTENDS);
    }

    public static boolean isTestClass(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.TYPE && entity.getChildren().stream().filter(child -> child.getType() == EShallowEntityType.METHOD).anyMatch(method -> CLikeLanguageFeatureParserBase.getAnnotations(method).stream().anyMatch(JavaLanguageFeatureParser::isTestAnnotation));
    }

    public static boolean isTestAnnotation(ShallowEntity annotationEntity) {
        return CLikeLanguageFeatureParserBase.isSpecificAnnotation(annotationEntity, TEST_ANNOTATION_NAMES);
    }

    public static boolean isTestMethod(ShallowEntity method) {
        List<ShallowEntity> annotations = JavaLanguageFeatureParser.getAnnotations(method);
        Optional<ShallowEntity> testAnnotation = annotations.stream().filter(JavaLanguageFeatureParser::isTestAnnotation).findFirst();
        return testAnnotation.isPresent();
    }

    public boolean hasNoJUnit5Import(List<ShallowEntity> topLevelEntities) {
        return this.getImportsByPrefix(topLevelEntities, JUNIT_5_IMPORT_START).isEmpty();
    }

    public Set<String> getImports(List<ShallowEntity> entities) {
        return this.getImportsByPrefix(entities, "");
    }

    public List<String> getImportsAndFullNamespaceVariables(List<ShallowEntity> entities) {
        ArrayList<String> imports = new ArrayList<String>(this.getImportsByPrefix(entities, ""));
        for (ShallowEntity entity : ShallowEntityTraversalUtils.listEntitiesOfTypes(entities, Set.of(EShallowEntityType.META, EShallowEntityType.STATEMENT))) {
            if (JavaLanguageFeatureParser.isAnnotation(entity) && entity.getName() != null && !((String)StringUtils.splitAtFirst((String)entity.getName(), (String)".").getSecond()).isEmpty()) {
                imports.add(entity.getName());
                continue;
            }
            if (entity.getType() != EShallowEntityType.STATEMENT || !"local variable".equals(entity.getSubtype())) continue;
            TokenPattern pattern = new TokenPattern().sequence(ETokenType.IDENTIFIER).group(0).repeatedAtLeastOnce(ETokenType.DOT, ETokenType.IDENTIFIER).group(1).sequence(ETokenType.IDENTIFIER, ETokenType.EQ);
            for (TokenPatternMatch match : pattern.findAll((List<IToken>)entity.ownStartTokens())) {
                imports.add(match.groupString(0) + match.groupString(1));
            }
        }
        return imports;
    }

    public Set<String> getImportsByPrefix(List<ShallowEntity> entities, String prefix) {
        return entities.stream().filter(entity -> entity.getType() == EShallowEntityType.META && "import".equals(entity.getSubtype()) && entity.getName() != null && entity.getName().startsWith(prefix)).map(ShallowEntity::getName).collect(Collectors.toSet());
    }

    public boolean isConstructorOfType(ShallowEntity type, ShallowEntity child) {
        return type.getType() == EShallowEntityType.TYPE && child.getType() == EShallowEntityType.METHOD && type.getName() != null && child.getName() != null && Objects.equals(type.getName(), child.getName());
    }

    public Set<String> extractStaticImportedAssertions(List<ShallowEntity> importStatements) {
        HashSet<String> staticImportedAssertionMethods = new HashSet<String>();
        for (ShallowEntity importStatement : importStatements) {
            Pair importedTypeAndMethod;
            String subtype = importStatement.getSubtype();
            if (importStatement.getName() == null || !"static import".equals(subtype) || !ASSERTION_TYPES.contains((importedTypeAndMethod = StringUtils.splitAtLast((String)importStatement.getName(), (char)'.')).getFirst()) || !this.isAssertionMethod((String)importedTypeAndMethod.getSecond())) continue;
            staticImportedAssertionMethods.add((String)importedTypeAndMethod.getSecond());
        }
        return staticImportedAssertionMethods;
    }

    public Set<String> extractImportedAssertionsTypes(List<ShallowEntity> importStatements) {
        HashSet<String> importedAssertionTypes = new HashSet<String>();
        for (ShallowEntity importStatement : importStatements) {
            String subtype = importStatement.getSubtype();
            if (importStatement.getName() == null || !"import".equals(subtype) || !ASSERTION_TYPES.contains(importStatement.getName())) continue;
            String assertionType = (String)StringUtils.splitAtLast((String)importStatement.getName(), (char)'.').getSecond();
            importedAssertionTypes.add(assertionType);
        }
        return importedAssertionTypes;
    }

    private boolean isAssertionType(String typeName) {
        return ASSERTION_TYPES.contains(typeName);
    }

    private boolean isAssertionMethod(String methodName) {
        return methodName.startsWith("assert") || methodName.startsWith("fail");
    }

    public List<IToken> getAssertionCalls(ShallowEntity statement, Set<String> importedAssertionTypes, Set<String> staticImportedAssertionMethods) {
        ArrayList<IToken> assertionCallTokens = new ArrayList<IToken>();
        List<TokenPatternMatch> matches = new TokenPattern().repeated(ETokenType.IDENTIFIER, ETokenType.DOT).group(0).sequence(ETokenType.IDENTIFIER, ETokenType.LPAREN).group(1).findNonOverlappingMatches((List<IToken>)statement.ownStartTokens());
        for (TokenPatternMatch match : matches) {
            List<IToken> methodCall = match.groupTokens(1);
            String typeName = TokenStreamTextUtils.concatTokenTexts(match.groupTokens(0));
            String methodCallName = methodCall.getFirst().getText();
            if (typeName.isEmpty()) {
                if (!staticImportedAssertionMethods.contains(methodCallName)) continue;
                assertionCallTokens.add(methodCall.getFirst());
                continue;
            }
            if ((typeName = typeName.substring(0, typeName.length() - 1)).contains(".")) {
                if (!LanguageFeatureParser.JAVA.isAssertionType(typeName) || !LanguageFeatureParser.JAVA.isAssertionMethod(methodCallName)) continue;
                assertionCallTokens.add(methodCall.getFirst());
                continue;
            }
            if (!importedAssertionTypes.contains(typeName) || !LanguageFeatureParser.JAVA.isAssertionMethod(methodCallName)) continue;
            assertionCallTokens.add(methodCall.getFirst());
        }
        return assertionCallTokens;
    }

    public @Nullable ShallowEntity findTryStatement(ShallowEntity catchEntity) {
        if (catchEntity.getParent() == null) {
            return null;
        }
        UnmodifiableList siblingEntities = catchEntity.getParent().getChildren();
        boolean foundCatch = false;
        for (ShallowEntity sibling : siblingEntities.reversed()) {
            if (sibling.equals(catchEntity)) {
                foundCatch = true;
            }
            if (!foundCatch || !"try".equals(sibling.getSubtype())) continue;
            return sibling;
        }
        return null;
    }

    public boolean annotationHasParameters(@NonNull ShallowEntity annotation) {
        return !this.getAnnotationParameterTokens(annotation).isEmpty();
    }

    public @NonNull List<IToken> getAnnotationParameterTokens(@NonNull ShallowEntity annotation) {
        CCSMAssert.isTrue((boolean)JavaLanguageFeatureParser.isAnnotation(annotation), (String)"`annotation` must be an annotation entity");
        return TokenStreamUtils.tokensBetween((List<IToken>)annotation.ownStartTokens(), ETokenType.LPAREN, ETokenType.RPAREN);
    }

    public List<String> getImplementedInterfaces(@NonNull ShallowEntity type) {
        int endIndex;
        int startIndex;
        UnmodifiableList startTokens = type.ownStartTokens();
        int implementsIndex = TokenStreamUtils.findFirstTopLevel((List<IToken>)startTokens, (ITokenMatcher)ETokenType.IMPLEMENTS, List.of(ETokenType.LPAREN), List.of(ETokenType.RPAREN));
        if (implementsIndex == -1) {
            return Collections.emptyList();
        }
        int extendsIndex = TokenStreamUtils.findFirstTopLevel((List<IToken>)startTokens, (ITokenMatcher)ETokenType.EXTENDS, List.of(ETokenType.LPAREN), List.of(ETokenType.RPAREN));
        int braceIndex = TokenStreamUtils.findFirstTopLevel((List<IToken>)startTokens, (ITokenMatcher)ETokenType.LBRACE, List.of(ETokenType.LPAREN), List.of(ETokenType.RPAREN));
        if (implementsIndex > extendsIndex) {
            startIndex = implementsIndex + 1;
            endIndex = braceIndex;
        } else {
            startIndex = implementsIndex + 1;
            endIndex = Math.min(extendsIndex, braceIndex);
        }
        UnmodifiableList tokensBetween = startTokens.subList(startIndex, endIndex);
        List<List<IToken>> splittedTokens = TokenStreamUtils.splitWithNesting((List<IToken>)tokensBetween, ETokenType.COMMA, ETokenType.LT, ETokenType.GT);
        return splittedTokens.stream().map(this::getInterfaceName).toList();
    }

    private String getInterfaceName(List<IToken> tokens) {
        List<IToken> tokensWithoutGenerics = this.getTokensWithoutGenerics(tokens);
        TokenPatternMatch tokenPatternMatch = ANNOTATION_PATTERN.matchAtStartOf(tokensWithoutGenerics);
        if (tokenPatternMatch == null) {
            return TokenStreamTextUtils.concatTokenTexts(tokensWithoutGenerics);
        }
        int endOfAnnotations = tokenPatternMatch.groupIndices(0).getFirst();
        List<IToken> tokensWithoutAnnotations = tokensWithoutGenerics.subList(endOfAnnotations + 1, tokensWithoutGenerics.size());
        return TokenStreamTextUtils.concatTokenTexts(tokensWithoutAnnotations);
    }

    private List<IToken> getTokensWithoutGenerics(List<IToken> tokens) {
        int startGenerics = TokenStreamUtils.findFirstTopLevel(tokens, (ITokenMatcher)ETokenType.LT, List.of(ETokenType.LPAREN), List.of(ETokenType.RPAREN));
        if (startGenerics == -1) {
            return tokens;
        }
        return tokens.subList(0, startGenerics);
    }
}

