/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.abap;

import com.teamscale.index.metadata.abap.AbapFileMetadata;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.abap.FunctionCallInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public abstract class AbapCheckUtils {
    public static final int SY_SUBRC_NO_ERROR = 0;
    public static final Set<ETokenType> TOKEN_TYPES_POTENTIALLY_CONTAINING_VARIABLE_NAMES = CollectionUtils.unionSet((Collection)ETokenType.IDENTIFIERS, (Collection[])new Collection[]{ETokenType.KEYWORDS});
    public static final Set<String> EVENT_TYPES = CollectionUtils.asHashSet((Object[])new String[]{"at line-selection", "pf event", "at selection-screen", "at user-command", "end-of-page", "end-of-selection", "initialization", "load-of-program", "start-of-selection", "top-of-page", "get late", "get", "top-of-page during line-selection"});
    private static final Set<String> PARENT_TYPES_OF_CLASS_SCOPE = CollectionUtils.asHashSet((Object[])new String[]{"class definition", "class implementation", "interface definition"});
    private static final Set<String> PARENT_TYPES_OF_GLOBAL_SCOPE = CollectionUtils.unionSet((Collection)CollectionUtils.asHashSet((Object[])new String[]{"report", "program", "document-root"}), (Collection[])new Collection[]{EVENT_TYPES});
    private static final Set<String> PARENT_TYPES_OF_LOCAL_VALID_SCOPE = CollectionUtils.asHashSet((Object[])new String[]{"method declaration", "method implementation", "form", "module input", "module output", "function"});
    private static final String META_COMMENT_IS_RFC_ENABLED = "*#$#* teamscale-meta[rfc-enabled] *#$#*";

    public static boolean isEntityWithinClassScope(ShallowEntity entity) {
        CCSMAssert.isNotNull((Object)entity.getParent(), (String)("Entity " + String.valueOf(entity) + " must have a parent."));
        String currSubtype = entity.getParent().getSubtype();
        return PARENT_TYPES_OF_CLASS_SCOPE.contains(currSubtype);
    }

    public static boolean isEntityWithinGlobalScope(ShallowEntity entity) {
        CCSMAssert.isNotNull((Object)entity.getParent(), (String)("Entity " + String.valueOf(entity) + " must have a parent."));
        String currSubtype = entity.getParent().getSubtype();
        return PARENT_TYPES_OF_GLOBAL_SCOPE.contains(currSubtype);
    }

    public static boolean isEntityWithinLocalValidScope(ShallowEntity entity) {
        CCSMAssert.isNotNull((Object)entity.getParent(), (String)("Entity " + String.valueOf(entity) + " must have a parent."));
        String currSubtype = entity.getParent().getSubtype();
        return PARENT_TYPES_OF_LOCAL_VALID_SCOPE.contains(currSubtype);
    }

    public static boolean isIgnoredForDatabaseChecks(ShallowEntity entity, List<ShallowEntity> rootEntities, String uniformPath) {
        if (uniformPath.contains("/FUGR/") || AbapCheckUtils.containsInclude(rootEntities)) {
            return true;
        }
        if (uniformPath.contains("/PROG/") && !AbapCheckUtils.isReportOrProgram(rootEntities)) {
            return true;
        }
        ShallowEntity method = AbapCheckUtils.getMethodAncestor(entity);
        if (method == null) {
            return false;
        }
        if ("method implementation".equals(method.getSubtype())) {
            return LanguageFeatureParser.ABAP.getDeclarationTokensForMethod(rootEntities, method) == null;
        }
        return false;
    }

    public static boolean isVariable(String identifier, ShallowEntity entity, ITypeResolution typeResolution) {
        identifier = LanguageFeatureParser.ABAP.normalizeVariable(identifier);
        ScopedTypeLookup currentTypeLookup = typeResolution.getTypeLookup(entity);
        if (currentTypeLookup.containsVariable(identifier)) {
            return true;
        }
        ScopedTypeLookup globalLookup = AbapCheckUtils.getGlobalLookup(entity, typeResolution);
        if (globalLookup != null && globalLookup.containsVariable(identifier)) {
            return true;
        }
        if (identifier.contains("-")) {
            return AbapCheckUtils.isVariable(StringUtils.getFirstParts((String)identifier, (int)1, (char)'-'), entity, typeResolution);
        }
        return false;
    }

    private static boolean isReportOrProgram(List<ShallowEntity> rootEntities) {
        Predicate<ShallowEntity> hasReportOrProgramSubType = entity -> entity.getSubtype().equals("report") || entity.getSubtype().equals("program");
        return rootEntities.stream().anyMatch(hasReportOrProgramSubType) || ShallowEntityTraversalUtils.listMethodsNonRecursive(rootEntities).stream().anyMatch(hasReportOrProgramSubType);
    }

    private static ScopedTypeLookup getGlobalLookup(ShallowEntity entity, ITypeResolution typeResolution) {
        ShallowEntity method = AbapCheckUtils.getMethodAncestor(entity);
        if (method == null) {
            return null;
        }
        return AbapCheckUtils.getReportOrProgram(method).flatMap(r -> r.getChildren().stream().findFirst()).map(typeResolution::getTypeLookup).orElse(null);
    }

    private static Optional<ShallowEntity> getReportOrProgram(ShallowEntity method) {
        if (method.getParent() == null) {
            return Optional.empty();
        }
        return method.getParent().getChildrenOfType(EShallowEntityType.METHOD).stream().filter(child -> child.getSubtype().equals("report") || child.getSubtype().equals("program")).findFirst();
    }

    private static boolean containsInclude(List<ShallowEntity> rootEntities) {
        List includes = ShallowEntityTraversalUtils.selectEntities(rootEntities, LanguageFeatureParser.ABAP::isProgramInclude);
        return !includes.isEmpty();
    }

    private static ShallowEntity getMethodAncestor(ShallowEntity entity) {
        while (entity != null) {
            if (entity.getType() == EShallowEntityType.METHOD) {
                return entity;
            }
            entity = entity.getParent();
        }
        return null;
    }

    public static boolean isFunctionCallOfAny(ShallowEntity entity, String ... functionNames) throws CheckException {
        Optional<FunctionCallInfo> functionCallInfo = LanguageFeatureParser.ABAP.getFunctionCallInfo(entity);
        return functionCallInfo.filter(callInfo -> Arrays.asList(functionNames).contains(callInfo.getFunctionName())).isPresent();
    }

    public static String getNormalizedStartTokensText(ShallowEntity entity, ICheckContext context) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (tokens.isEmpty()) {
            return "";
        }
        String statementText = context.getTextContent(ECodeViewOption.ETextViewOption.FILTERED_CONTENT).substring(((IToken)tokens.get(0)).getOffset(), ((IToken)tokens.get(tokens.size() - 1)).getEndOffset() + 1);
        return statementText.replaceAll("(?m)^\\*.*", "").replaceAll("\"[^']*?\\n", " ").trim().replaceAll("\\s+\\.$", ".").replaceAll("\\s+", " ");
    }

    public static boolean hasMetaCommentForRfcEnablement(String unfilteredContent) {
        List lines = StringUtils.splitLinesAsList((String)unfilteredContent);
        return AbapCheckUtils.hasMetaCommentForRfcEnablement(lines);
    }

    private static boolean hasMetaCommentForRfcEnablement(List<String> contentLines) {
        if (contentLines.isEmpty()) {
            return false;
        }
        return contentLines.get(contentLines.size() - 1).equals(META_COMMENT_IS_RFC_ENABLED);
    }

    public static boolean isInlineDataDeclaration(ShallowEntity entity) {
        UnmodifiableList includedTokens = entity.includedTokens();
        return TokenStreamUtils.startsWith((List<IToken>)includedTokens, ETokenType.DATA, ETokenType.LPAREN);
    }

    public static boolean isRfcEnabled(ICheckContext context) throws CheckException {
        if (AbapCheckUtils.hasMetaCommentForRfcEnablement(context.getTextContent(ECodeViewOption.ETextViewOption.UNFILTERED_CONTENT))) {
            return true;
        }
        Optional<AbapFileMetadata> optionalMetadata = context.getMetadataOfType(AbapFileMetadata.class);
        if (optionalMetadata.isPresent()) {
            return optionalMetadata.get().isRfcEnabled();
        }
        return false;
    }
}

