/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.cpp;

import com.google.common.annotations.VisibleForTesting;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;

public class BinarySizeCheckUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    static final String ADDITIONAL_TYPE_SIZE_JVM_FLAG_NAME = "com.teamscale.experimental.type-to-size.additional";
    private static final Pattern TYPE_TO_SIZE_FROM_JVM_FLAG_PATTERN = Pattern.compile("->");
    private static final int FILL_ARCHITECTURE_WORD_SIZE_PLACEHOLDER = -1;
    private static final int DEFAULT_ARCHITECTURE_WORD_SIZE_BYTES = 8;
    private static final Map<String, Integer> PRIMITIVE_TYPE_BYTE_SIZE = Map.ofEntries(Map.entry("char", 1), Map.entry("short", 2), Map.entry("short int", 2), Map.entry("int", 4), Map.entry("float", 4), Map.entry("double", 8), Map.entry("long", -1), Map.entry("long int", -1), Map.entry("long long", 8), Map.entry("long long int", 8), Map.entry("long double", 16));
    private static final Map<String, Integer> TYPE_TO_BYTE_SIZE = new HashMap<String, Integer>();

    public static Optional<Integer> determineSizeOfType(TypedVariable type) {
        return BinarySizeCheckUtils.determineSizeOfType(type.getTypeName());
    }

    public static Optional<Integer> determineSizeOfType(TypedVariable type, int architectureWordSizeInBytes) {
        return BinarySizeCheckUtils.determineSizeOfType(type.getTypeName(), architectureWordSizeInBytes);
    }

    public static Optional<Integer> determineSizeOfType(String typeName) {
        return BinarySizeCheckUtils.determineSizeOfType(typeName, 8);
    }

    public static Optional<Integer> determineSizeOfType(String typeName, int architectureWordSizeInBytes) {
        String simplifiedTypeName = StringUtils.stripPrefix((String)typeName, (String)"std::");
        if ((simplifiedTypeName = StringUtils.stripSuffix((String)simplifiedTypeName, (String)"[]")).endsWith("*")) {
            return Optional.of(architectureWordSizeInBytes);
        }
        Integer result = TYPE_TO_BYTE_SIZE.get(simplifiedTypeName);
        if (result == null) {
            LOGGER.debug("Could not determine size of type {}", (Object)typeName);
        } else if (result == -1) {
            result = architectureWordSizeInBytes;
        }
        return Optional.ofNullable(result);
    }

    public static int calculatePadding(int memoryOffset, int alignment) {
        int overshoot = memoryOffset % alignment;
        if (overshoot > 0) {
            return alignment - overshoot;
        }
        return 0;
    }

    private static void addSizesForPrimitiveTypes() {
        for (Map.Entry<String, Integer> entry : PRIMITIVE_TYPE_BYTE_SIZE.entrySet()) {
            String type = entry.getKey();
            int size = entry.getValue();
            TYPE_TO_BYTE_SIZE.put(type, size);
            TYPE_TO_BYTE_SIZE.put("signed " + type, size);
            TYPE_TO_BYTE_SIZE.put("unsigned " + type, size);
        }
    }

    private static void addSizesForFixedWidthTypes() {
        TYPE_TO_BYTE_SIZE.putAll(BinarySizeCheckUtils.createVariationsOfFixedWidthTypes("int", 1, 2, 4, 8));
        TYPE_TO_BYTE_SIZE.putAll(BinarySizeCheckUtils.createVariationsOfFixedWidthTypes("int_fast", 1, 2, 4, 8));
        TYPE_TO_BYTE_SIZE.putAll(BinarySizeCheckUtils.createVariationsOfFixedWidthTypes("int_least", 1, 2, 4, 8));
        TYPE_TO_BYTE_SIZE.putAll(BinarySizeCheckUtils.createVariationsOfFixedWidthTypes("uint", 1, 2, 4, 8, 16));
        TYPE_TO_BYTE_SIZE.putAll(BinarySizeCheckUtils.createVariationsOfFixedWidthTypes("uint_fast", 1, 2, 4, 8));
        TYPE_TO_BYTE_SIZE.putAll(BinarySizeCheckUtils.createVariationsOfFixedWidthTypes("uint_least", 1, 2, 4, 8));
        TYPE_TO_BYTE_SIZE.put("intmax_t", -1);
        TYPE_TO_BYTE_SIZE.put("intptr_t", -1);
        TYPE_TO_BYTE_SIZE.put("uintmax_t", -1);
        TYPE_TO_BYTE_SIZE.put("uintptr_t", -1);
        TYPE_TO_BYTE_SIZE.putAll(BinarySizeCheckUtils.createVariationsOfFixedWidthTypes("char", 1, 2, 4));
    }

    private static Map<String, Integer> createVariationsOfFixedWidthTypes(String type, int ... sizesInBytes) {
        HashMap<String, Integer> variations = new HashMap<String, Integer>();
        for (int sizeInBytes : sizesInBytes) {
            String typeNameWithSizeSuffix = type + 8 * sizeInBytes + "_t";
            variations.put(typeNameWithSizeSuffix, sizeInBytes);
            variations.put("__" + typeNameWithSizeSuffix, sizeInBytes);
        }
        return variations;
    }

    private static void addSizesFromJvmFlag() {
        String[] additionalTypeSizeDefinitions;
        String additionalTypeSizesJvmFlagValue = System.getProperty(ADDITIONAL_TYPE_SIZE_JVM_FLAG_NAME);
        if (additionalTypeSizesJvmFlagValue == null) {
            return;
        }
        for (String additionalTypeSizeDefinition : additionalTypeSizeDefinitions = additionalTypeSizesJvmFlagValue.split(";")) {
            String[] nameAndSize = TYPE_TO_SIZE_FROM_JVM_FLAG_PATTERN.split(additionalTypeSizeDefinition);
            if (nameAndSize.length != 2) {
                LOGGER.warn("Could not parse additional type size definition: {}", (Object)additionalTypeSizeDefinition);
                continue;
            }
            String name = nameAndSize[0].trim();
            int sizeInBytes = Integer.parseInt(nameAndSize[1].trim());
            TYPE_TO_BYTE_SIZE.put(name, sizeInBytes);
        }
    }

    public static boolean isSupportedType(String type) {
        return TYPE_TO_BYTE_SIZE.containsKey(type);
    }

    static {
        BinarySizeCheckUtils.addSizesForPrimitiveTypes();
        BinarySizeCheckUtils.addSizesForFixedWidthTypes();
        BinarySizeCheckUtils.addSizesFromJvmFlag();
        TYPE_TO_BYTE_SIZE.put("bool", 1);
        TYPE_TO_BYTE_SIZE.put("unsigned", 4);
        TYPE_TO_BYTE_SIZE.put("signed", 4);
        TYPE_TO_BYTE_SIZE.put("void", -1);
        TYPE_TO_BYTE_SIZE.put("size_t", -1);
    }
}

