/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.util;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class TernaryOperatorCheckUtil {
    public static List<Integer> findOccurrences(ShallowEntity statement) {
        ArrayList<Integer> finalIndices;
        block3: {
            UnmodifiableList tokens;
            block2: {
                finalIndices = new ArrayList<Integer>();
                tokens = statement.ownStartTokens();
                if (!TokenStreamUtils.containsAll((List<IToken>)tokens, ETokenType.QUESTION, ETokenType.COLON)) break block2;
                List<Integer> questionMarkIndices = TokenStreamUtils.findAll((List<IToken>)tokens, (ITokenMatcher)ETokenType.QUESTION);
                for (int i : questionMarkIndices) {
                    TernaryOperatorCheckUtil.checkSurroundingOfQuestionMark(finalIndices, (List<IToken>)tokens, i);
                }
                break block3;
            }
            if (ShallowParsingUtils.getLanguage(statement) != ELanguage.PYTHON || !TokenStreamUtils.containsAll((List<IToken>)tokens, ETokenType.IF, ETokenType.ELSE)) break block3;
            List<Integer> elseIndices = TokenStreamUtils.findAll((List<IToken>)tokens, (ITokenMatcher)ETokenType.ELSE);
            for (int i : elseIndices) {
                TernaryOperatorCheckUtil.checkElseSuccessorReportIfIndex(finalIndices, (List<IToken>)tokens, i);
            }
        }
        return finalIndices;
    }

    private static void checkElseSuccessorReportIfIndex(List<Integer> indices, List<IToken> tokens, int indexElse) {
        int successorIndex = indexElse + 1;
        if (successorIndex >= tokens.size()) {
            return;
        }
        if (tokens.get(successorIndex).getType() == ETokenType.COLON) {
            return;
        }
        int correspondingIfIndex = TokenStreamUtils.findMatchingOpeningToken(tokens, indexElse - 1, ETokenType.IF, ETokenType.ELSE);
        if (correspondingIfIndex > -1) {
            indices.add(indexElse);
        }
    }

    private static void checkSurroundingOfQuestionMark(List<Integer> indices, List<IToken> tokens, int indexQuestionMark) {
        EnumSet<ETokenType> closingTypes;
        if (TernaryOperatorCheckUtil.isJavaGenericTypeArgument(tokens, indexQuestionMark)) {
            return;
        }
        ELanguage language = tokens.get(0).getLanguage();
        if (PreprocessorUtils.hasPreprocessor(language) && PreprocessedTokenStreamUtils.isTokenMacroExpanded(tokens.get(indexQuestionMark))) {
            return;
        }
        if (language == ELanguage.CS && indexQuestionMark + 1 < tokens.size() && EnumSet.of(ETokenType.DOT, ETokenType.LBRACK).contains(tokens.get(indexQuestionMark + 1).getType())) {
            return;
        }
        EnumSet<ETokenType> openingTypes = EnumSet.of(ETokenType.QUESTION);
        int indexColon = TokenStreamUtils.findMatchingClosingToken(tokens, indexQuestionMark + 1, openingTypes, closingTypes = language == ELanguage.JAVASCRIPT || language == ELanguage.CS ? EnumSet.of(ETokenType.COLON, ETokenType.DOT, ETokenType.LBRACK) : EnumSet.of(ETokenType.COLON));
        if (indexColon == -1) {
            return;
        }
        if (language == ELanguage.JAVASCRIPT && (TernaryOperatorCheckUtil.isTypescriptVariableDeclaration(indexQuestionMark, indexColon) || TernaryOperatorCheckUtil.isTypeScriptOptionalChaining(tokens, indexQuestionMark) || TernaryOperatorCheckUtil.isInJavascriptObjectDeclaration(tokens, indexQuestionMark, indexColon))) {
            return;
        }
        indices.add(indexQuestionMark);
    }

    private static boolean isTypeScriptOptionalChaining(List<IToken> tokens, int indexQuestionMark) {
        return indexQuestionMark + 1 < tokens.size() && tokens.get(indexQuestionMark + 1).getType() == ETokenType.DOT;
    }

    private static boolean isJavaGenericTypeArgument(List<IToken> tokens, int indexQuestionMark) {
        if (indexQuestionMark < 1) {
            return false;
        }
        ETokenType predecessorTokenType = tokens.get(indexQuestionMark - 1).getType();
        if (predecessorTokenType == ETokenType.LT) {
            return true;
        }
        if (indexQuestionMark + 1 >= tokens.size()) {
            return false;
        }
        ETokenType successorTokenType = tokens.get(indexQuestionMark + 1).getType();
        return predecessorTokenType == ETokenType.COMMA && (successorTokenType == ETokenType.GT || successorTokenType == ETokenType.COMMA || successorTokenType == ETokenType.EXTENDS || successorTokenType == ETokenType.SUPER);
    }

    private static boolean isTypescriptVariableDeclaration(int indexQuestionMark, int indexColon) {
        return indexColon == indexQuestionMark + 1;
    }

    private static boolean isInJavascriptObjectDeclaration(List<IToken> tokens, int indexQuestionMark, int indexColon) {
        int propertyIndex = indexColon - 1;
        if (propertyIndex <= 0) {
            return false;
        }
        ETokenType predecessorTokenType = tokens.get(propertyIndex).getType();
        if (!EnumSet.of(ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL).contains(predecessorTokenType)) {
            if (predecessorTokenType != ETokenType.RBRACK) {
                return false;
            }
            if ((propertyIndex = TokenStreamUtils.findMatchingOpeningToken(tokens, propertyIndex - 1, ETokenType.LBRACK, ETokenType.RBRACK)) <= 0) {
                return false;
            }
        }
        ETokenType tokenBeforeProperty = tokens.get(propertyIndex - 1).getType();
        if (!EnumSet.of(ETokenType.LBRACE, ETokenType.COMMA).contains(tokenBeforeProperty)) {
            return false;
        }
        return !TokenStreamUtils.contains(tokens, indexQuestionMark, indexColon, ETokenType.LBRACE);
    }
}

