/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.global;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.DetailedInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.NumberInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.global.GlobalComparisonContributionBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class UserGroupComparisonContribution
extends GlobalComparisonContributionBase {
    private static final long serialVersionUID = 1L;
    private static final String USERS_PROPERTY = "users";
    private static final String GROUPS_PROPERTY = "groups";
    @JsonProperty(value="users")
    private final Set<String> users;
    @JsonProperty(value="groups")
    private final Set<String> groups;

    @JsonCreator
    public UserGroupComparisonContribution(@JsonProperty(value="contributor") String contributor, @JsonProperty(value="users") Collection<String> users, @JsonProperty(value="groups") Collection<String> groups) {
        super(contributor);
        this.users = CollectionUtils.mapToSet(users, String::toLowerCase);
        this.groups = new HashSet<String>(groups);
    }

    public Map<String, IInstanceComparisonValue> getValues(InstanceComparisonContributionBase.ComparisonContext context) {
        HashMap<String, IInstanceComparisonValue> userGroupMap = new HashMap<String, IInstanceComparisonValue>();
        userGroupMap.put("Users", UserGroupComparisonContribution.createValue("Users", this.users, DetailedInstanceComparisonValue::ofUser));
        userGroupMap.put("Groups", UserGroupComparisonContribution.createValue("Groups", this.groups, DetailedInstanceComparisonValue::ofGroup));
        return userGroupMap;
    }

    private static @NonNull NumberInstanceComparisonValue createValue(String key, Set<String> values, Function<String, @NonNull DetailedInstanceComparisonValue> detailedInstanceComparisonCreator) {
        return new NumberInstanceComparisonValue(key, values.size(), ignored -> values.stream().collect(Collectors.toMap(Function.identity(), detailedInstanceComparisonCreator, CollectionUtils.throwingMerger(DetailedInstanceComparisonValue::getHumanReadable), TreeMap::new)));
    }
}

