/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga;

import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.IComparisonContributorContext;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributorBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga.TestGapAnalysisComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga.TgaTrend;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.ITgaRequest;
import com.teamscale.index.testgap.query.TgaPathRequest;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testgap.trend.TgaTrendComputer;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class TestGapAnalysisComparisonContributor
extends ProjectComparisonContributorBase {
    private static final String CONTRIBUTOR_NAME = "Test Gap Analysis";
    static final int RELATIVE_BASELINE_DAYS = 30;

    public TestGapAnalysisComparisonContributor(IComparisonContributorContext.ProjectContext context) {
        super(context);
    }

    @Override
    public TestGapAnalysisComparisonContribution createComparisonInput() throws StorageException {
        CommitDescriptor endCommit = this.resolveEndCommitFromEndTimestamp();
        TestGapAnalysisComparisonContribution.Builder builder = TestGapAnalysisComparisonContribution.builder(((IComparisonContributorContext.ProjectContext)this.context).detailed(), endCommit);
        return builder.addTgaAssessment(this.buildTga(endCommit)).setTgaTrend(this.buildTgaTrend(endCommit)).addExecutionAssessment(this.buildAllTimeExecutions(endCommit)).build(CONTRIBUTOR_NAME, ((IComparisonContributorContext.ProjectContext)this.context).publicProjectId().toString());
    }

    private TgaTrend buildTgaTrend(CommitDescriptor endCommit) throws StorageException {
        long baseline = this.getBaseline();
        TgaTrendComputer tgaTrendComputer = new TgaTrendComputer(((IComparisonContributorContext.ProjectContext)this.context).indexLayer(), (IProjectId)this.getInternalProjectId(), this.getProjectStorageSystem());
        TimeIntervalBasedServiceQueryOptions timeIntervalParameters = new TimeIntervalBasedServiceQueryOptions(new UnresolvedCommitDescriptor(endCommit.getBranchName(), endCommit.getTimestamp()), new UnresolvedCommitDescriptor(endCommit.getBranchName(), baseline));
        TgaRequestQueryOptions requestOptions = new TgaRequestQueryOptions(false, null, false, UniformPath.ofSegments((UniformPath.EType)UniformPath.EType.CODE, (String[])new String[0]), null);
        List<TgaTrendComputer.TgaTrendEntry> tgaTrendEntries = tgaTrendComputer.processTgaTrendRequest(timeIntervalParameters, requestOptions, CoverageSourceQueryParameters.ALL_PARTITIONS, ETgaAssessmentType.TEST_GAP);
        return new TgaTrend(baseline, endCommit, CollectionUtils.map(tgaTrendEntries, TgaTrend.TgaTrendElement::of));
    }

    private AssessedTgaData buildTga(CommitDescriptor endCommit) throws StorageException {
        return this.getTga(ETgaAssessmentType.TEST_GAP, this.getBaseline(), endCommit);
    }

    private long getBaseline() {
        return Instant.ofEpochMilli(((IComparisonContributorContext.ProjectContext)this.context).endTimestamp()).minus(Duration.ofDays(30L)).toEpochMilli();
    }

    private AssessedTgaData buildAllTimeExecutions(CommitDescriptor endCommit) throws StorageException {
        return this.getTga(ETgaAssessmentType.EXECUTION_ONLY, 0L, endCommit);
    }

    private AssessedTgaData getTga(ETgaAssessmentType assessmentType, long baseline, CommitDescriptor endCommit) throws StorageException {
        ITgaRequest tgaRequest = this.buildTgaRequest(assessmentType, baseline, endCommit);
        return tgaRequest.fetchAndAssessData();
    }

    private ITgaRequest buildTgaRequest(ETgaAssessmentType assessmentType, long baseline, CommitDescriptor endCommit) {
        return new TgaPathRequest("", baseline, endCommit, CoverageSourceQueryParameters.ALL_PARTITIONS, assessmentType, (IProjectId)this.getInternalProjectId(), ((IComparisonContributorContext.ProjectContext)this.context).indexLayer());
    }

    private CommitDescriptor resolveEndCommitFromEndTimestamp() throws StorageException {
        HistoryAccessOption historyAccessOption = this.getHistoryAccessOption();
        return UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)new UnresolvedCommitDescriptor(historyAccessOption.getBranchName(), ((IComparisonContributorContext.ProjectContext)this.context).endTimestamp()), () -> ((IComparisonContributorContext.ProjectContext)this.context).indexLayer().openProjectStorageSystem((IProjectId)this.getInternalProjectId()));
    }
}

