/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.util;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryBase;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryExamples;
import com.teamscale.index.admin.instance_comparison.comparison.PredefinedImprovedInstanceComparisonDiffEntry;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.AssessmentInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.CounterSetInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IDetailedInstanceComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.NumberInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.StringInstanceComparisonValue;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.collections.CounterSet;

public final class MetricValueUtils {
    private MetricValueUtils() {
    }

    public static IInstanceComparisonValue getComparisonValueForMetric(String metricName, @Nullable MetricDirectoryEntry entry, int index) {
        if (MetricValueUtils.entryValueNotFound(entry, index)) {
            return new NullInstanceComparisonValue(metricName);
        }
        return MetricValueUtils.getComparisonValueForMetric(metricName, entry.getValue(index));
    }

    public static IInstanceComparisonValue getComparisonValueForMetric(String metricName, @Nullable Object metricValue) {
        if (metricValue == null) {
            return new NullInstanceComparisonValue(metricName);
        }
        if (metricValue instanceof Number) {
            Number numberValue = (Number)metricValue;
            return new NumberInstanceComparisonValue(metricName, numberValue);
        }
        if (metricValue instanceof CounterSet) {
            CounterSet set = (CounterSet)metricValue;
            return new CounterSetInstanceComparisonValue(metricName, set);
        }
        if (metricValue instanceof Assessment) {
            Assessment assessment = (Assessment)metricValue;
            return new AssessmentInstanceComparisonValue(metricName, assessment);
        }
        return new StringInstanceComparisonValue(metricName, String.valueOf(metricValue));
    }

    private static boolean entryValueNotFound(@Nullable MetricDirectoryEntry entry, int index) {
        return entry == null || entry.getValues() == null || index >= entry.getValues().length || entry.getValueWithoutNullAssert(index) == null;
    }

    private record NullInstanceComparisonValue(String metricName) implements IInstanceComparisonValue
    {
        @Override
        public Optional<? extends InstanceComparisonDiffEntryBase<?>> computeDifference(@Nullable IInstanceComparisonValue other, boolean selfIsLocal, InstanceComparisonContributionBase.ComparisonContext context) {
            if (other instanceof NullInstanceComparisonValue || other == null) {
                return Optional.empty();
            }
            if (selfIsLocal) {
                return Optional.of(new PredefinedImprovedInstanceComparisonDiffEntry(this.metricName, "<not found>", other.getValueHumanReadable(), InstanceComparisonDiffEntryExamples.EMPTY, false, false));
            }
            return Optional.of(new PredefinedImprovedInstanceComparisonDiffEntry(this.metricName, other.getValueHumanReadable(), "<not found>", InstanceComparisonDiffEntryExamples.EMPTY, false, false));
        }

        @Override
        public @Nullable IDetailedInstanceComparisonContribution getDetails() {
            return null;
        }

        @Override
        public String getValueHumanReadable() {
            return "<not found>";
        }
    }
}

