/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.ai.findings;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.index.ai.IAiObservabilityMonitor;
import com.teamscale.index.ai.ILlmEngine;
import com.teamscale.index.ai.findings.EAiFindingResolutionPromptGenerator;
import com.teamscale.index.ai.findings.FindingResolutionException;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.string.StringUtils;

public class AiFindingResolutionEngine {
    private static final Pattern LEADING_WHITESPACE_PATTERN = Pattern.compile("^\\s*");
    private static final Pattern MARKDOWN_TICK_START_PATTERN = Pattern.compile("^\\s*```[a-zA-Z]*\\n?");
    private static final Pattern MARKDOWN_TICK_END_PATTERN = Pattern.compile("```\\s*$");
    private static final Pattern TRAILING_SPACES_AND_TABS_PATTERN = Pattern.compile("[ \t]+$", 8);
    private static final Pattern TRAILING_WHITESPACE_PATTERN = Pattern.compile("\\s*$");
    private final @NonNull ILlmEngine llmEngine;
    private final @NonNull EAiFindingResolutionPromptGenerator promptGenerator;
    private final @Nullable IAiObservabilityMonitor observabilityMonitor;

    public AiFindingResolutionEngine(@NonNull ILlmEngine llmEngine, @NonNull EAiFindingResolutionPromptGenerator promptGenerator, @Nullable IAiObservabilityMonitor observabilityMonitor) {
        this.llmEngine = llmEngine;
        this.promptGenerator = promptGenerator;
        this.observabilityMonitor = observabilityMonitor;
    }

    public String suggestResolution(TrackedFinding finding, TokenElementInfo element, FindingTypeDescription findingDescription) throws FindingResolutionException {
        long startTime = System.nanoTime();
        EAiFindingResolutionPromptGenerator.PromptGenerationResult promptResult = this.promptGenerator.generatePrompt(finding, element, findingDescription);
        String prompt = promptResult.prompt();
        this.reportStep("input-prompt", prompt);
        this.reportTime("prompt-generation", startTime);
        String newContent = this.queryLlm(prompt);
        newContent = AiFindingResolutionEngine.removeSurroundingMarkdownTicks(newContent);
        String text = element.getText();
        String oldPartialContent = text.substring(promptResult.replacedTextRangeStartOffset(), promptResult.replacedTextRangeEndOffset());
        newContent = AiFindingResolutionEngine.fixIndentation(text, newContent);
        newContent = AiFindingResolutionEngine.copyLeadingWhitespaceFromOldToNew(oldPartialContent, newContent);
        newContent = TRAILING_SPACES_AND_TABS_PATTERN.matcher(newContent).replaceAll("");
        newContent = AiFindingResolutionEngine.copyTrailingWhitespaceFromOldToNew(oldPartialContent, newContent);
        this.reportTime("overall-resolution", startTime);
        if (newContent.equals(oldPartialContent)) {
            throw new FindingResolutionException("The AI model did not find a resolution for this finding.");
        }
        return text.substring(0, promptResult.replacedTextRangeStartOffset()) + newContent + text.substring(promptResult.replacedTextRangeEndOffset());
    }

    private static String fixIndentation(String text, String newContent) {
        String targetIndentation = AiFindingResolutionEngine.guessIndentation(text);
        String newIndentation = AiFindingResolutionEngine.guessIndentation(newContent);
        if (targetIndentation == null || newIndentation == null) {
            return newContent;
        }
        Matcher matcher = Pattern.compile("(?m)^(" + newIndentation + ")*").matcher(newContent);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            int count = matcher.group().length() / newIndentation.length();
            matcher.appendReplacement(builder, targetIndentation.repeat(count));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    private static String guessIndentation(String text) {
        if (text.contains("\t")) {
            return "\t";
        }
        HashSet<Integer> whitespaceLengths = new HashSet<Integer>();
        for (String line : StringUtils.splitLinesAsList((String)text)) {
            int count;
            for (count = 0; count < line.length() && count <= 8 && line.charAt(count) == ' '; ++count) {
            }
            if (count <= 0 || count % 2 != 0) continue;
            whitespaceLengths.add(count);
        }
        if (whitespaceLengths.isEmpty()) {
            return null;
        }
        return " ".repeat((Integer)Collections.min(whitespaceLengths));
    }

    private String queryLlm(String prompt) throws FindingResolutionException {
        String newContent;
        long startTime = System.nanoTime();
        try {
            newContent = this.llmEngine.answerPrompt(prompt, this.observabilityMonitor);
        }
        catch (ServiceCallException e) {
            throw new FindingResolutionException("Failed to call AI model: " + e.getMessage(), e);
        }
        this.reportTime("llm-answer", startTime);
        this.reportStep("llm-result", newContent);
        if ("FAILED".equals(newContent.trim())) {
            throw new FindingResolutionException("The AI model did not find a resolution for this finding.");
        }
        if ("FALSE_POSITIVE".equals(newContent.trim())) {
            throw new FindingResolutionException("The AI model decided that the finding is a false positive.");
        }
        return newContent;
    }

    private void reportTime(String stepName, long nanoStartTime) {
        if (this.observabilityMonitor != null) {
            long nanos = System.nanoTime() - nanoStartTime;
            double seconds = (double)nanos / 1000.0 / 1000.0 / 1000.0;
            this.observabilityMonitor.reportMetric(stepName + "-seconds", seconds);
        }
    }

    private void reportStep(String stepName, String content) {
        if (this.observabilityMonitor != null) {
            this.observabilityMonitor.reportIntermediateStep(stepName, content);
        }
    }

    private static String removeSurroundingMarkdownTicks(String newMethodContent) {
        Matcher matcher = MARKDOWN_TICK_START_PATTERN.matcher(newMethodContent);
        if (!matcher.find()) {
            return newMethodContent;
        }
        newMethodContent = matcher.replaceFirst("");
        return MARKDOWN_TICK_END_PATTERN.matcher(newMethodContent).replaceFirst("");
    }

    private static String copyLeadingWhitespaceFromOldToNew(String oldMethodContent, String newMethodContent) {
        Matcher matcher = LEADING_WHITESPACE_PATTERN.matcher(oldMethodContent);
        String oldMethodLeadingWhitespace = "";
        if (matcher.find()) {
            oldMethodLeadingWhitespace = matcher.group();
        }
        matcher = LEADING_WHITESPACE_PATTERN.matcher(newMethodContent);
        String newMethodLeadingWhitespace = "";
        if (matcher.find()) {
            newMethodLeadingWhitespace = matcher.group();
        }
        return newMethodContent.replaceAll("(?m)^" + newMethodLeadingWhitespace, oldMethodLeadingWhitespace);
    }

    private static String copyTrailingWhitespaceFromOldToNew(String oldMethodContent, String newMethodContent) {
        Matcher matcher = TRAILING_WHITESPACE_PATTERN.matcher(oldMethodContent);
        String oldMethodTrailingWhitespace = "";
        if (matcher.find()) {
            oldMethodTrailingWhitespace = matcher.group();
        }
        return TRAILING_WHITESPACE_PATTERN.matcher(newMethodContent).replaceFirst(oldMethodTrailingWhitespace);
    }
}

