/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.teamscale.index.architecture.ArchitectureAssessmentInfo;
import com.teamscale.index.architecture.ArchitectureComponentInfo;
import com.teamscale.index.architecture.ArchitectureConstraintInfo;
import com.teamscale.index.architecture.DependencyPolicyInfo;
import com.teamscale.index.architecture.ITypeToFileLookup;
import com.teamscale.index.architecture.TypeDependencyInfo;
import com.teamscale.index.architecture.assessment.shared.TypeDependency;
import com.teamscale.index.architecture.commons.EFindingCreationType;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ArchitectureDefinitionReader;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.architecture.scope.Constraint;
import com.teamscale.index.architecture.scope.DependencyPolicy;
import com.teamscale.index.configuration.ArchitectureAnalysisConfiguration;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class ArchitectureAssessmentInfoUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static ArchitectureAssessmentInfo convertToAssessmentInfo(ArchitectureDefinition annotatedArchitecture, ITypeToFileLookup typeToFileLookup, Set<ELanguage> allLanguagesInProject) {
        ArchitectureAssessmentInfo.Builder builder = ArchitectureAssessmentInfo.builder().withRoot(ArchitectureAssessmentInfoUtils.convertArchitecture(annotatedArchitecture, typeToFileLookup)).withOrphans(annotatedArchitecture.getOrphans()).withFileBased(annotatedArchitecture.isFileBased()).withLegacyCodeMapping(annotatedArchitecture.isLegacyCodeMapping()).withStructureOnly(annotatedArchitecture.isStructureOnly()).withFindingCreation(ArchitectureAssessmentInfoUtils.getFindingCreationType(annotatedArchitecture)).withUnsupportedLanguages(ArchitectureAssessmentInfoUtils.getUnsupportedLanguages(typeToFileLookup, allLanguagesInProject)).withCreationModificationInfo(annotatedArchitecture.getCreationAndModificationInfo());
        if (!annotatedArchitecture.isStructureOnly()) {
            ArchitectureAssessmentInfoUtils.addDependencyPolicies(builder, annotatedArchitecture, typeToFileLookup);
            ArchitectureAssessmentInfoUtils.addConstraintsToArchitecture(builder, annotatedArchitecture);
        }
        return builder.build();
    }

    private static Collection<String> getUnsupportedLanguages(ITypeToFileLookup typeToFileLookup, Set<ELanguage> allLanguagesInProject) {
        return typeToFileLookup.getAllFiles().stream().map(FileSystemUtils::getFileExtension).flatMap(extension -> ELanguage.getAllLanguagesForExtension((String)extension).stream()).filter(allLanguagesInProject::contains).filter(Predicate.not(arg_0 -> ArchitectureAnalysisConfiguration.SUPPORTED_LANGUAGES.contains(arg_0))).distinct().map(ELanguage::getReadableName).toList();
    }

    private static EFindingCreationType getFindingCreationType(ArchitectureDefinition architecture) {
        if (architecture.isStructureOnly()) {
            return EFindingCreationType.NONE;
        }
        return architecture.getFindingCreation();
    }

    private static ArchitectureComponentInfo convertArchitecture(ArchitectureDefinition annotatedArchitecture, ITypeToFileLookup typeToFileLookup) {
        return ArchitectureAssessmentInfoUtils.convertComponent(annotatedArchitecture, annotatedArchitecture, typeToFileLookup);
    }

    private static ArchitectureComponentInfo convertComponent(ComponentNode component, ArchitectureDefinition annotatedArchitecture, ITypeToFileLookup typeToFileLookup) {
        ArchitectureComponentInfo.Builder builder = ArchitectureComponentInfo.builder().withName(component.getName()).withPosition(component.getPosition()).withDimension(component.getDimension()).withMatchedTypes(ArchitectureAssessmentInfoUtils.getMatchedTypes(component, typeToFileLookup)).withStereotype(component.getStereotype()).withRedundantIncludePatterns(annotatedArchitecture.getRedundantIncludePatterns(component)).withNumberOfMatches(annotatedArchitecture.getNumberOfMatches(component));
        if (component.hasSubComponents()) {
            for (ComponentNode child : component.getSubComponents()) {
                builder.withSubComponent(ArchitectureAssessmentInfoUtils.convertComponent(child, annotatedArchitecture, typeToFileLookup));
            }
        }
        return builder.build();
    }

    public static Map<String, String> getMatchedTypes(ComponentNode component, ITypeToFileLookup typeToFileLookup) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String type : component.getMatchedTypes()) {
            result.put(type, ArchitectureAssessmentInfoUtils.getFileForType(type, typeToFileLookup));
        }
        return result;
    }

    private static String getFileForType(String type, ITypeToFileLookup typeToFileLookup) {
        List<String> files = typeToFileLookup.getFilesForType(type);
        if (!files.isEmpty()) {
            return files.getFirst();
        }
        return type;
    }

    private static void addDependencyPolicies(ArchitectureAssessmentInfo.Builder architectureAssessment, ArchitectureDefinition annotatedArchitecture, ITypeToFileLookup typeToFileLookup) {
        for (DependencyPolicy policy : annotatedArchitecture.getSortedPolicies()) {
            String sourceComponent = policy.getSource().getName();
            String targetComponent = policy.getTarget().getName();
            DependencyPolicyInfo.Builder dependencyPolicy = DependencyPolicyInfo.builder().withFrom(sourceComponent).withTo(targetComponent).withPolicyType(policy.getType()).withAssessmentType(policy.getAssessment()).withPoints((Collection<Point>)policy.getPoints());
            Set<TypeDependency> typeDependencies = policy.getTypeDependencies();
            for (TypeDependency typeDependency : typeDependencies) {
                dependencyPolicy.withDependency(ArchitectureAssessmentInfoUtils.createTypeDependencyInfo(typeDependency, typeToFileLookup));
            }
            for (TypeDependency typeDependency : policy.getToleratedDependencies()) {
                dependencyPolicy.withToleratedDependency(ArchitectureAssessmentInfoUtils.createTypeDependencyInfo(typeDependency, typeToFileLookup));
            }
            architectureAssessment.withPolicy(dependencyPolicy.build());
        }
    }

    private static void addConstraintsToArchitecture(ArchitectureAssessmentInfo.Builder architectureAssessmentInfo, ArchitectureDefinition annotatedArchitecture) {
        for (Constraint constraint : annotatedArchitecture.getConstraints()) {
            architectureAssessmentInfo.withConstraint(new ArchitectureConstraintInfo(constraint.getSourcePattern(), constraint.getTargetPattern(), constraint.getViolatingDependencies().size()));
        }
    }

    public static TypeDependencyInfo createTypeDependencyInfo(TypeDependency typeDependency, ITypeToFileLookup typeToFileLookup) {
        return new TypeDependencyInfo(typeDependency.getSource(), typeDependency.getTarget(), ArchitectureAssessmentInfoUtils.getFileForType(typeDependency.getSource(), typeToFileLookup), ArchitectureAssessmentInfoUtils.getFileForType(typeDependency.getTarget(), typeToFileLookup));
    }

    public static List<ArchitectureDefinition> getArchitectureDefinitions(List<String> uniformPaths, TokenElementIndex contentIndex) throws StorageException {
        List<TokenElementInfo> architectureFiles = contentIndex.getTokenElements(uniformPaths);
        ArrayList<ArchitectureDefinition> architectureDefinitions = new ArrayList<ArchitectureDefinition>();
        for (int i = 0; i < architectureFiles.size(); ++i) {
            TokenElementInfo architectureFile = architectureFiles.get(i);
            if (architectureFile == null) {
                architectureDefinitions.add(null);
                continue;
            }
            architectureDefinitions.add(ArchitectureAssessmentInfoUtils.getArchitectureDefinition(architectureFile, uniformPaths.get(i)));
        }
        return architectureDefinitions;
    }

    public static ArchitectureDefinition getArchitectureDefinition(TokenElementInfo element, String uniformPath) {
        try {
            return ArchitectureDefinitionReader.readWithoutValidation(element.getUniformPath(), element.getText());
        }
        catch (ConQATException e) {
            LOGGER.error("Error reading architecture from {}: {}", (Object)uniformPath, (Object)e.toString(), (Object)e);
            return null;
        }
    }
}

