/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.teamscale.index.architecture.ITypeToFileLookup;
import com.teamscale.index.architecture.assessment.shared.TypeDependency;
import com.teamscale.index.architecture.commons.EAssessmentType;
import com.teamscale.index.architecture.commons.EFindingCreationType;
import com.teamscale.index.architecture.commons.EPolicyType;
import com.teamscale.index.architecture.incremental.IArchitectureScopeIndex;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.Constraint;
import com.teamscale.index.architecture.scope.DependencyPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;

public class ArchitectureFindingCreator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DEPENDENCY_VIOLATION_TARGET_FINDING_PROPERTY_KEY = "architecture-dependency-violation-target";
    public static final String DEPENDENCY_VIOLATION_SOURCE_FINDING_PROPERTY_KEY = "architecture-dependency-violation-source";
    public static final String ARCHITECTURE_PROPERTY_KEY = "architecture";
    public static final String FINDING_CATEGORY_NAME = "Architecture Conformance";
    public static final String FINDING_GROUP_NAME = "Architecture violation";
    public static final String FINDING_TYPE_ID = IndexFinding.makeFindingTypeId((String)"Architecture Conformance", (String)"Architecture violation");
    private final ArchitectureDefinition assessedArchitecture;
    private final ITypeToFileLookup typeToFileLookup;
    private final IArchitectureScopeIndex architectureScopeIndex;
    private final Map<TypeDependency, IndexFinding> findingsWithoutSecondaryLocation = new HashMap<TypeDependency, IndexFinding>();

    public ArchitectureFindingCreator(ArchitectureDefinition assessedArchitecture, ITypeToFileLookup typeToFileLookup, IArchitectureScopeIndex architectureScopeIndex) {
        this.assessedArchitecture = assessedArchitecture;
        this.typeToFileLookup = typeToFileLookup;
        this.architectureScopeIndex = architectureScopeIndex;
    }

    public SetMap<String, IndexFinding> createFindings() {
        SetMap findings = new SetMap();
        if (this.assessedArchitecture.getFindingCreation() == EFindingCreationType.NONE) {
            return findings;
        }
        for (DependencyPolicy policy : this.assessedArchitecture.getSortedPolicies()) {
            if (policy.getAssessment() != EAssessmentType.INVALID) continue;
            this.createFindings(policy, (SetMap<String, IndexFinding>)findings);
        }
        this.adoptDependencyLocations();
        this.createFindingsForConstraints((SetMap<String, IndexFinding>)findings);
        return findings;
    }

    private void createFindingsForConstraints(SetMap<String, IndexFinding> findings) {
        for (Constraint constraint : this.assessedArchitecture.getConstraints()) {
            for (TypeDependency violation : constraint.getViolatingDependencies()) {
                this.createConstraintViolationFinding(violation, constraint, findings);
            }
        }
    }

    private void createConstraintViolationFinding(TypeDependency violation, Constraint constraint, SetMap<String, IndexFinding> findings) {
        this.createAndAddFindingForDependency("Type depends on `" + violation.getTarget() + "`. This violates the architecture constraint `" + constraint.toString() + "` in `" + this.assessedArchitecture.getName() + "`", violation, findings, Collections.emptyMap());
    }

    private void createFindings(DependencyPolicy policy, SetMap<String, IndexFinding> findings) {
        Map<String, Object> additionalFindingProperties = Map.of("Source Component", policy.getSource().getName(), "Target Component", policy.getTarget().getName());
        for (TypeDependency dependency : policy.getTypeDependencies()) {
            if (ArchitectureFindingCreator.isToleratedViolation(policy, dependency)) continue;
            String target = dependency.getTarget();
            String architecture = this.assessedArchitecture.getName();
            String message = "Type depends on `" + target + "`. This violates the architecture specification in `" + architecture + "`";
            this.createAndAddFindingForDependency(message, dependency, findings, additionalFindingProperties);
        }
    }

    private void createAndAddFindingForDependency(String message, TypeDependency violatingDependency, SetMap<String, IndexFinding> findings, Map<String, Object> additionalFindingProperties) {
        String source = violatingDependency.getSource();
        if (this.assessedArchitecture.isFileBased()) {
            this.createAndAddFinding(source, message, violatingDependency, findings, additionalFindingProperties);
        } else {
            List<String> files = this.typeToFileLookup.getFilesForType(source);
            for (String file : files) {
                this.createAndAddFinding(file, message, violatingDependency, findings, additionalFindingProperties);
            }
        }
    }

    private void createAndAddFinding(String uniformPath, String message, TypeDependency violatingDependency, SetMap<String, IndexFinding> findings, Map<String, Object> additionalFindingProperties) {
        findings.add((Object)uniformPath, (Object)this.createFinding(message, new ElementLocation(uniformPath), violatingDependency, additionalFindingProperties));
    }

    private IndexFinding createFinding(String message, ElementLocation location, TypeDependency violatingDependency, Map<String, Object> additionalFindingProperties) {
        IndexFinding finding = new IndexFinding(FINDING_GROUP_NAME, FINDING_CATEGORY_NAME, message, location);
        this.setFindingProperties(finding, violatingDependency, additionalFindingProperties);
        this.findingsWithoutSecondaryLocation.put(violatingDependency, finding);
        return finding;
    }

    private void setFindingProperties(IndexFinding finding, TypeDependency violatingDependency, Map<String, Object> additionalFindingProperties) {
        finding.setProperty(DEPENDENCY_VIOLATION_TARGET_FINDING_PROPERTY_KEY, (Object)violatingDependency.getTarget());
        finding.setProperty(DEPENDENCY_VIOLATION_SOURCE_FINDING_PROPERTY_KEY, (Object)violatingDependency.getSource());
        finding.setProperty(ARCHITECTURE_PROPERTY_KEY, (Object)this.assessedArchitecture.getId());
        finding.addProperties(additionalFindingProperties);
    }

    private static boolean isToleratedViolation(DependencyPolicy policy, TypeDependency dependency) {
        return policy.getType() == EPolicyType.TOLERATE_EXPLICIT && policy.getToleratedDependencies().contains(new TypeDependency(dependency.getSource(), dependency.getTarget()));
    }

    private void adoptDependencyLocations() {
        Map<String, ListMap<String, ElementLocation>> locations;
        List<String> filesWithFindings = this.findingsWithoutSecondaryLocation.keySet().stream().map(TypeDependency::getSource).toList();
        try {
            locations = this.architectureScopeIndex.getDependencyLocations(filesWithFindings);
        }
        catch (StorageException e) {
            LOGGER.error("Could not add secondary locations to findings", (Throwable)e);
            return;
        }
        for (Map.Entry<TypeDependency, IndexFinding> entry : this.findingsWithoutSecondaryLocation.entrySet()) {
            String source = entry.getKey().getSource();
            String target = entry.getKey().getTarget();
            for (ElementLocation location : (List)locations.getOrDefault(source, (ListMap<String, ElementLocation>)new ListMap()).getCollectionOrEmpty((Object)target)) {
                entry.getValue().addSecondaryLocation(location);
            }
        }
    }
}

