/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.teamscale.index.architecture.ArchitectureEditorComponentInfo;
import com.teamscale.index.architecture.ArchitectureInfo;
import com.teamscale.index.architecture.assessment.shared.CodeMapping;
import com.teamscale.index.architecture.format.ECodeMappingType;
import jakarta.ws.rs.BadRequestException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ArchitectureInfoUtils {
    public static void validate(ArchitectureInfo architecture) {
        ArchitectureInfoUtils.validateComponents(architecture.getComponents());
    }

    private static void validateComponents(List<ArchitectureEditorComponentInfo> components) {
        for (ArchitectureEditorComponentInfo component : components) {
            ArchitectureInfoUtils.validateComponents(component.getSubComponents());
            ArchitectureInfoUtils.validateCodeMappings(component);
        }
    }

    private static void validateCodeMappings(ArchitectureEditorComponentInfo component) {
        for (CodeMapping mappingData : component.getCodeMappings()) {
            ECodeMappingType codeMappingType = mappingData.getType();
            if (codeMappingType != ECodeMappingType.INCLUDE && codeMappingType != ECodeMappingType.EXCLUDE) continue;
            try {
                Pattern.compile(mappingData.getPattern());
            }
            catch (PatternSyntaxException e) {
                throw new BadRequestException("Code mapping pattern " + mappingData.getPattern() + " of component " + component.getName() + " is invalid!", (Throwable)e);
            }
        }
    }
}

