/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change;

import com.teamscale.core.utils.XXHashUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.jpountz.xxhash.StreamingXXHash64;
import org.conqat.lib.commons.collections.CounterSet;

public class MatchRegionContent
implements Serializable {
    private static final long serialVersionUID = -5235258485811290202L;
    private final transient List<String> tokenTexts = new ArrayList<String>();
    private final transient List<ETokenType> tokenTypes = new ArrayList<ETokenType>();
    private final List<String> filteredTokenTexts = new ArrayList<String>();
    private final CounterSet<Long> statementHashes = new CounterSet();
    protected final ELanguage language;

    protected MatchRegionContent(ELanguage language) {
        this.language = language;
    }

    public MatchRegionContent(List<IToken> tokens, ELanguage language) {
        this(language);
        this.appendTokens(tokens);
    }

    protected void appendTokens(List<IToken> tokens) {
        StreamingXXHash64 hash = XXHashUtils.streamingHash64();
        for (IToken token : tokens) {
            this.tokenTexts.add(token.getText());
            this.tokenTypes.add(token.getType());
            if (token.getType().getTokenClass() == ETokenType.ETokenClass.DELIMITER || tokens.size() <= 2) continue;
            this.filteredTokenTexts.add(token.getText());
            XXHashUtils.updateHash((StreamingXXHash64)hash, (String)token.getType().name());
        }
        this.statementHashes.inc((Object)hash.getValue());
    }

    public CounterSet<Long> getStatementHashes() {
        return this.statementHashes;
    }

    public String calculateContentHash() {
        StreamingXXHash64 hash = XXHashUtils.streamingHash64();
        for (int i = 0; i < this.tokenTexts.size(); ++i) {
            XXHashUtils.updateHash((StreamingXXHash64)hash, (String)this.tokenTexts.get(i));
            XXHashUtils.updateHash((StreamingXXHash64)hash, (String)this.tokenTypes.get(i).name());
        }
        return Long.toHexString(hash.getValue());
    }

    public List<String> getFilteredTokenTexts() {
        return this.filteredTokenTexts;
    }

    public ELanguage getLanguage() {
        return this.language;
    }

    public boolean isTrivial() {
        return false;
    }
}

