/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change;

import com.teamscale.index.code_change.MatchRegion;
import com.teamscale.index.code_change.MatchRegionContent;
import com.teamscale.index.code_change.MatchedRegionWrapper;
import com.teamscale.index.testgap.ExecutedMethodIndex;
import com.teamscale.index.testgap.MethodInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class MethodInfoForRegionCreator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CommitDescriptor commit;

    public MethodInfoForRegionCreator(CommitDescriptor currentCommit) {
        this.commit = currentCommit;
    }

    public MethodInfo createMethodInfoForParents(MatchRegion newRegion, List<MatchedRegionWrapper> oldRegionWrappers) {
        Pair<Long, Long> timestamps = this.computeTimestamps(oldRegionWrappers);
        PairList predecessorCommitsWithKeys = new PairList();
        PairList semanticallyEquivalentPredecessorsIndicesWithLastChangeTimestamp = new PairList();
        HashSet<ExecutedMethodIndex.ExecutedMethodAccessKey> crossAnnotationKeys = new HashSet<ExecutedMethodIndex.ExecutedMethodAccessKey>();
        for (MatchedRegionWrapper oldRegionWrapper : oldRegionWrappers) {
            CommitDescriptor predecessorCommit = oldRegionWrapper.getParentCommit();
            MatchRegion matchedOldRegion = oldRegionWrapper.getOldRegion();
            MethodInfo oldMethodInfo = oldRegionWrapper.getMethodInfo();
            if (matchedOldRegion == null || oldMethodInfo == null) {
                this.addDummyPredecessor((PairList<CommitDescriptor, String>)predecessorCommitsWithKeys);
                continue;
            }
            predecessorCommitsWithKeys.add((Object)predecessorCommit, (Object)MethodInfoForRegionCreator.createPredecessorId(matchedOldRegion));
            if (!oldRegionWrapper.isSemanticallyEquivalentToNewRegion()) continue;
            semanticallyEquivalentPredecessorsIndicesWithLastChangeTimestamp.add((Object)(predecessorCommitsWithKeys.size() - 1), (Object)oldMethodInfo.getLastChangedTimestamp());
            crossAnnotationKeys.addAll(oldMethodInfo.getCrossAnnotationKeys());
            crossAnnotationKeys.add(new ExecutedMethodIndex.ExecutedMethodAccessKey(matchedOldRegion.getUniformPath(), oldMethodInfo));
        }
        if (predecessorCommitsWithKeys.isEmpty()) {
            LOGGER.error("Predecessors should not be empty for {} in commit {} . A dummy predecessor will be created.", (Object)newRegion.getQualifiedId(), (Object)this.commit.toString());
            this.addDummyPredecessor((PairList<CommitDescriptor, String>)predecessorCommitsWithKeys);
        }
        return new MethodInfo(newRegion.getSimpleName(), (Long)timestamps.getFirst(), (Long)timestamps.getSecond(), newRegion.getContentHash(), this.commit, (PairList<CommitDescriptor, String>)predecessorCommitsWithKeys, crossAnnotationKeys, MethodInfoForRegionCreator.isTrivialMethod(newRegion), (PairList<Integer, Long>)semanticallyEquivalentPredecessorsIndicesWithLastChangeTimestamp);
    }

    private static boolean isTrivialMethod(MatchRegion newRegion) {
        MatchRegionContent matchContent = newRegion.getContent();
        if (matchContent != null) {
            return matchContent.isTrivial();
        }
        return false;
    }

    private Pair<Long, Long> computeTimestamps(List<MatchedRegionWrapper> oldRegionWrappers) {
        if (oldRegionWrappers.isEmpty()) {
            return new Pair((Object)this.commit.getTimestamp(), (Object)this.commit.getTimestamp());
        }
        MatchedRegionWrapper firstPredecessorRegion = oldRegionWrappers.get(0);
        MethodInfo oldMethodInfo = firstPredecessorRegion.getMethodInfo();
        if (oldMethodInfo == null) {
            return new Pair((Object)this.commit.getTimestamp(), (Object)this.commit.getTimestamp());
        }
        long lastChangedTimestamp = this.commit.getTimestamp();
        if (firstPredecessorRegion.isSemanticallyEquivalentToNewRegion()) {
            lastChangedTimestamp = oldMethodInfo.getLastChangedTimestamp();
        }
        return new Pair((Object)oldMethodInfo.getCreationTimestamp(), (Object)lastChangedTimestamp);
    }

    private static String createPredecessorId(MatchRegion region) {
        return MethodInfoIndex.makeKeyFromPathAndRegion(region.getUniformPath(), region);
    }

    private void addDummyPredecessor(PairList<CommitDescriptor, String> predecessors) {
        MethodInfo.addDummyPredecessor(this.commit.getBranchName(), predecessors);
    }
}

