/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.code_clones.CloneWiaUtils;
import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.core.CloneClass;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.filesystem.AntPatternUtils;
import org.jetbrains.annotations.Unmodifiable;

public class CloneAnalysisUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CHUNK_LENGTH_PARAMETER = "chunk-length";
    public static final String CLONE_DETECTION_ENABLEMENT_PARAMETER = "clone-detection-enablement";
    public static final String IGNORED_PATTERN_PARAMETER = "ignored-pattern";

    private CloneAnalysisUtils() {
    }

    public static @NonNull PatternList compileUniformPathPatterns(@NonNull List<String> ignoredUniformPathPatterns) {
        PatternList patternList = new PatternList();
        for (String pattern : ignoredUniformPathPatterns) {
            try {
                patternList.add((Object)AntPatternUtils.convertPattern((String)pattern, (boolean)true));
            }
            catch (PatternSyntaxException e) {
                LOGGER.error("Failed to convert Ant pattern '{}'. Skipping this pattern!", (Object)pattern, (Object)e);
            }
        }
        return patternList;
    }

    public static boolean isNonIgnoredElement(@NonNull TokenElementInfo tokenElement, @NonNull CodeScopeAware<Boolean> cloneDetectionEnablement, @NonNull PatternList compiledIgnoredUniformPathPatterns) {
        return CloneAnalysisUtils.isNonIgnoredLanguage(tokenElement.getLanguage()) && CloneAnalysisUtils.isNonIgnoredPath(tokenElement.getUniformPath(), compiledIgnoredUniformPathPatterns) && (Boolean)cloneDetectionEnablement.getValue(CodeScopeDetail.getCodeScopeNameFromTokenElement(tokenElement)) != false;
    }

    public static boolean isNonIgnoredPath(@NonNull String uniformPath, @NonNull PatternList compiledIgnoredUniformPathPatterns) {
        return !compiledIgnoredUniformPathPatterns.findsAnyIn(uniformPath) && !UniformPathUtils.isArchitectureFile((String)uniformPath);
    }

    public static boolean isNonIgnoredLanguage(@Nullable ELanguage language) {
        return language != ELanguage.ABAP_DDIC && !CloneWiaUtils.isUnsupportedWiaLanguage(language);
    }

    public static @NonNull @Unmodifiable Set<String> getCloneUniformPaths(@NonNull Collection<CloneClass> cloneClasses) {
        return cloneClasses.stream().flatMap(cloneClass -> cloneClass.getClones().stream()).map(Clone::getUniformPath).collect(Collectors.toSet());
    }
}

