/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis.utils;

import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.ECommentCategory;
import java.util.regex.Pattern;
import org.conqat.lib.commons.enums.EnumUtils;

public class CommentTaggingUtils {
    private static final Pattern CODE_TAG_PATTERN = Pattern.compile("<code>.*?</code>");
    private static final String SEPARATOR = "\u00a7";
    private static final Pattern TAG_PATTERN = Pattern.compile("\u00a7.*\u00a7");

    public static ECommentCategory getAnnotatedCategory(Comment comment) {
        return CommentTaggingUtils.getCommentCategoryTag(comment.getRawCommentText());
    }

    private static ECommentCategory getCommentCategoryTag(String comment) {
        String[] tags;
        for (String tag : tags = CommentTaggingUtils.getCommentTags(comment).split(",")) {
            ECommentCategory value = (ECommentCategory)EnumUtils.valueOfIgnoreCase(ECommentCategory.class, (String)tag);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static String removeTags(String comment) {
        return TAG_PATTERN.matcher(comment).replaceAll("");
    }

    public static String removeTags(String comment, Pattern tagPattern) {
        return tagPattern.matcher(comment).replaceAll("");
    }

    public static String removeCodeTagsFromComment(String commentText) {
        return CommentTaggingUtils.removeTags(commentText, CODE_TAG_PATTERN);
    }

    private static String getCommentTags(String comment) {
        String[] parts = comment.split(SEPARATOR);
        if (parts.length != 3) {
            return "";
        }
        return parts[1];
    }
}

