/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.audit.analysis.copyrightlicense.CopyrightLicenseIndex;
import com.teamscale.index.audit.analysis.copyrightlicense.CopyrightLicenseIndexUpdater;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.core.configuration.EFeatureToggle;

public class CopyrightLicenseAnalysisConfiguration
extends AnalysisConfigurationBase {
    @ConfigExposed(name="Enable Copyright License Analysis", description="Enable Copyright License Analysis")
    public boolean enabled = false;

    public CopyrightLicenseAnalysisConfiguration() {
        this.autoExpose();
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        if (!this.enabled) {
            return;
        }
        proxy.createProjectIndex(CopyrightLicenseIndex.class);
        TriggerBuilder trigger = new TriggerBuilder(CopyrightLicenseIndexUpdater.class, ETriggerConcurrency.PARALLEL);
        proxy.createTrigger(trigger);
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (EFeatureToggle.AUDIT_FEATURES.isEnabled()) {
            template.registerConfiguration((AnalysisConfigurationBase)this);
            template.registerGlobalOption(this.getOptionForField("enabled"));
        }
    }
}

