/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.index.resource.CppSystemIncludeDirectories;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.preprocessor.c.MacroDefinition;
import eu.cqse.check.framework.preprocessor.c.ParsedMacroProvider;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.string.StringUtils;

public class LanguageAdjustmentConfiguration
extends AnalysisConfigurationBase {
    public static final String PREDEFINED_PREPROCESSOR_MACROS_OPTION_NAME = "Predefined Preprocessor Macros";
    @ConfigExposed(name="Predefined Preprocessor Macros", description="Preprocessor directives that are inserted at the beginning of each file when that file is the main file (i.e., it is not inserted when the file is included somewhere else). This option is typically used to define macros that would be given to the compiler in a normal build step. This field can contain any C code, but we process only preprocessor directives (#define, #undef, #if, #include, ...). Include directives are resolved relative to each source file.", multilineText=true)
    public CodeScopeAware<String> prependDirectivesTextByCodeScope = CodeScopeAware.defaultCodeScopeWithValue((Object)"#define __cplusplus 199711L\n#define __null nullptr\n// Defined in sys/cdefs.h\n#define __dead\n#define __pure\n#define __const\n#define __inline\n#define __unused __attribute__((unused))\n#define\t__used __attribute__((used))\n#define\t__packed __attribute__((packed))\n#define\t__aligned(x) __attribute__((aligned(x)))\n#define assert(x) do { if(!(x)){exit(127);} } while(0)\n\n// empty definitions of non-standard clang macros that can be added in locations where the c++ language spec does not allow extra identifiers.\n#define __nullable\n#define __nonnull\n#define __null_unspecified\n#define __nullable_result\n#define _Nullable\n#define _Nonnull\n#define _Null_unspecified\n#define _Nullable_result\n#define __null nullptr\n\n// definitions for Microsoft C++ CLI\n#define afx_msg\n");
    private static final TokenPattern ASSERT_MACRO_REPLACEMENT_LIST_MATCHER = new TokenPattern().beginningOfStream().sequence(new Object[]{ETokenType.DO, ETokenType.LBRACE, ETokenType.IF, ETokenType.LPAREN, ETokenType.NOT, ETokenType.LPAREN, TokenPattern.text((String)"x"), ETokenType.RPAREN, ETokenType.RPAREN, ETokenType.LBRACE, TokenPattern.text((String)"exit"), ETokenType.LPAREN, TokenPattern.text((String)"127"), ETokenType.RPAREN, ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.RBRACE, ETokenType.WHILE, ETokenType.LPAREN, TokenPattern.text((String)"0"), ETokenType.RPAREN}).endOfStream();
    public static final String SYSTEM_INCLUDE_DIRECTORIES_OPTION_NAME = "System Include Directories";
    @ConfigExposed(name="System Include Directories", description="Include directories for system headers, one per line.", multilineText=true)
    public CodeScopeAware<String> systemIncludeDirectoriesByCodeScope = CodeScopeAware.defaultCodeScopeWithValue((Object)CppSystemIncludeDirectories.DEFAULT_DIRECTORIES);

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.validateCppDefinedDirectives(proxy);
        proxy.addMetaIndexEntry((Serializable)new CppSystemIncludeDirectories(this.systemIncludeDirectoriesByCodeScope));
    }

    public static boolean isTeamscaleAssertMacro(MacroDefinition definition) {
        if (!(definition.isFunctionMacro && definition.macroName.equals("assert") && definition.parameterNames.size() == 1 && ((String)definition.parameterNames.getFirst()).equals("x"))) {
            return false;
        }
        TokenPatternMatch match = ASSERT_MACRO_REPLACEMENT_LIST_MATCHER.matchFully(definition.replacementList);
        return match != null;
    }

    private void validateCppDefinedDirectives(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        for (CodeScope codeScope : proxy.getCodeScopes()) {
            if (!this.prependDirectivesTextByCodeScope.contains(codeScope.getName())) continue;
            String prependDirectivesText = (String)this.prependDirectivesTextByCodeScope.getValue(codeScope.getName());
            if (StringUtils.isEmpty((String)prependDirectivesText)) {
                return;
            }
            @NonNull Set languagesInCurrentCodeScope = (Set)proxy.getConfiguredLanguages().getValue(codeScope.getName());
            if (languagesInCurrentCodeScope.isEmpty()) {
                return;
            }
            ELanguage directivesLanguage = LanguageAdjustmentConfiguration.determineLanguageForDefaultDirectives(languagesInCurrentCodeScope, (PublicProjectId)proxy.getPublicIds().get(0));
            LanguageAdjustmentConfiguration.readDefaultMacroDefines(prependDirectivesText, directivesLanguage);
        }
    }

    private static ELanguage determineLanguageForDefaultDirectives(Set<ELanguage> configuredLanguages, PublicProjectId projectId) throws ProjectConfigurationException {
        if (configuredLanguages.contains(ELanguage.OBJECTIVE_CPP)) {
            return ELanguage.OBJECTIVE_CPP;
        }
        if (configuredLanguages.contains(ELanguage.CPP)) {
            return ELanguage.CPP;
        }
        if (configuredLanguages.contains(ELanguage.CPP_MS_CLI)) {
            return ELanguage.CPP_MS_CLI;
        }
        if (configuredLanguages.contains(ELanguage.C)) {
            return ELanguage.C;
        }
        if (configuredLanguages.contains(ELanguage.OBJECTIVE_C)) {
            return ELanguage.OBJECTIVE_C;
        }
        throw new ProjectConfigurationException("Found default preprocessor directives in AnalysisProfile without C/C++-like language. Project: " + String.valueOf(projectId));
    }

    public static void readDefaultMacroDefines(String prependDirectives, ELanguage directivesLanguage) {
        List directiveTokens = ScannerUtils.getTokens((String)prependDirectives, (ELanguage)directivesLanguage, (String)"default defines (analysis profile)");
        List replacementList = new CPreprocessor(new ParsedMacroProvider(), true, true).computeReplacementsForTranslationUnit("defaultDefines.h", directiveTokens);
        for (PreprocessorTokenReplacement replacement : replacementList) {
            if (replacement.errorMessage == null || ((IToken)directiveTokens.get(replacement.originalTokensStartIndex)).getType() == ETokenType.PREPROCESSOR_INCLUDE) continue;
            LogManager.getLogger().warn("Could not process directive in line " + ((IToken)directiveTokens.get(replacement.originalTokensStartIndex)).getLineNumber() + " (could be caused by an include that is not resolved at this time): " + replacement.errorMessage);
        }
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.autoExpose(template.getCodeScope());
        template.registerConfiguration((AnalysisConfigurationBase)this);
        EnumSet supportedLanguages = CPreprocessingUtils.C_PREPROCESSOR_LANGUAGES;
        if (languages.stream().anyMatch(supportedLanguages::contains)) {
            template.registerGlobalOptionCodeScopeAware(this.getOptionForField("prependDirectivesTextByCodeScope", template.getCodeScope()));
            template.registerGlobalOptionCodeScopeAware(this.getOptionForField("systemIncludeDirectoriesByCodeScope", template.getCodeScope()));
        } else {
            this.prependDirectivesTextByCodeScope.removeValue(template.getCodeScope());
        }
    }
}

