/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.index.findings.abaplint.ABAPLintFindingsSynchronizer;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class ABAPLintConfiguration
extends ToolConfigurationBase {
    private static ABAPLintConfiguration instance;
    public static final String FINDING_CATEGORY = "abaplint";
    private static final String DESCRIPTIONS_PATH = "abaplint";
    public static final String ABAPLINT_MAPPINGS_TSV = "abaplint/check-mappings.tsv";
    public static final String ABAPLINT_OPTIONS_TSV = "abaplint/check-options.tsv";
    public static final String ABAPLINT_CONFIGURATION_DEFAULT_LANGUAGE_OPTION_NAME = "abaplint default language";
    @ConfigExposed(name="abaplint default language", description="The ABAP language version to be used by abaplint. If no value is specified, Teamscale will use the SAP system's ABAP version (when using the Teamscale ABAP Connector) or default to v740sp08 (for abapGit repositories).")
    public String defaultLanguage = "";

    public ABAPLintConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.ABAPLINT, "abaplint", "abaplint", ABAPLINT_MAPPINGS_TSV, ABAPLINT_OPTIONS_TSV, "");
        this.autoExpose();
    }

    public static synchronized ABAPLintConfiguration getInstance() throws ProjectConfigurationException {
        if (instance == null) {
            instance = new ABAPLintConfiguration();
        }
        return instance;
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        List selectedChecks = this.getActiveFindingGroupNames(CodeScopeAware.DEFAULT_CODE_SCOPE);
        if (selectedChecks.isEmpty()) {
            return;
        }
        TriggerBuilder triggerBuilder = new TriggerBuilder(ABAPLintFindingsSynchronizer.class, ETriggerConcurrency.PARALLEL);
        triggerBuilder.setCost(ETriggerCost.EXPENSIVE);
        triggerBuilder.setTriggerParameter("default-language", this.defaultLanguage);
        triggerBuilder.setTriggerParameter("checks", ITriggerParameter.of((Object)selectedChecks));
        ArrayList<String> selectedOptions = new ArrayList<String>();
        ArrayList<String> checkOptionTypes = new ArrayList<String>();
        ArrayList<String> checkOptionValues = new ArrayList<String>();
        for (String check : selectedChecks) {
            UnmodifiableSet options = ((FindingDescriptor)((Map)this.findingDescriptorsByFindingGroup.getValue(CodeScopeAware.DEFAULT_CODE_SCOPE)).get(check)).getReferencedOptions();
            for (ConfigOptionDescriptorBase option : options) {
                selectedOptions.add(option.getName());
                checkOptionTypes.add(option.getType());
                checkOptionValues.add(option.retrieveValueAsString(CodeScopeAware.DEFAULT_CODE_SCOPE));
            }
        }
        triggerBuilder.setTriggerParameter("check-options", ITriggerParameter.of(selectedOptions));
        triggerBuilder.setTriggerParameter("check-option-types", ITriggerParameter.of(checkOptionTypes));
        triggerBuilder.setTriggerParameter("check-option-values", ITriggerParameter.of(checkOptionValues));
        proxy.createTrigger(triggerBuilder);
        super.configureProject(proxy);
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        super.registerQualityIndicators(template, languages, tools);
        template.registerConfiguration((AnalysisConfigurationBase)this);
        if (tools.contains(EAnalysisTool.ABAPLINT) && languages.contains(ELanguage.ABAP)) {
            template.registerGlobalOption(this.getOptionForField("defaultLanguage"));
        }
    }
}

