/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.google.common.collect.Multimap;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.comment_analysis.identifier.CompoundBreaker;
import com.teamscale.index.findings.clangtidy.ClangTidySynchronizer;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.teamscale_server.ClangTidyOutsourcedAnalysisPull;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.teamscale_server.ClangTidyOutsourcedAnalysisPush;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.teamscale_server.ClangTidyOutsourcedAnalysisSessionsIndex;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class ClangTidyConfiguration
extends ToolConfigurationBase {
    public static final String FINDING_CATEGORY = "clang-tidy";
    public static final String CLANG_TIDY_MAPPINGS_TSV = "clang-tidy/check-mappings.tsv";
    public static final String CLANG_TIDY_CHECK_OPTIONS_TSV = "clang-tidy/check-options.tsv";
    public static final String EXPECTED_VERSION_FILE = "clang-tidy/version.txt";
    public static final String DESCRIPTIONS_DIRECTORY = "clang-tidy";
    public static final String DEFAULT_ENABLED_CHECKS_FOR_C_REGEX = ".*";
    private static final String CLANG_ANALYZER_CHECK_ID_PREFIX = "clang-analyzer-";
    private final Map<String, CheckMapping> configuredChecks;
    @ConfigExposed(name="Clang-Tidy: Enabled Checks for C", description="Regex filter for clang-tidy check names that can be run on C code (all checks are executed for C++ code). Checks are executed if the corresponding rule is selected in the analysis profile.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    public CodeScopeAware<String> enabledChecksForCRegex = CodeScopeAware.defaultCodeScopeWithValue((Object)".*");
    private final Multimap<String, ToolCheckOption> toolCheckOptions;
    private final Map<String, String> initialGroupToCategoryMap = new HashMap<String, String>();

    public ClangTidyConfiguration() {
        super(EAnalysisTool.CLANG_TIDY, "clang-tidy");
        this.toolCheckOptions = this.readOptions(CLANG_TIDY_CHECK_OPTIONS_TSV);
        Map<String, CheckMapping> configuredChecks = ClangTidyConfiguration.loadCheckMappings();
        configuredChecks.entrySet().removeIf(entry -> ((CheckMapping)entry.getValue()).defaultEnablement == null);
        this.initialGroupToCategoryMap.putAll(ClangTidyConfiguration.buildGroupToCategoryMap(configuredChecks));
        this.configuredChecks = configuredChecks;
        this.declareCodeScopeAware();
    }

    private void registerFindingDescriptorAndConfigOptions(String checkId, CheckMapping checkMapping, EFindingEnablement enablement, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        String readableCheckName = checkMapping.getReadableCheckName();
        Map<String, String> descriptions = ClangTidyMessageParser.loadCheckAndOptionDescriptions(checkId);
        String group = this.getGroup(checkMapping.group);
        String optionPrefix = checkId + ".";
        Collection options = this.toolCheckOptions.get((Object)checkId);
        for (ToolCheckOption toolCheckOption : options) {
            String optionName = toolCheckOption.optionId;
            String simpleName = optionName.substring(optionPrefix.length());
            String readableOptionName = StringUtils.concat(CompoundBreaker.breakCompound(simpleName, false), (String)" ");
            String optionDescription = descriptions.getOrDefault(optionName, "");
            toolCheckOption.setDescription(optionDescription);
            toolCheckOption.setReadableName(readableCheckName + ": " + readableOptionName);
        }
        String description = descriptions.getOrDefault(checkId, "");
        if (StringUtils.isEmpty((String)description)) {
            LogManager.getLogger().debug("Empty description for check " + checkId);
        }
        this.createFindingType(checkId, readableCheckName, description, group, enablement, checkMapping.autoAllowed, options, codeScopeName);
    }

    private static Map<String, String> buildGroupToCategoryMap(Map<String, CheckMapping> configuredChecks) {
        HashMap<String, String> groupToCategoryMap = new HashMap<String, String>();
        for (CheckMapping checkMapping : configuredChecks.values()) {
            String group = checkMapping.group;
            String category = checkMapping.category;
            CheckMappingAndCheckOptionTSVUtils.validateGroupToCategoryMapping((String)group, (String)category, groupToCategoryMap);
            groupToCategoryMap.put(group, category);
        }
        return groupToCategoryMap;
    }

    @VisibleForTesting
    public static Map<String, CheckMapping> loadCheckMappings() {
        Resource mappingsFile = Resource.of(ClangTidyConfiguration.class, (String)CLANG_TIDY_MAPPINGS_TSV);
        return CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)mappingsFile);
    }

    public Set<ELanguage> determineLanguages(String checkName) {
        return ClangTidyConfiguration.determineCheckLanguages(checkName);
    }

    public static Set<ELanguage> determineCheckLanguages(String checkName) {
        if (checkName.toLowerCase().contains("objc")) {
            return LanguageGroups.OBJECTIVE_C_AND_OBJECTIVE_CPP;
        }
        return LanguageGroups.C_AND_DERIVATIVES;
    }

    public static String buildPathToCheckDescriptionFile(String checkName) {
        return "clang-tidy/" + ClangTidyConfiguration.getRelativeDescriptionsFilePath(checkName);
    }

    private static String getRelativeDescriptionsFilePath(String checkName) {
        String filePath = checkName.startsWith(CLANG_ANALYZER_CHECK_ID_PREFIX) ? "clang-analyzer/" + StringUtils.stripPrefix((String)checkName, (String)CLANG_ANALYZER_CHECK_ID_PREFIX) : checkName.substring(0, checkName.indexOf(45)) + "/" + checkName.substring(checkName.indexOf(45) + 1);
        filePath = filePath + ".rst";
        return filePath;
    }

    protected String determineQualityIndicator(String groupName, CodeScopeName codeScopeName) {
        return this.initialGroupToCategoryMap.getOrDefault(groupName, "Uncategorized Clang-Tidy Checks");
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware activeChecksPerCodeScope = this.getActiveCheckPerCodeScope(proxy.getCodeScopeNames());
        if (activeChecksPerCodeScope == null) {
            return;
        }
        this.createTriggers(proxy, (CodeScopeAware<Collection<String>>)activeChecksPerCodeScope);
        super.configureProject(proxy);
    }

    private void createTriggers(ProjectCreationProxy proxy, CodeScopeAware<Collection<String>> activeChecksPerCodeScope) throws ProjectConfigurationException {
        if (EFeatureToggle.ENABLE_OUTSOURCED_CLANG_TIDY_ANALYSIS.isEnabled()) {
            this.createClangTidyOutsourcedAnalysisSteps(proxy, activeChecksPerCodeScope);
        } else {
            this.createClangTidyAnalysisStep(proxy, activeChecksPerCodeScope);
        }
    }

    private void createClangTidyOutsourcedAnalysisSteps(ProjectCreationProxy proxy, CodeScopeAware<Collection<String>> activeChecksPerCodeScope) throws ProjectConfigurationException {
        proxy.createProjectIndex(ClangTidyOutsourcedAnalysisSessionsIndex.class);
        TriggerBuilder triggerBuilder = new TriggerBuilder(ClangTidyOutsourcedAnalysisPush.class, ETriggerConcurrency.PARALLEL);
        this.addClangTidyAnalysisParameters(activeChecksPerCodeScope, triggerBuilder);
        proxy.createTrigger(triggerBuilder);
        proxy.createTrigger(new TriggerBuilder(ClangTidyOutsourcedAnalysisPull.class, ETriggerConcurrency.PARALLEL));
    }

    private void createClangTidyAnalysisStep(ProjectCreationProxy proxy, CodeScopeAware<Collection<String>> selectedChecks) throws ProjectConfigurationException {
        TriggerBuilder trigger = new TriggerBuilder(ClangTidySynchronizer.class, ETriggerConcurrency.PARALLEL);
        this.addClangTidyAnalysisParameters(selectedChecks, trigger);
        proxy.createTrigger(trigger);
    }

    private void addClangTidyAnalysisParameters(CodeScopeAware<Collection<String>> activeChecksPerCodeScope, TriggerBuilder trigger) {
        trigger.setTriggerParameter("checks", activeChecksPerCodeScope);
        trigger.setTriggerParameter("enabled-checks-for-c-regex", this.enabledChecksForCRegex);
        CodeScopeAware checkOptionsPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : this.valueByOptionsId.getCodeScopeNames()) {
            PairList optionValuesInCurrentCodeScope = new PairList();
            for (Map.Entry entry : ((Map)this.valueByOptionsId.getValue(codeScopeName)).entrySet()) {
                Object optionValue = entry.getValue();
                if (optionValue == null || StringUtils.isEmpty((String)String.valueOf(optionValue))) continue;
                String optionName = StringUtils.getLastPart((String)((String)entry.getKey()), (String)"#");
                optionValuesInCurrentCodeScope.add((Object)optionName, (Object)String.valueOf(optionValue));
            }
            checkOptionsPerCodeScope.setValue(codeScopeName, (Object)optionValuesInCurrentCodeScope);
        }
        trigger.setTriggerParameter("check-options", (ITriggerParameter)checkOptionsPerCodeScope);
    }

    public void validateTools() throws ProjectConfigurationException {
        try {
            ClangTidySynchronizer.verifyClangTidyVersion();
        }
        catch (ConQATException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.autoExpose(template.getCodeScope());
        if (!tools.contains(EAnalysisTool.CLANG_TIDY)) {
            return;
        }
        template.registerConfiguration((AnalysisConfigurationBase)this);
        template.registerGlobalOptionCodeScopeAware(this.getOptionForField("enabledChecksForCRegex", template.getCodeScope()));
        for (Map.Entry<String, CheckMapping> entry : this.configuredChecks.entrySet()) {
            CheckMapping checkMapping = entry.getValue();
            EFindingEnablement enablement = checkMapping.defaultEnablement;
            this.registerFindingDescriptorAndConfigOptions(entry.getKey(), checkMapping, enablement, template.getCodeScope());
        }
        super.registerQualityIndicators(template, languages, tools);
    }

    @VisibleForTesting
    static class ClangTidyMessageParser {
        private static final Pattern DESCRIPTION_REMOVE_HEADING_PATTERN = Pattern.compile("(?s)^.*?====+");
        private static final Pattern DESCRIPTION_REMOVE_REDIRECT_TARGET_PATTERN = Pattern.compile("`[^`]*`\\s+redirects\\s+here\\s+as\\s+an\\s+alias\\s+for\\s+this\\s+check.\\s*");
        private static final Pattern DESCRIPTION_OPTIONS_SECTION_PATTERN = Pattern.compile("(?s)\n(Options?\\s*|.. option::.*?)\n.*$");
        private static final Pattern DESCRIPTION_MATCH_CODE_BLOCKS_PATTERN = Pattern.compile("(?s)\n\\.\\. code-block::.*?\n+(.*?)\r?\n(?=(\\r?\\n\\S|$))");
        private static final Pattern DESCRIPTION_MATCH_PRE_BLOCKS_PATTERN = Pattern.compile("(?s)\n\\.\\. code::\n+(.*?)\r?\n(?=(\\r?\\n\\S|$))");
        private static final Pattern DESCRIPTION_MATCH_PRE_CPP_BLOCKS_PATTERN = Pattern.compile("(?s)\n\\.\\. code:: c\\+{0,2}\n+(.*?)\r?\n(?=(\\r?\\n\\S|$))");
        private static final Pattern DESCRIPTION_MATCH_ALIAS_REDIRECTION_PATTERN = Pattern.compile("^\\s*(?:The\\s+\\S+\\s+check\\s+is\\s+an\\s+alias,\\s*please\\s+see\\s+`(?:Clang Static Analyzer Available Checkers \\<https:\\/\\/clang\\.llvm\\.org\\/docs\\/analyzer\\/checkers\\.html#)?|This\\s+check\\s+is\\s+an\\s+alias\\s+for\\s+`)([^ `\\>]+)");
        private static final Pattern DESCRIPTION_MATCH_LINKS_PATTERN = Pattern.compile("(?s)`([^`<]+)\\s*<([^<>`]*?)>`_");
        private static final Pattern DESCRIPTION_SINGLE_OPTION_PATTERN = Pattern.compile("(?s).. option::\\s*(\\S+)\\s*\n(.*?)(?=.. option|$)");

        ClangTidyMessageParser() {
        }

        @VisibleForTesting
        static Map<String, String> loadCheckAndOptionDescriptions(String checkName) {
            return ClangTidyMessageParser.loadCheckAndOptionDescriptions(checkName, checkName);
        }

        private static Map<String, String> loadCheckAndOptionDescriptions(String checkNameForLoading, String checkNameForResultMap) {
            Matcher aliasRedirectionMatcher;
            Optional descriptionFileContent = CheckDescriptionLoader.getCheckDescription(ClangTidyConfiguration.class, (String)ClangTidyConfiguration.buildPathToCheckDescriptionFile(checkNameForLoading));
            if (descriptionFileContent.isEmpty()) {
                return Collections.emptyMap();
            }
            String description = (String)descriptionFileContent.get();
            String optionsPart = "";
            Matcher optionsSectionMatcher = DESCRIPTION_OPTIONS_SECTION_PATTERN.matcher(description);
            if (optionsSectionMatcher.find()) {
                optionsPart = optionsSectionMatcher.group();
                description = optionsSectionMatcher.replaceFirst("");
            }
            if ((aliasRedirectionMatcher = DESCRIPTION_MATCH_ALIAS_REDIRECTION_PATTERN.matcher(description = DESCRIPTION_REMOVE_HEADING_PATTERN.matcher(description).replaceFirst(""))).find()) {
                return ClangTidyMessageParser.loadCheckAndOptionDescriptions(aliasRedirectionMatcher.group(1).trim(), checkNameForResultMap);
            }
            description = DESCRIPTION_REMOVE_REDIRECT_TARGET_PATTERN.matcher(description).replaceAll("");
            description = DESCRIPTION_MATCH_CODE_BLOCKS_PATTERN.matcher(description).replaceAll("\n``` cpp\n$1\n```\n");
            description = DESCRIPTION_MATCH_PRE_CPP_BLOCKS_PATTERN.matcher(description).replaceAll("\n``` cpp\n$1\n```\n");
            description = DESCRIPTION_MATCH_PRE_BLOCKS_PATTERN.matcher(description).replaceAll("\n``` line\n$1\n```\n");
            description = DESCRIPTION_MATCH_LINKS_PATTERN.matcher(description).replaceAll("[$1]($2)");
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(checkNameForResultMap, description.trim());
            Matcher optionsMatcher = DESCRIPTION_SINGLE_OPTION_PATTERN.matcher(optionsPart);
            while (optionsMatcher.find()) {
                result.put(checkNameForResultMap + "." + optionsMatcher.group(1), optionsMatcher.group(2).trim());
            }
            return result;
        }
    }
}

