/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.findings.cppcheck.CppcheckRunner;
import com.teamscale.index.findings.cppcheck.CppcheckSynchronizer;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.resources.Resource;

public abstract class CppcheckConfigurationBase
extends ToolConfigurationBase {
    public static final String FINDING_CATEGORY = "cppcheck";
    private final Map<String, String> groupToCategory = new HashMap<String, String>();
    private final Map<String, CheckMapping> configuredChecks;
    private Map<String, String> checkDescriptions = new HashMap<String, String>();

    protected abstract String getCppCheckMappingsFile();

    protected abstract EAnalysisTool getAnalysisTool();

    protected abstract CodeScopeAware<String> getEnabledChecksForCRegex();

    protected abstract Set<ELanguage> getSupportedLanguageForCheck(String var1);

    protected CppcheckConfigurationBase(EAnalysisTool analysisTool) {
        super(analysisTool, FINDING_CATEGORY);
        if (CppcheckRunner.cppCheckIsAvailable()) {
            this.checkDescriptions = CppcheckRunner.getCheckDescriptions();
        }
        Map<String, CheckMapping> configuredChecks = this.loadCheckMappings();
        configuredChecks.entrySet().removeIf(entry -> ((CheckMapping)entry.getValue()).defaultEnablement == null);
        this.initializeGroupToCategoryMap(configuredChecks);
        this.configuredChecks = configuredChecks;
    }

    private void initializeGroupToCategoryMap(Map<String, CheckMapping> configuredChecks) {
        for (CheckMapping checkMapping : configuredChecks.values()) {
            String group = checkMapping.group;
            String category = checkMapping.category;
            CheckMappingAndCheckOptionTSVUtils.validateGroupToCategoryMapping((String)group, (String)category, this.groupToCategory);
            this.groupToCategory.put(group, category);
        }
    }

    private void logMissingCheckMapping(String checkId) {
        LogManager.getLogger().error("Ignoring Cppcheck check {} due to missing mapping in {}. Mappings file should be updated. Please inform q-model guild.", (Object)checkId, (Object)this.getCppCheckMappingsFile());
    }

    private Map<String, CheckMapping> loadCheckMappings() {
        Resource mappingsFile = Resource.of(CppcheckSynchronizer.class, (String)this.getCppCheckMappingsFile());
        return CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)mappingsFile);
    }

    public List<String> loadAvailableCheckIds() {
        Map<String, CheckMapping> configuredChecks = this.loadCheckMappings();
        return new ArrayList<String>(configuredChecks.keySet());
    }

    protected String determineQualityIndicator(String groupName, CodeScopeName codeScopeName) {
        return this.groupToCategory.getOrDefault(groupName, "Uncategorized Cppcheck Checks");
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware activeChecksPerCodeScope = this.getActiveCheckPerCodeScope(proxy.getCodeScopeNames());
        if (activeChecksPerCodeScope == null) {
            return;
        }
        this.createTriggers(proxy, (CodeScopeAware<Collection<String>>)activeChecksPerCodeScope);
        super.configureProject(proxy);
    }

    private void createTriggers(ProjectCreationProxy proxy, CodeScopeAware<Collection<String>> activeChecksPerCodeScope) throws ProjectConfigurationException {
        TriggerBuilder trigger = new TriggerBuilder(CppcheckSynchronizer.class, ETriggerConcurrency.PARALLEL);
        trigger.setTriggerParameter("checks", activeChecksPerCodeScope);
        trigger.setTriggerParameter("enabled-checks-for-c-regex", this.getEnabledChecksForCRegex());
        proxy.createTrigger(trigger);
    }

    public void validateTools() throws ProjectConfigurationException {
        try {
            CppcheckSynchronizer.verifyCppcheckVersion(this.isPremiumCppcheck());
        }
        catch (ConQATException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.autoExpose(template.getCodeScope());
        if (!tools.contains(this.getAnalysisTool())) {
            return;
        }
        template.registerConfiguration((AnalysisConfigurationBase)this);
        template.registerGlobalOptionCodeScopeAware(this.getOptionForField("enabledChecksForCRegex", template.getCodeScope()));
        for (Map.Entry<String, CheckMapping> entry : this.configuredChecks.entrySet()) {
            CheckMapping checkMapping = entry.getValue();
            EFindingEnablement enablement = checkMapping.defaultEnablement;
            this.registerFindingDescriptorAndConfigOptions(entry.getKey(), checkMapping, enablement, template.getCodeScope());
        }
        super.registerQualityIndicators(template, languages, tools);
    }

    private void registerFindingDescriptorAndConfigOptions(String checkId, CheckMapping checkMapping, EFindingEnablement enablement, CodeScopeName codeScopeName) {
        String readableCheckName = checkMapping.getReadableCheckName();
        FindingDescriptor finding = this.createFindingsDescriptor(checkId, readableCheckName, enablement, this.checkDescriptions.getOrDefault(checkId, "No description provided for check " + checkId + " by the cppcheck executable."));
        String group = this.getGroup(checkMapping.group);
        this.registerFinding(finding, group, checkId, codeScopeName);
    }

    private boolean isPremiumCppcheck() {
        return this.getAnalysisTool() == EAnalysisTool.CPPCHECK_PREMIUM;
    }

    private FindingDescriptor createFindingsDescriptor(String checkId, String readableCheckName, EFindingEnablement enablement, String description) {
        return new FindingDescriptor(checkId, readableCheckName, this.tool, this.getSupportedLanguageForCheck(checkId), enablement, description);
    }
}

