/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dashboard;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.index.dashboard.DashboardDescriptor;
import com.teamscale.index.dashboard.DashboardIndex;
import com.teamscale.index.dashboard.ProjectDashboardsMappingIndex;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class DashboardUtils {
    public static final String DASHBOARD_DESCRIPTOR = "dashboard descriptor";

    public static Set<PublicProjectId> extractProjectIdsFromDashboard(JsonNode descriptor) {
        HashSet<PublicProjectId> projectIds = new HashSet<PublicProjectId>();
        for (JsonNode widget : descriptor.get("widgets")) {
            JsonUtils.getWithCapitalizedOrLowercaseKey((JsonNode)widget, (String)"path").flatMap(pathParameterValue -> DashboardUtils.convertToProjectId(pathParameterValue.get("project"))).ifPresent(projectIds::add);
            JsonUtils.getWithCapitalizedOrLowercaseKey((JsonNode)widget, (String)"Additional paths").ifPresent(pathListParameterValue -> projectIds.addAll(DashboardUtils.extractProjectNamesFromPathList(pathListParameterValue)));
            JsonUtils.getWithCapitalizedOrLowercaseKey((JsonNode)widget, (String)"Project").flatMap(DashboardUtils::convertToProjectId).ifPresent(projectIds::add);
            projectIds.addAll(DashboardUtils.extractProjectNamesFromPathList(widget.get("Stored Test Queries")));
        }
        return projectIds;
    }

    private static Set<PublicProjectId> extractProjectNamesFromPathList(JsonNode pathListParameterValue) {
        HashSet<PublicProjectId> projectIds = new HashSet<PublicProjectId>();
        if (pathListParameterValue != null) {
            for (JsonNode path : pathListParameterValue) {
                JsonUtils.getWithCapitalizedOrLowercaseKey((JsonNode)path, (String)"project").flatMap(DashboardUtils::convertToProjectId).ifPresent(projectIds::add);
            }
        }
        return projectIds;
    }

    private static Optional<PublicProjectId> convertToProjectId(JsonNode projectId) {
        if (projectId == null) {
            return Optional.empty();
        }
        if (projectId.isNull()) {
            return Optional.empty();
        }
        String projectIdAsText = projectId.asText();
        if (StringUtils.isEmpty((String)projectIdAsText)) {
            return Optional.empty();
        }
        return Optional.of(new PublicProjectId(projectIdAsText));
    }

    public static synchronized void storeDashboardInIndexes(DashboardDescriptor descriptor, DashboardIndex dashboardIndex, ProjectDashboardsMappingIndex projectDashboardsMappingIndex, DashboardDescriptor oldDashboard) throws StorageException {
        if (oldDashboard != null) {
            Set<PublicProjectId> projectsReferencedInOldDashboard = DashboardUtils.extractProjectIdsFromDashboard(oldDashboard.getDescriptor());
            projectDashboardsMappingIndex.removeMappings(descriptor.getId(), projectsReferencedInOldDashboard);
        }
        dashboardIndex.storeDashboard(descriptor);
        Set<PublicProjectId> projectsReferencedInNewDashboard = DashboardUtils.extractProjectIdsFromDashboard(descriptor.getDescriptor());
        projectDashboardsMappingIndex.addProjectDashboardMappings(descriptor.getId(), projectsReferencedInNewDashboard);
    }

    public static synchronized void removeDashboardFromIndexes(UUID dashboardId, DashboardIndex dashboardIndex, ProjectDashboardsMappingIndex projectDashboardMappingIndex) throws StorageException {
        dashboardIndex.removeDashboard(dashboardId);
        projectDashboardMappingIndex.removeMappingsForDashboard(dashboardId);
    }
}

