/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.abap;

import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataflowHeuristicBase;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.AbapShallowEntityMatcher;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.rules.AbapAtRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.rules.DoRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.rules.FunctionLikeRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.rules.LoopRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.rules.OnChangeRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.rules.SimpleAndChainStatementRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.AnonymousBlockRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.BreakRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.CaseLabelRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.ContinueRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IfWithoutParenthesesRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IgnoreRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.ReturnRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.SwitchWithoutParenthesesRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.TryCatchFinallyRule;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.IShallowEntityMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityOrMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityTypeMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class AbapDataFlowHeuristic
extends DataflowHeuristicBase {
    private static final String INIT_METHOD_SUFFIX = "_init_";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final PairList<IShallowEntityMatcher, IControlFlowRule> RULES = new PairList();
    private static final Set<String> START_OF_SELECTION_PARENTS;

    @Override
    protected PairList<IShallowEntityMatcher, IControlFlowRule> getRules() {
        return RULES;
    }

    @Override
    public PairList<String, List<ShallowEntity>> extractExecutables(String uniformPath, List<ShallowEntity> entities) {
        PairList<String, List<ShallowEntity>> executables = new PairList<String, List<ShallowEntity>>(this.extractExecutablesMap(uniformPath, entities, false));
        executables = AbapDataFlowHeuristic.removeEmbeddedCode(executables);
        executables.sort((Comparator)new ExecutableComparator());
        return executables;
    }

    private static PairList<String, List<ShallowEntity>> removeEmbeddedCode(PairList<String, List<ShallowEntity>> executables) {
        PairList executablesWithoutEmbeddedCode = new PairList();
        for (Pair executable : executables) {
            if (((List)executable.getSecond()).isEmpty()) continue;
            ShallowEntity methodHead = (ShallowEntity)((List)executable.getSecond()).get(0);
            UnmodifiableList tokens = methodHead.ownStartTokens();
            if (TokenStreamUtils.containsSequence((List)tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.BY, ETokenType.DATABASE, ETokenType.PROCEDURE})) continue;
            executablesWithoutEmbeddedCode.add((Object)((String)executable.getFirst()), (Object)((List)executable.getSecond()));
        }
        return executablesWithoutEmbeddedCode;
    }

    private static boolean isStartOfSelectionOrInit(String method) {
        return method.endsWith(".start-of-selection") || method.endsWith(".START-OF-SELECTION") || method.endsWith("._init_");
    }

    private static Pair<String, String> splitContainerAndMethodName(String methodIdentifier) {
        int delimiterindex = methodIdentifier.lastIndexOf(".");
        if (delimiterindex <= 0) {
            return new Pair((Object)"", (Object)methodIdentifier);
        }
        String containerName = methodIdentifier.substring(0, delimiterindex);
        String methodName = methodIdentifier.substring(delimiterindex);
        return new Pair((Object)containerName, (Object)methodName);
    }

    private Map<String, List<ShallowEntity>> extractExecutablesMap(String uniformPath, List<ShallowEntity> entities, boolean includeAttributes) {
        HashMap<String, List<ShallowEntity>> executables = new HashMap<String, List<ShallowEntity>>();
        for (ShallowEntity entity : entities) {
            switch (entity.getType()) {
                case ATTRIBUTE: {
                    if (!includeAttributes || entity.getParent() == null || entity.getParent().getType() != EShallowEntityType.TYPE) break;
                    this.addStartOfSelectionExecutableForAttribute(uniformPath, executables, entity);
                    break;
                }
                case METHOD: {
                    this.addExecutableIfMethodImplementation(uniformPath, executables, entity);
                    break;
                }
                case TYPE: {
                    this.descendRecursivelyAndMergeResults(uniformPath, executables, entity);
                    break;
                }
            }
        }
        return executables;
    }

    private void addStartOfSelectionExecutableForAttribute(String uniformPath, Map<String, List<ShallowEntity>> executables, ShallowEntity entity) {
        if (entity.getType() == EShallowEntityType.ATTRIBUTE) {
            this.putInExecutables(uniformPath, executables, entity);
        }
    }

    private void putInExecutables(String uniformPath, Map<String, List<ShallowEntity>> executables, ShallowEntity entity) {
        String executableName = this.getExecutableName(entity);
        if (executableName == null) {
            LOGGER.debug("could not get name for " + String.valueOf(entity.getType()) + " in uniform path " + uniformPath);
            return;
        }
        executables.putIfAbsent(executableName, new ArrayList());
        executables.get(executableName).add(entity);
    }

    private void descendRecursivelyAndMergeResults(String uniformPath, Map<String, List<ShallowEntity>> executables, ShallowEntity entity) {
        BiFunction<List, List, List> mergeEntityLists = (entities1, entities2) -> {
            entities1.addAll(entities2);
            return entities1;
        };
        Map<String, List<ShallowEntity>> childExecutables = this.extractExecutablesMap(uniformPath, (List<ShallowEntity>)entity.getChildren(), true);
        for (Map.Entry<String, List<ShallowEntity>> childEntries : childExecutables.entrySet()) {
            executables.merge(childEntries.getKey(), childEntries.getValue(), mergeEntityLists);
        }
    }

    private void addExecutableIfMethodImplementation(String uniformPath, Map<String, List<ShallowEntity>> executables, ShallowEntity entity) {
        if (entity.getSubtype().equals("method declaration")) {
            return;
        }
        if (entity.getType() == EShallowEntityType.METHOD) {
            this.putInExecutables(uniformPath, executables, entity);
        }
    }

    private String getExecutableName(ShallowEntity entity) {
        if (entity.getParent() == null) {
            if (entity.getName() != null) {
                if (entity.getType() == EShallowEntityType.METHOD) {
                    return "." + entity.getName();
                }
                return entity.getName();
            }
            return entity.getSubtype();
        }
        ShallowEntity parent = entity.getParent();
        String parentName = this.getExecutableName(parent);
        if (entity.getType() == EShallowEntityType.METHOD && entity.getSubtype().equals("start-of-selection") || entity.getType() == EShallowEntityType.ATTRIBUTE) {
            if (START_OF_SELECTION_PARENTS.contains(entity.getParent().getSubtype())) {
                return parentName + ".START-OF-SELECTION";
            }
            return parentName + "._init_";
        }
        return parentName + "." + entity.getName();
    }

    static {
        RULES.add((Object)new AbapShallowEntityMatcher("try"), (Object)new TryCatchFinallyRule(new AbapShallowEntityMatcher("catch"), new AbapShallowEntityMatcher("cleanup")));
        RULES.add((Object)AbapShallowEntityMatcher.RETURN_MATCHER, (Object)new ReturnRule());
        RULES.add((Object)new AbapShallowEntityMatcher("continue"), (Object)new ContinueRule());
        RULES.add((Object)new AbapShallowEntityMatcher("exit"), (Object)new BreakRule());
        RULES.add((Object)ShallowEntityTypeMatcher.METHOD_MATCHER, (Object)new FunctionLikeRule());
        RULES.add((Object)new AbapShallowEntityMatcher("if"), (Object)new IfWithoutParenthesesRule(new AbapShallowEntityMatcher("elseif"), new AbapShallowEntityMatcher("else")));
        RULES.add((Object)new AbapShallowEntityMatcher("on change"), (Object)new OnChangeRule(new AbapShallowEntityMatcher("else")));
        RULES.add((Object)new AbapShallowEntityMatcher("do"), (Object)new DoRule());
        RULES.add((Object)new AbapShallowEntityMatcher("when"), (Object)new CaseLabelRule(false, new AbapShallowEntityMatcher("when"), AbapShallowEntityMatcher.WHEN_OTHERS_MATCHER, IShallowEntityMatcher.NULL_MATCHER, AbapShallowEntityMatcher.RETURN_MATCHER, "when", "."));
        RULES.add((Object)new AbapShallowEntityMatcher("case"), (Object)new SwitchWithoutParenthesesRule());
        RULES.add((Object)new ShallowEntityOrMatcher(new AbapShallowEntityMatcher("while"), new AbapShallowEntityMatcher("loop"), new AbapShallowEntityMatcher("provide"), new AbapShallowEntityMatcher("select block")), (Object)new LoopRule());
        RULES.add((Object)new AbapShallowEntityMatcher("AT"), (Object)new AbapAtRule());
        RULES.add((Object)new AbapShallowEntityMatcher("catch", new TokenPattern().beginningOfStream().sequence(new Object[]{ETokenType.CATCH, ETokenType.SYSTEM_EXCEPTIONS})), (Object)new AnonymousBlockRule());
        RULES.add((Object)AbapShallowEntityMatcher.TRANSPARENT_ENTITIES, (Object)new AnonymousBlockRule());
        RULES.add((Object)AbapShallowEntityMatcher.UNINTERESTING_ENTITIES, (Object)new IgnoreRule());
        RULES.add((Object)AbapShallowEntityMatcher.SIMPLE_STATEMENT_MATCHER, (Object)new SimpleAndChainStatementRule());
        START_OF_SELECTION_PARENTS = CollectionUtils.asHashSet((Object[])new String[]{"report", "program"});
    }

    public static final class ExecutableComparator
    implements Comparator<Pair<String, List<ShallowEntity>>> {
        @Override
        public int compare(Pair<String, List<ShallowEntity>> executable1, Pair<String, List<ShallowEntity>> executable2) {
            String executable2ContainerName;
            boolean isStartOfSelection2;
            Pair<String, String> executable1Names = AbapDataFlowHeuristic.splitContainerAndMethodName((String)executable1.getFirst());
            Pair<String, String> executable2Names = AbapDataFlowHeuristic.splitContainerAndMethodName((String)executable2.getFirst());
            String executable1MethodName = (String)executable1Names.getSecond();
            String executable2MethodName = (String)executable2Names.getSecond();
            boolean isStartOfSelection1 = AbapDataFlowHeuristic.isStartOfSelectionOrInit(executable1MethodName);
            if (isStartOfSelection1 != (isStartOfSelection2 = AbapDataFlowHeuristic.isStartOfSelectionOrInit(executable2MethodName))) {
                if (isStartOfSelection1) {
                    return -1;
                }
                return 1;
            }
            String executable1ContainerName = (String)executable1Names.getFirst();
            if (executable1ContainerName.equals(executable2ContainerName = (String)executable2Names.getFirst())) {
                return executable1MethodName.compareTo(executable2MethodName);
            }
            if (executable2ContainerName.startsWith(executable1ContainerName)) {
                return -1;
            }
            if (executable1ContainerName.startsWith(executable2ContainerName)) {
                return 1;
            }
            return ((String)executable1.getFirst()).compareTo((String)executable2.getFirst());
        }
    }
}

