/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.cs.rules;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.MethodRuleBase;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class MethodRule
extends MethodRuleBase {
    private static final TokenPattern CONSTRUCTOR_INVOCATION_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.RPAREN, ETokenType.COLON, EnumSet.of(ETokenType.BASE, ETokenType.THIS), ETokenType.LPAREN}).group(0);
    private static final TokenPattern TUPLE_METHODS_PATTERN = new TokenPattern().repeatedAtLeastOnce(new Object[]{MethodRule.getTypeModifier()}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false).optional(new Object[]{ETokenType.QUESTION}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).skipNested((Object)ETokenType.LT, (Object)ETokenType.GT, true).sequence(new Object[]{ETokenType.LPAREN});
    private static final TokenPattern TUPLE_OPERATOR_PATTERN = new TokenPattern().repeatedAtLeastOnce(new Object[]{MethodRule.getTypeModifier(), ETokenType.IMPLICIT}).sequence(new Object[]{ETokenType.OPERATOR}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false).skipNested((Object)ETokenType.LT, (Object)ETokenType.GT, true).sequence(new Object[]{ETokenType.LPAREN}).group(0);

    private static EnumSet<ETokenType> getTypeModifier() {
        return EnumSet.of(ETokenType.PUBLIC, new ETokenType[]{ETokenType.PRIVATE, ETokenType.ABSTRACT, ETokenType.SEALED, ETokenType.INTERNAL, ETokenType.PARTIAL, ETokenType.STATIC, ETokenType.PROTECTED, ETokenType.VIRTUAL, ETokenType.ASYNC, ETokenType.CONST, ETokenType.EVENT, ETokenType.EXTERN, ETokenType.OVERRIDE, ETokenType.READONLY, ETokenType.UNSAFE, ETokenType.VOLATILE, ETokenType.NEW});
    }

    @Override
    public IControlFlowRule.Result transform(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator) throws ConQATException {
        if (MethodRule.isLocalFunctionAfterReturn(entities.get(0), context)) {
            return null;
        }
        IControlFlowRule.Result result = super.transform(entities, context, creator);
        UnmodifiableList methodTokens = entities.get(0).ownStartTokens();
        TokenPatternMatch constructorMatch = new TokenPattern().sequence(new Object[]{ETokenType.COLON}).alternative(new Object[]{ETokenType.BASE, ETokenType.THIS}).group(0).sequence(new Object[]{ETokenType.LPAREN}).findFirstMatch((List)methodTokens);
        if (constructorMatch != null) {
            int constructorCallStartIndex = (Integer)constructorMatch.groupIndices(0).get(0);
            int constructorCallEndIndex = TokenStreamUtils.lastTokenMatching((List)methodTokens, (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.DOUBLE_ARROW}));
            List<IToken> constructorCallTokens = methodTokens.subList(constructorCallStartIndex, constructorCallEndIndex);
            ControlFlowNode constructorNode = context.createNode(constructorCallTokens, false);
            ControlFlowNode.weaveAfter(result.getEntryNode(), constructorNode);
        }
        return result;
    }

    @Override
    protected List<IToken> extractParameterListTokens(ShallowEntity methodEntity) {
        int parameterEndIndex;
        UnmodifiableList methodTokens = methodEntity.ownStartTokens();
        int startIndex = MethodRule.findStartIndexToSearch((List<IToken>)methodTokens);
        int parameterStartIndex = TokenStreamUtils.findFirstTopLevel((List)methodTokens, (int)startIndex, (ITokenMatcher)ETokenType.LPAREN, Collections.singletonList(ETokenType.LT), Collections.singletonList(ETokenType.GT)) + 1;
        TokenPatternMatch constructorMatch = CONSTRUCTOR_INVOCATION_PATTERN.findFirstMatch((List)methodTokens);
        if (constructorMatch != null) {
            IToken firstToken = (IToken)constructorMatch.groupTokens(0).getFirst();
            parameterEndIndex = methodTokens.indexOf(firstToken);
        } else {
            parameterEndIndex = TokenStreamUtils.lastTokenMatching((List)methodTokens, (ITokenMatcher)ETokenType.RPAREN);
        }
        TokenPatternMatch match = new TokenPattern().sequence(new Object[]{ETokenType.RPAREN, ETokenType.WHERE}).group(0).findFirstMatch((List)methodTokens);
        if (match != null) {
            parameterEndIndex = (Integer)match.groupIndices(0).get(0);
        }
        Object parameterTokens = CollectionUtils.emptyList();
        if (parameterStartIndex != -1 && parameterEndIndex != -1) {
            parameterTokens = methodTokens.subList(parameterStartIndex, parameterEndIndex);
        }
        return parameterTokens;
    }

    private static int findStartIndexToSearch(List<IToken> methodTokens) {
        TokenPatternMatch tupleMethodMatch = TUPLE_METHODS_PATTERN.findFirstMatch(methodTokens);
        if (tupleMethodMatch != null && !tupleMethodMatch.groupTokens(0).isEmpty()) {
            IToken methodNameToken = (IToken)tupleMethodMatch.groupTokens(0).get(0);
            return methodTokens.indexOf(methodNameToken);
        }
        tupleMethodMatch = TUPLE_OPERATOR_PATTERN.findFirstMatch(methodTokens);
        if (tupleMethodMatch != null && !tupleMethodMatch.groupTokens(0).isEmpty()) {
            return (Integer)tupleMethodMatch.groupIndices(0).get(0);
        }
        return 0;
    }

    private static boolean isLocalFunctionAfterReturn(ShallowEntity entity, DataFlowContext context) {
        boolean isLocalFunction = EShallowEntityType.METHOD == entity.getType() && "local function".equals(entity.getSubtype());
        boolean hasReturnStatement = !context.getReturnNodes().isEmpty();
        return isLocalFunction && hasReturnStatement;
    }
}

