/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.rules;

import com.google.common.collect.Iterables;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.IShallowEntityMatcher;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class RuleUtils {
    private static final TokenPattern SIMPLE_BOOLEAN_EXPRESSION_PATTERN = new TokenPattern().optional(new Object[]{ETokenType.NOT}).group(0).alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.BOOLEAN_LITERAL}).group(1), new TokenPattern().repeated(new Object[]{ETokenType.LPAREN}).sequence(new Object[]{ETokenType.BOOLEAN_LITERAL}).group(1).repeated(new Object[]{ETokenType.RPAREN})});

    public static IControlFlowRule.Result transformInNewScope(ControlFlowCreator creator, DataFlowContext context, List<ShallowEntity> children) throws ConQATException {
        context.getDefUseHeuristic().openNewScope();
        IControlFlowRule.Result body = RuleUtils.transformWithoutLambdasOrNestedFunctions(creator, children);
        context.getDefUseHeuristic().closeCurrentScope();
        return body;
    }

    public static IControlFlowRule.Result transformWithoutLambdasOrNestedFunctions(ControlFlowCreator creator, List<ShallowEntity> children) throws ConQATException {
        return creator.transform(CollectionUtils.filter(children, c -> !ShallowParsingUtils.isLambdaMethod((ShallowEntity)c)));
    }

    public static List<IToken> getTokensBetweenFirstParenthesisPair(ShallowEntity entity) {
        return TokenStreamUtils.tokensBetweenWithNesting((List)entity.includedTokens(), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
    }

    public static List<IToken> getTokensUpToAndIncludingFirstParenthesisPair(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        int openingParenthesis = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.LPAREN);
        if (openingParenthesis == -1) {
            return entity.ownStartTokens();
        }
        int closingParenthesis = TokenStreamUtils.findMatchingClosingToken((List)tokens, (int)(openingParenthesis + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        if (closingParenthesis == -1) {
            return entity.ownStartTokens();
        }
        return tokens.subList(0, closingParenthesis + 1);
    }

    public static IControlFlowRule.Result parseEntityIfExists(IShallowEntityMatcher matcher, List<ShallowEntity> entities, ControlFlowCreator creator, DataFlowContext context, int index) throws ConQATException {
        if (index >= entities.size()) {
            return null;
        }
        ShallowEntity entity = entities.get(index);
        if (!matcher.matches(entity)) {
            return null;
        }
        return RuleUtils.transformInNewScope(creator, context, (List<ShallowEntity>)entity.getChildren());
    }

    public static void attachLambdaGraphs(ShallowEntity parentStatement, DataFlowContext context, ControlFlowCreator creator, ControlFlowNode parentNode) throws ConQATException {
        for (ShallowEntity lambda : CollectionUtils.filter((Collection)parentStatement.getChildren(), ShallowParsingUtils::isLambdaMethod)) {
            RuleUtils.attachLambdaGraph(context, creator, parentNode, lambda);
        }
    }

    public static void attachLambdaGraphs(ShallowEntity parentStatement, DataFlowContext context, ControlFlowCreator creator, ControlFlowNode ... parentNodeCandidates) throws ConQATException {
        block0: for (ShallowEntity lambda : CollectionUtils.filter((Collection)parentStatement.getChildren(), ShallowParsingUtils::isLambdaMethod)) {
            for (ControlFlowNode parentNodeCandidate : parentNodeCandidates) {
                IToken firstLambdaToken;
                List<IToken> candidateTokens = parentNodeCandidate.getTokens();
                if (!candidateTokens.contains(firstLambdaToken = (IToken)lambda.includedTokens().get(0))) continue;
                RuleUtils.attachLambdaGraph(context, creator, parentNodeCandidate, lambda);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void attachLambdaGraph(DataFlowContext context, ControlFlowCreator creator, ControlFlowNode parentNode, ShallowEntity lambdaChild) throws ConQATException {
        context.saveCurrentReturnNodes();
        try {
            ControlFlowGraph lambdaCfg = RuleUtils.generateCfgForLambdaFunction(creator, lambdaChild);
            parentNode.attachLambdaOrNestedFunction(lambdaCfg);
        }
        finally {
            context.restorePreviousReturnNodes();
        }
    }

    private static ControlFlowGraph generateCfgForLambdaFunction(ControlFlowCreator creator, ShallowEntity lambdaChild) throws ConQATException {
        IControlFlowRule.Result result = creator.transform(Collections.singletonList(lambdaChild));
        ControlFlowNode exitNode = (ControlFlowNode)Iterables.getOnlyElement(result.getExitNodes());
        return new ControlFlowGraph(result.getEntryNode(), exitNode, lambdaChild.getName(), Collections.singletonList(lambdaChild), false);
    }

    public static boolean isConditionAlwaysTrue(List<IToken> ifCondition) {
        TokenPatternMatch match = SIMPLE_BOOLEAN_EXPRESSION_PATTERN.matchAtStartOf(ifCondition);
        if (match == null) {
            return false;
        }
        boolean isNegated = !match.groupString(0).isEmpty();
        boolean isTrue = match.groupString(1).equalsIgnoreCase("true");
        return isTrue && !isNegated || !isTrue && isNegated;
    }
}

