/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters;

import com.google.common.base.Strings;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.core.ConQATException;

public class NullSafeMethodsFalsePositiveFilter
implements IFalsePositiveFilter {
    private final Set<String> methodNames;

    public NullSafeMethodsFalsePositiveFilter(Set<String> methodNames) {
        this.methodNames = methodNames;
    }

    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph, List<ShallowEntity> fileEntities, TokenElementInfo element) throws ConQATException {
        for (String methodName : this.methodNames) {
            String methodCall = variable + "." + methodName + "(";
            if (!TokenStreamTextUtils.concatTokenTexts(statement.getTokens()).contains(methodCall)) continue;
            return true;
        }
        return this.isExtensionMethodInvocation(variable, statement, fileEntities);
    }

    private boolean isExtensionMethodInvocation(String variable, ControlFlowNode statement, List<ShallowEntity> fileEntities) {
        String methodName = this.extractInvocationMethodName(variable, statement);
        if (!NullSafeMethodsFalsePositiveFilter.isMethodInvocation(statement) || Strings.isNullOrEmpty((String)methodName)) {
            return false;
        }
        for (ShallowEntity entity : ShallowEntityTraversalUtils.listMethodsNonRecursive(fileEntities)) {
            String entityName = entity.getName();
            if (Strings.isNullOrEmpty((String)entityName) || !entityName.equals(methodName) || !this.isExtensionMethod(entity, methodName)) continue;
            return true;
        }
        return false;
    }

    private @Nullable String extractInvocationMethodName(String variable, ControlFlowNode statement) {
        String methodInvocationRegex = variable + "\\.(.*)\\(.*\\)";
        String statementText = TokenStreamTextUtils.concatTokenTexts(statement.getTokens());
        Matcher matcher = Pattern.compile(methodInvocationRegex).matcher(statementText);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }

    private static boolean isMethodInvocation(ControlFlowNode statement) {
        return TokenStreamUtils.containsSequence(statement.getTokens(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN});
    }

    private boolean isExtensionMethod(ShallowEntity entity, String methodName) {
        TokenPattern pattern = new TokenPattern().sequence(new Object[]{ETokenType.STATIC}).skipUntil(new Object[]{ETokenType.IDENTIFIER}).regex(methodName).sequence(new Object[]{ETokenType.LPAREN}).sequence(new Object[]{ETokenType.THIS});
        return pattern.findFirstMatch((List)entity.includedTokens()) != null;
    }
}

