/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class TrivialValueDeadStoreFilter
implements IFalsePositiveFilter {
    private HashSet<String> ignoredValues;

    public TrivialValueDeadStoreFilter(List<String> ignoredValues) {
        this.ignoredValues = new HashSet<String>(ignoredValues);
    }

    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph, List<ShallowEntity> entities, TokenElementInfo element) {
        Optional<String> rightSide = TrivialValueDeadStoreFilter.getRightSide(statement);
        return rightSide.isPresent() && this.ignoredValues.contains(rightSide.get());
    }

    private static Optional<String> getRightSide(ControlFlowNode statement) {
        List<Object> tokens = new ArrayList<IToken>(statement.getTokens());
        int indexOfFirstEq = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.EQ);
        if (indexOfFirstEq == -1) {
            return Optional.empty();
        }
        tokens.removeAll(tokens.subList(0, indexOfFirstEq + 1));
        tokens = TokenStreamUtils.removeAtEnd(tokens, (ETokenType)ETokenType.SEMICOLON);
        return Optional.of(TokenStreamTextUtils.concatTokenTexts(tokens));
    }
}

