/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters.cs;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.cs.CsCheckUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionMap;
import org.conqat.lib.commons.collections.SetMap;

public class CsDelegateParameterFilter
implements IFalsePositiveFilter {
    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph, List<ShallowEntity> entities, TokenElementInfo element) {
        HashSet parameters = new HashSet(TokenStreamUtils.getTokenTextsByType(controlFlowGraph.getRoot().getTokens(), (ETokenType)ETokenType.IDENTIFIER));
        if (!parameters.contains(variable)) {
            return false;
        }
        Set<String> possibleReferences = CsDelegateParameterFilter.getPossibleMethodReferences(entities);
        return possibleReferences.contains(controlFlowGraph.getMethodName());
    }

    private static Set<String> getPossibleMethodReferences(List<ShallowEntity> entities) {
        List<IToken> tokens = CsDelegateParameterFilter.getAllStatementTokens(entities);
        SetMap possibleReferences = new SetMap();
        possibleReferences.addAll((CollectionMap)CsCheckUtils.retrieveMethodReferences(tokens));
        return possibleReferences.getKeys();
    }

    private static List<IToken> getAllStatementTokens(List<ShallowEntity> entities) {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        for (ShallowEntity statementEntity : ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.STATEMENT)) {
            tokens.addAll((Collection<IToken>)statementEntity.ownStartTokens());
        }
        return tokens;
    }
}

