/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.abap;

import com.teamscale.index.dependencies.ITypeLookupEnvironment;
import com.teamscale.index.dependencies.abap.AbapTypeNameUtils;
import com.teamscale.index.dependencies.type.AliasMethodSignature;
import com.teamscale.index.dependencies.type.DetailedMethodSignature;
import com.teamscale.index.dependencies.type.MethodSignature;
import com.teamscale.index.dependencies.type.Type;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypeTrackerFactory;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class AbapGlobalTypeResolutionUtils {
    private static final ETokenType[] INSTANCE_METHOD_CALL_SEQUENCE = new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.ARROW, ETokenType.IDENTIFIER, ETokenType.LPAREN};
    private static final ETokenType[] INSTANCE_INTERFACE_METHOD_CALL_SEQUENCE = new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.ARROW, ETokenType.IDENTIFIER, ETokenType.TILDE, ETokenType.IDENTIFIER, ETokenType.LPAREN};
    static final ETokenType[] CONSTRUCTOR_CALL_SEQUENCE = new ETokenType[]{ETokenType.NEW, ETokenType.IDENTIFIER, ETokenType.LPAREN};
    private static final ETokenType[] INLINE_DATA_DECLARATION_SEQUENCE = new ETokenType[]{ETokenType.DATA, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.EQ};
    static final String IMPLICIT_TYPE = "#";
    static final Pattern MEMBER_PATTERN = Pattern.compile("(\\S+)\\s*(->|=>|~)\\s*(\\S+)");
    private static final Pattern COMPONENT_OF_STRUCT_PATTERN = Pattern.compile("(.*?)-[^>].*");

    private AbapGlobalTypeResolutionUtils() {
    }

    static ITypeResolution createGlobalTypeResolution(List<ShallowEntity> entities, ITypeLookupEnvironment typeLookupEnvironment) {
        ITypeResolution typeResolution = TypeTrackerFactory.createTypeTracker((ELanguage)ELanguage.ABAP).createTypeResolution(entities);
        AbapGlobalTypeResolutionUtils.fixDynamicTypes(typeResolution.getAllTypeLookups(), typeLookupEnvironment);
        return typeResolution;
    }

    private static void fixDynamicTypes(Set<ScopedTypeLookup> allTypeLookups, ITypeLookupEnvironment typeLookupEnvironment) {
        for (ScopedTypeLookup dynamicTypeLookup : allTypeLookups) {
            List<TypedVariable> unknownTypedVariables = AbapGlobalTypeResolutionUtils.extractVariablesWithUnknownType(dynamicTypeLookup);
            for (TypedVariable currentUnknownType : unknownTypedVariables) {
                AbapGlobalTypeResolutionUtils.fixUnknownTypeInDynamicTypeLookup(currentUnknownType, dynamicTypeLookup, typeLookupEnvironment);
            }
        }
    }

    private static void fixUnknownTypeInDynamicTypeLookup(TypedVariable currentUnknownType, ScopedTypeLookup dynamicTypeLookup, ITypeLookupEnvironment typeLookupEnvironment) {
        UnmodifiableList declaringTokens = currentUnknownType.getDeclaringEntity().ownStartTokens();
        if (!TokenStreamUtils.hasTokenTypeSequence((List)declaringTokens, (int)0, (ETokenType[])INLINE_DATA_DECLARATION_SEQUENCE)) {
            return;
        }
        if (TokenStreamUtils.hasTokenTypeSequence((List)declaringTokens, (int)5, (ETokenType[])CONSTRUCTOR_CALL_SEQUENCE)) {
            String typeName = ((IToken)declaringTokens.get(6)).getText();
            if (typeName.equals(IMPLICIT_TYPE)) {
                return;
            }
            dynamicTypeLookup.putTypeInfo(currentUnknownType.getVariableName(), new TypedVariable(currentUnknownType.getVariableName(), typeName, currentUnknownType.getModifiers(), currentUnknownType.getDeclaringEntity()));
        } else if (TokenStreamUtils.hasTokenTypeSequence((List)declaringTokens, (int)5, (ETokenType[])INSTANCE_METHOD_CALL_SEQUENCE)) {
            AbapGlobalTypeResolutionUtils.fixDataTypeForInstanceMethodCall(currentUnknownType, (List<IToken>)declaringTokens, dynamicTypeLookup, typeLookupEnvironment);
        } else if (TokenStreamUtils.hasTokenTypeSequence((List)declaringTokens, (int)5, (ETokenType[])INSTANCE_INTERFACE_METHOD_CALL_SEQUENCE)) {
            AbapGlobalTypeResolutionUtils.fixDataTypeFromFixedTargetDynamicCall(currentUnknownType, (List<IToken>)declaringTokens, dynamicTypeLookup, typeLookupEnvironment);
        }
    }

    private static List<TypedVariable> extractVariablesWithUnknownType(ScopedTypeLookup typeLookup) {
        return typeLookup.getAllVariables().stream().map(arg_0 -> ((ScopedTypeLookup)typeLookup).getTypeInfo(arg_0)).filter(variable -> variable.getTypeNameWithoutGenericTypeParameter().equals("dynamicType")).sorted(Comparator.comparing(var -> var.getDeclaringEntity().getStartOffset())).collect(Collectors.toList());
    }

    private static void fixDataTypeForInstanceMethodCall(TypedVariable currentUnknownType, List<IToken> declaringTokens, ScopedTypeLookup dynamicTypeLookup, ITypeLookupEnvironment typeLookupEnvironment) {
        TypedVariable calledTypeVariable = dynamicTypeLookup.getTypeInfo(declaringTokens.get(5).getText());
        if (calledTypeVariable == null || "dynamicType".equals(calledTypeVariable.getTypeNameWithoutGenericTypeParameter())) {
            return;
        }
        String calledTypeName = AbapGlobalTypeResolutionUtils.stripRefTo(calledTypeVariable.getTypeNameWithoutGenericTypeParameter()).toUpperCase();
        Type calledType = typeLookupEnvironment.lookupType(calledTypeName + "@" + String.valueOf(EAbapObjectType.CLAS));
        if (calledType == null && (calledType = typeLookupEnvironment.lookupType(calledTypeName + "@" + String.valueOf(EAbapObjectType.INTF))) == null) {
            return;
        }
        Optional<String> returnType = AbapGlobalTypeResolutionUtils.getCalledMethodReturnType(declaringTokens.get(7).getText(), calledType, typeLookupEnvironment);
        if (returnType.isPresent()) {
            dynamicTypeLookup.putTypeInfo(currentUnknownType.getVariableName(), new TypedVariable(currentUnknownType.getVariableName(), returnType.get(), currentUnknownType.getModifiers(), currentUnknownType.getDeclaringEntity()));
        }
    }

    private static void fixDataTypeFromFixedTargetDynamicCall(TypedVariable currentUnknownType, List<IToken> declaringTokens, ScopedTypeLookup dynamicTypeLookup, ITypeLookupEnvironment typeLookupEnvironment) {
        Type calledType = typeLookupEnvironment.lookupType(declaringTokens.get(7).getText().toUpperCase() + "@" + String.valueOf(EAbapObjectType.INTF));
        if (calledType == null) {
            return;
        }
        Optional<String> returnType = AbapGlobalTypeResolutionUtils.getCalledMethodReturnType(declaringTokens.get(9).getText(), calledType, typeLookupEnvironment);
        if (returnType.isPresent()) {
            dynamicTypeLookup.putTypeInfo(currentUnknownType.getVariableName(), new TypedVariable(currentUnknownType.getVariableName(), returnType.get(), currentUnknownType.getModifiers(), currentUnknownType.getDeclaringEntity()));
        }
    }

    private static Optional<String> getCalledMethodReturnType(String methodName, Type calledType, ITypeLookupEnvironment typeLookupEnvironment) {
        return AbapGlobalTypeResolutionUtils.getCalledMethodSignature(methodName, calledType, typeLookupEnvironment).flatMap(AbapGlobalTypeResolutionUtils::getMethodReturnType);
    }

    static Optional<String> getMethodReturnType(DetailedMethodSignature calledMethodSignature) {
        Optional<TypedVariable> returnType = calledMethodSignature.parameters.stream().filter(parameter -> parameter.hasModifier(ETokenType.RETURNING)).findAny();
        if (returnType.isEmpty()) {
            return Optional.empty();
        }
        String returnTypeName = AbapGlobalTypeResolutionUtils.stripRefTo(returnType.get().getTypeNameWithoutGenericTypeParameter());
        Matcher m = COMPONENT_OF_STRUCT_PATTERN.matcher(returnTypeName);
        if (m.matches()) {
            returnTypeName = m.group(1);
        }
        return Optional.of(returnTypeName);
    }

    static Optional<DetailedMethodSignature> getCalledMethodSignature(String methodName, Type calledType, ITypeLookupEnvironment typeLookupEnvironment) {
        MethodSignature implementingMethod = (MethodSignature)CollectionUtils.getAny((Iterable)CollectionUtils.filter((Collection)Optional.ofNullable(calledType.getMethods()).orElse(Collections.emptyList()), method -> method.methodName.equalsIgnoreCase(methodName)));
        if (implementingMethod == null || implementingMethod instanceof DetailedMethodSignature && ((DetailedMethodSignature)implementingMethod).modifiers.contains((Object)ETokenType.REDEFINITION)) {
            Optional<DetailedMethodSignature> calledSignature = AbapGlobalTypeResolutionUtils.getMethodSignatureFromSupertype(methodName, calledType, typeLookupEnvironment);
            if (calledSignature.isPresent()) {
                return calledSignature;
            }
        } else {
            if (implementingMethod instanceof DetailedMethodSignature) {
                return Optional.of((DetailedMethodSignature)implementingMethod);
            }
            if (implementingMethod instanceof AliasMethodSignature) {
                AliasMethodSignature alias = (AliasMethodSignature)implementingMethod;
                Optional<Type> referencedType = AbapGlobalTypeResolutionUtils.lookupType(alias.referencedType, typeLookupEnvironment, EAbapObjectType.ALL_OO_TYPES);
                if (referencedType.isEmpty()) {
                    return Optional.empty();
                }
                return AbapGlobalTypeResolutionUtils.getCalledMethodSignature(alias.referencedMethod, referencedType.get(), typeLookupEnvironment);
            }
        }
        return Optional.empty();
    }

    private static Optional<DetailedMethodSignature> getMethodSignatureFromSupertype(String methodName, Type calledType, ITypeLookupEnvironment typeLookupEnvironment) {
        for (String supertypeName : Optional.ofNullable(calledType.getSuperTypes()).orElse(Collections.emptyList())) {
            Optional<DetailedMethodSignature> calledSignature;
            Optional<Type> supertype = AbapGlobalTypeResolutionUtils.lookupType(supertypeName, typeLookupEnvironment, EAbapObjectType.ALL_OO_TYPES);
            if (supertype.isEmpty() || !(calledSignature = AbapGlobalTypeResolutionUtils.getCalledMethodSignature(methodName, supertype.get(), typeLookupEnvironment)).isPresent()) continue;
            return calledSignature;
        }
        return Optional.empty();
    }

    public static Optional<Type> lookupType(String name, ITypeLookupEnvironment typeLookupEnvironment, EnumSet<EAbapObjectType> possibleObjectTypes) {
        for (EAbapObjectType objectType : possibleObjectTypes) {
            UniqueAbapElementName elementName = new UniqueAbapElementName(name, objectType);
            Type type = typeLookupEnvironment.lookupType(elementName.getUniqueName());
            if (type == null) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public static Optional<Type> findType(String typeName, ParsedAbapElementPath parsedUniformPath, ITypeLookupEnvironment typeLookupEnvironment) {
        UniqueAbapElementName outerType = parsedUniformPath.getElementName();
        if (parsedUniformPath.isClassOrInterface()) {
            outerType = new UniqueAbapElementName(parsedUniformPath.getClassName(), parsedUniformPath.getElementName().getObjectType());
        } else if (parsedUniformPath.isFunctionGroup()) {
            outerType = new UniqueAbapElementName(parsedUniformPath.getFunctionGroup(), EAbapObjectType.FUGR);
        }
        return AbapGlobalTypeResolutionUtils.findType(typeName, outerType.getUniqueName(), typeLookupEnvironment);
    }

    public static Optional<Type> findType(String typeName, String outerTypeName, ITypeLookupEnvironment typeLookupEnvironment) {
        Optional<Type> type = AbapGlobalTypeResolutionUtils.findTypeIfMemberOfClassOrInterface(typeName, typeLookupEnvironment);
        if (type.isPresent()) {
            return type;
        }
        type = AbapGlobalTypeResolutionUtils.findInnerTypeInType(outerTypeName, typeName, typeLookupEnvironment);
        if (type.isPresent()) {
            return type;
        }
        type = AbapGlobalTypeResolutionUtils.lookupType(typeName, typeLookupEnvironment, EAbapObjectType.ALL_ABAP_DATA_TYPES);
        if (type.isPresent()) {
            return type;
        }
        if (outerTypeName.contains(".")) {
            return AbapGlobalTypeResolutionUtils.findType(typeName, StringUtils.removeLastPart((String)outerTypeName, (char)'.'), typeLookupEnvironment);
        }
        return Optional.empty();
    }

    private static Optional<Type> findTypeIfMemberOfClassOrInterface(String typeName, ITypeLookupEnvironment typeLookupEnvironment) {
        Optional<Type> outerType;
        Matcher m = MEMBER_PATTERN.matcher(typeName);
        if (!m.matches()) {
            return Optional.empty();
        }
        String outerTypeName = m.group(1);
        String accessOperator = m.group(2);
        String innerTypeName = m.group(3);
        EnumSet<EAbapObjectType> possibleOuterTypeKinds = EnumSet.of(EAbapObjectType.CLAS, EAbapObjectType.INTF);
        if (accessOperator.equals("~")) {
            possibleOuterTypeKinds = EnumSet.of(EAbapObjectType.INTF);
        }
        if ((outerType = AbapGlobalTypeResolutionUtils.lookupType(outerTypeName, typeLookupEnvironment, possibleOuterTypeKinds)).isEmpty()) {
            return Optional.empty();
        }
        for (EAbapObjectType typeKind : EnumSet.of(EAbapObjectType.CLAS, EAbapObjectType.INTF, EAbapObjectType.TYPE)) {
            String localTypeName = AbapTypeNameUtils.buildInnerTypeName(outerType.get().getName(), innerTypeName, typeKind);
            if (!typeLookupEnvironment.isKnownType(localTypeName)) continue;
            return Optional.of(typeLookupEnvironment.lookupType(localTypeName));
        }
        return Optional.empty();
    }

    private static Optional<Type> findInnerTypeInType(String outerTypeName, String innerTypeName, ITypeLookupEnvironment typeLookupEnvironment) {
        for (EAbapObjectType typeKind : EnumSet.of(EAbapObjectType.CLAS, EAbapObjectType.INTF, EAbapObjectType.TYPE)) {
            String localTypeName = AbapTypeNameUtils.buildInnerTypeName(outerTypeName, innerTypeName, typeKind);
            if (!typeLookupEnvironment.isKnownType(localTypeName)) continue;
            return Optional.of(typeLookupEnvironment.lookupType(localTypeName));
        }
        return Optional.empty();
    }

    static String stripRefTo(String referenceTypeName) {
        return StringUtils.stripPrefix((String)referenceTypeName, (String)"ref to ");
    }

    public static String getReferencedAbapName(IToken token) {
        String tokenText = token.getText();
        if (token.getType().getTokenClass() == ETokenType.ETokenClass.LITERAL && tokenText.length() >= 2) {
            return tokenText.substring(1, tokenText.length() - 1).trim();
        }
        if (token.getType().getTokenClass() == ETokenType.ETokenClass.IDENTIFIER && tokenText.startsWith("@")) {
            return StringUtils.stripPrefix((String)tokenText, (String)"@").trim();
        }
        return tokenText;
    }
}

