/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.cpp;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class CppDependencyUtils {
    public static boolean isStaticMethod(ShallowEntity method) {
        for (IToken token : method.includedTokens()) {
            if (token.getType() == ETokenType.STATIC) {
                return true;
            }
            if (token.getType() != ETokenType.IDENTIFIER) continue;
            return false;
        }
        return false;
    }

    public static String getMethodName(ShallowEntity method) {
        Object name = CppDependencyUtils.getFullName(method);
        for (ShallowEntity parent = method.getParent(); parent != null && (parent.getType() == EShallowEntityType.TYPE || parent.getType() == EShallowEntityType.MODULE); parent = parent.getParent()) {
            if (StringUtils.isEmpty((String)parent.getName())) {
                return null;
            }
            name = CppDependencyUtils.getFullName(parent) + "::" + (String)name;
        }
        return name;
    }

    private static String getFullName(ShallowEntity namedElement) {
        Object name = namedElement.getName();
        UnmodifiableList tokens = namedElement.includedTokens();
        int i = 0;
        while (!((IToken)tokens.get(i)).getText().equals(name) || i + 1 < tokens.size() && ((IToken)tokens.get(i + 1)).getType() == ETokenType.SCOPE) {
            if (++i < tokens.size()) continue;
            return name;
        }
        --i;
        while (i > 0 && ((IToken)tokens.get(i)).getType() == ETokenType.SCOPE) {
            name = ((IToken)tokens.get(i - 1)).getText() + "::" + (String)name;
            i -= 2;
        }
        return name;
    }

    public static String normalizeHeaderPath(String headerPath) {
        return headerPath.toLowerCase();
    }
}

