/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.abaplint;

import com.teamscale.index.findings.abaplint.ABAPLintConfigurationFile;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class ABAPLintConfigurationFileUtils {
    public static void setDefaultValuesForCheckOptions(String abapLintConfigurationJson, List<ToolCheckOption> checkOptions, Map<String, Map<String, Object>> checkOptionsDefaultValuesFromFile) throws JsonSerializationException {
        ABAPLintConfigurationFile configurationFile = (ABAPLintConfigurationFile)JsonUtils.deserializeFromJson((String)abapLintConfigurationJson, ABAPLintConfigurationFile.class);
        for (ToolCheckOption checkOption : checkOptions) {
            Map<String, Object> checkDefaultValues = (Map<String, Object>)configurationFile.getRules().get(checkOption.checkId);
            if (checkDefaultValues == null) {
                checkDefaultValues = checkOptionsDefaultValuesFromFile.get(checkOption.checkId);
            }
            CCSMAssert.isTrue((checkDefaultValues != null ? 1 : 0) != 0, (String)"No default configuration found for check %s.".formatted(checkOption.checkId));
            String checkOptionId = ABAPLintConfigurationFileUtils.extractOptionIdFromPrefixedCheckOption(checkOption.optionId);
            Object defaultOptionValue = checkDefaultValues.get(checkOptionId);
            if (defaultOptionValue == null && (checkDefaultValues = checkOptionsDefaultValuesFromFile.get(checkOption.checkId)) != null) {
                defaultOptionValue = checkDefaultValues.get(checkOptionId);
            }
            CCSMAssert.isTrue((defaultOptionValue != null ? 1 : 0) != 0, (String)"No default value found for option %s of check %s.".formatted(checkOptionId, checkOption.checkId));
            if (checkOption.type == EToolCheckOptionType.JSON) {
                checkOption.setDefaultValue(JsonUtils.serializeToJSON((Object)defaultOptionValue));
                continue;
            }
            checkOption.setDefaultValue(defaultOptionValue.toString());
        }
    }

    public static String prefixCheckOptionId(String checkId, String optionId) {
        return checkId + "." + optionId;
    }

    public static String extractCheckIdFromPrefixedCheckOption(String prefixedCheckOptionId) {
        return prefixedCheckOptionId.substring(0, prefixedCheckOptionId.indexOf("."));
    }

    public static String extractOptionIdFromPrefixedCheckOption(String prefixedCheckOptionId) {
        return prefixedCheckOptionId.substring(prefixedCheckOptionId.indexOf(".") + 1);
    }
}

