/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint.independent_analysis;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="sonar-lint-independent-analysis-credentials", name="Credentials name for the SonarLint analysis service", type=EOptionType.SERVER, category=EOptionCategory.SERVER, orderingHint=0x7FFFFFFF, visibilityFeatureToggle=EFeatureToggle.ENABLE_INDEPENDENT_SONAR_LINT_ANALYSIS)
@IndexValueClass(containedInBackup=true)
public class SonarLintIndependentAnalysisCredentialsNameOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "sonar-lint-independent-analysis-credentials";
    public static final String OPTION_NAME = "Credentials name for the SonarLint analysis service";
    @JsonProperty(value="credentialsName")
    @OptionFieldDescription(name="Credentials name for the SonarLint analysis service", description="The name of the credentials to use for the independent SonarLint analysis service.")
    public String credentialsName = "Independent Analysis Service";

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        ExternalCredentials externalCredentials = ((ExternalCredentialsIndex)storageInfo.getGlobalStorageSystem().openGlobalIndex(ExternalCredentialsIndex.class)).getExternalCredentials(this.credentialsName);
        if (externalCredentials == null) {
            return "No external account exists with name '" + this.credentialsName + "'";
        }
        return null;
    }

    public static String getCredentialsName(ServerOptionIndex optionIndex) throws StorageException {
        SonarLintIndependentAnalysisCredentialsNameOption option = (SonarLintIndependentAnalysisCredentialsNameOption)ServerOptionRegistry.getInstance().getOption("server", OPTION_ID, null, SonarLintIndependentAnalysisCredentialsNameOption.class, (OptionIndexBase)optionIndex);
        if (option == null) {
            return null;
        }
        String credentialsName = option.credentialsName.trim();
        if (StringUtils.isEmpty((String)credentialsName)) {
            return null;
        }
        return credentialsName;
    }
}

