/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap;

import com.teamscale.index.gitbridge.GitBridgeException;
import com.teamscale.index.gitbridge.abap.AbapExportXmlTableReaderBase;
import com.teamscale.index.gitbridge.abap.AbapGitImporterUtils;
import java.io.PrintWriter;
import org.conqat.engine.abap.EThirdPartyObjectPathFields;
import org.conqat.lib.commons.filesystem.ZipFile;

public class ThirdPartyPathsReader
extends AbapExportXmlTableReaderBase<EThirdPartyObjectPathFields> {
    private final PrintWriter writer;

    private ThirdPartyPathsReader(PrintWriter writer) {
        super(EThirdPartyObjectPathFields.class);
        this.writer = writer;
    }

    public static void readFromZipAndWriteCsv(String inputFilename, ZipFile zipFile, PrintWriter outputWriter) throws GitBridgeException {
        String content = AbapGitImporterUtils.readXmlContent(zipFile, inputFilename);
        new ThirdPartyPathsReader(outputWriter).readRecords(content);
    }

    @Override
    protected EThirdPartyObjectPathFields getRecordElement() {
        return EThirdPartyObjectPathFields.item;
    }

    @Override
    protected void processRecord() {
        this.writer.print(this.getChildText(EThirdPartyObjectPathFields.OBJTYPE));
        this.writer.print(";");
        this.writer.print(this.getChildText(EThirdPartyObjectPathFields.OBJNAME));
        this.writer.print(";");
        this.writer.print(this.getChildText(EThirdPartyObjectPathFields.PATH));
        this.writer.print("\n");
    }
}

