/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap.code_inspector;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public abstract class CodeInspectorGitUtils {
    public static final String CODE_INSPECTOR_FILE_SUFFIX = ".sci";
    private static final Pattern SCI_OBJECT_TYPE_PATTERN = Pattern.compile("(?:.*/)?(?<objtype>[A-Z]{4})/[^/]+.sci");
    public static final Set<String> FAILED_EXTENDED_CHECK_MESSAGE_CODES = CollectionUtils.asHashSet((Object[])new String[]{"0000", "0033"});

    public static String buildCodeInspectorFileName(String abapFileName) {
        return FileSystemUtils.getFilenameWithoutExtension((String)abapFileName) + CODE_INSPECTOR_FILE_SUFFIX;
    }

    public static String buildAbapFileName(String ciFileName) {
        EAbapObjectType objType;
        String suffix = ".abap";
        Matcher m = SCI_OBJECT_TYPE_PATTERN.matcher(ciFileName);
        if (m.matches() && (objType = (EAbapObjectType)EnumUtils.valueOf(EAbapObjectType.class, (String)m.group("objtype"))) != null && objType.isDictionary()) {
            suffix = ".abap_ddic";
        }
        return FileSystemUtils.getFilenameWithoutExtension((String)ciFileName) + suffix;
    }
}

